/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.certificatemanager.model.CertificateStatus;
import com.amazonaws.services.certificatemanager.model.Filters;
import com.amazonaws.services.certificatemanager.model.SortBy;
import com.amazonaws.services.certificatemanager.model.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCertificatesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> certificateStatuses;
    private Filters includes;
    private String nextToken;
    private Integer maxItems;
    private String sortBy;
    private String sortOrder;

    public List<String> getCertificateStatuses() {
        return this.certificateStatuses;
    }

    public void setCertificateStatuses(Collection<String> certificateStatuses) {
        if (certificateStatuses == null) {
            this.certificateStatuses = null;
            return;
        }
        this.certificateStatuses = new ArrayList<String>(certificateStatuses);
    }

    public ListCertificatesRequest withCertificateStatuses(String ... certificateStatuses) {
        if (this.certificateStatuses == null) {
            this.setCertificateStatuses(new ArrayList<String>(certificateStatuses.length));
        }
        for (String ele : certificateStatuses) {
            this.certificateStatuses.add(ele);
        }
        return this;
    }

    public ListCertificatesRequest withCertificateStatuses(Collection<String> certificateStatuses) {
        this.setCertificateStatuses(certificateStatuses);
        return this;
    }

    public ListCertificatesRequest withCertificateStatuses(CertificateStatus ... certificateStatuses) {
        ArrayList<String> certificateStatusesCopy = new ArrayList<String>(certificateStatuses.length);
        for (CertificateStatus value : certificateStatuses) {
            certificateStatusesCopy.add(value.toString());
        }
        if (this.getCertificateStatuses() == null) {
            this.setCertificateStatuses(certificateStatusesCopy);
        } else {
            this.getCertificateStatuses().addAll(certificateStatusesCopy);
        }
        return this;
    }

    public void setIncludes(Filters includes) {
        this.includes = includes;
    }

    public Filters getIncludes() {
        return this.includes;
    }

    public ListCertificatesRequest withIncludes(Filters includes) {
        this.setIncludes(includes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCertificatesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ListCertificatesRequest withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public ListCertificatesRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public ListCertificatesRequest withSortBy(SortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public ListCertificatesRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public ListCertificatesRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateStatuses() != null) {
            sb.append("CertificateStatuses: ").append(this.getCertificateStatuses()).append(",");
        }
        if (this.getIncludes() != null) {
            sb.append("Includes: ").append(this.getIncludes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)obj;
        if (other.getCertificateStatuses() == null ^ this.getCertificateStatuses() == null) {
            return false;
        }
        if (other.getCertificateStatuses() != null && !other.getCertificateStatuses().equals(this.getCertificateStatuses())) {
            return false;
        }
        if (other.getIncludes() == null ^ this.getIncludes() == null) {
            return false;
        }
        if (other.getIncludes() != null && !other.getIncludes().equals(this.getIncludes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateStatuses() == null ? 0 : this.getCertificateStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getIncludes() == null ? 0 : this.getIncludes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public ListCertificatesRequest clone() {
        return (ListCertificatesRequest)super.clone();
    }
}

