/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.certificatemanager.AWSCertificateManager;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateRequest;
import com.amazonaws.services.certificatemanager.waiters.CertificateValidated;
import com.amazonaws.services.certificatemanager.waiters.DescribeCertificateFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSCertificateManagerWaiters {
    private final AWSCertificateManager client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSCertificateManagerWaiters");

    @SdkInternalApi
    public AWSCertificateManagerWaiters(AWSCertificateManager client) {
        this.client = client;
    }

    public Waiter<DescribeCertificateRequest> certificateValidated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCertificateFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CertificateValidated.IsSUCCESSMatcher(), new CertificateValidated.IsPENDING_VALIDATIONMatcher(), new CertificateValidated.IsFAILEDMatcher(), new CertificateValidated.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

