/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.FindingSource;
import com.amazonaws.services.accessanalyzer.model.transform.ExternalAccessDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalAccessDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> action;
    private Map<String, String> condition;
    private Boolean isPublic;
    private Map<String, String> principal;
    private List<FindingSource> sources;

    public List<String> getAction() {
        return this.action;
    }

    public void setAction(Collection<String> action) {
        if (action == null) {
            this.action = null;
            return;
        }
        this.action = new ArrayList<String>(action);
    }

    public ExternalAccessDetails withAction(String ... action) {
        if (this.action == null) {
            this.setAction(new ArrayList<String>(action.length));
        }
        for (String ele : action) {
            this.action.add(ele);
        }
        return this;
    }

    public ExternalAccessDetails withAction(Collection<String> action) {
        this.setAction(action);
        return this;
    }

    public Map<String, String> getCondition() {
        return this.condition;
    }

    public void setCondition(Map<String, String> condition) {
        this.condition = condition;
    }

    public ExternalAccessDetails withCondition(Map<String, String> condition) {
        this.setCondition(condition);
        return this;
    }

    public ExternalAccessDetails addConditionEntry(String key, String value) {
        if (null == this.condition) {
            this.condition = new HashMap<String, String>();
        }
        if (this.condition.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.condition.put(key, value);
        return this;
    }

    public ExternalAccessDetails clearConditionEntries() {
        this.condition = null;
        return this;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public ExternalAccessDetails withIsPublic(Boolean isPublic) {
        this.setIsPublic(isPublic);
        return this;
    }

    public Boolean isPublic() {
        return this.isPublic;
    }

    public Map<String, String> getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Map<String, String> principal) {
        this.principal = principal;
    }

    public ExternalAccessDetails withPrincipal(Map<String, String> principal) {
        this.setPrincipal(principal);
        return this;
    }

    public ExternalAccessDetails addPrincipalEntry(String key, String value) {
        if (null == this.principal) {
            this.principal = new HashMap<String, String>();
        }
        if (this.principal.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.principal.put(key, value);
        return this;
    }

    public ExternalAccessDetails clearPrincipalEntries() {
        this.principal = null;
        return this;
    }

    public List<FindingSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<FindingSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<FindingSource>(sources);
    }

    public ExternalAccessDetails withSources(FindingSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<FindingSource>(sources.length));
        }
        for (FindingSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public ExternalAccessDetails withSources(Collection<FindingSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getCondition() != null) {
            sb.append("Condition: ").append(this.getCondition()).append(",");
        }
        if (this.getIsPublic() != null) {
            sb.append("IsPublic: ").append(this.getIsPublic()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAccessDetails)) {
            return false;
        }
        ExternalAccessDetails other = (ExternalAccessDetails)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getCondition() == null ^ this.getCondition() == null) {
            return false;
        }
        if (other.getCondition() != null && !other.getCondition().equals(this.getCondition())) {
            return false;
        }
        if (other.getIsPublic() == null ^ this.getIsPublic() == null) {
            return false;
        }
        if (other.getIsPublic() != null && !other.getIsPublic().equals(this.getIsPublic())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getCondition() == null ? 0 : this.getCondition().hashCode());
        hashCode = 31 * hashCode + (this.getIsPublic() == null ? 0 : this.getIsPublic().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public ExternalAccessDetails clone() {
        try {
            return (ExternalAccessDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

