/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.GeneratedPolicy;
import com.amazonaws.services.accessanalyzer.model.GeneratedPolicyProperties;
import com.amazonaws.services.accessanalyzer.model.transform.GeneratedPolicyResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeneratedPolicyResult
implements Serializable,
Cloneable,
StructuredPojo {
    private GeneratedPolicyProperties properties;
    private List<GeneratedPolicy> generatedPolicies;

    public void setProperties(GeneratedPolicyProperties properties) {
        this.properties = properties;
    }

    public GeneratedPolicyProperties getProperties() {
        return this.properties;
    }

    public GeneratedPolicyResult withProperties(GeneratedPolicyProperties properties) {
        this.setProperties(properties);
        return this;
    }

    public List<GeneratedPolicy> getGeneratedPolicies() {
        return this.generatedPolicies;
    }

    public void setGeneratedPolicies(Collection<GeneratedPolicy> generatedPolicies) {
        if (generatedPolicies == null) {
            this.generatedPolicies = null;
            return;
        }
        this.generatedPolicies = new ArrayList<GeneratedPolicy>(generatedPolicies);
    }

    public GeneratedPolicyResult withGeneratedPolicies(GeneratedPolicy ... generatedPolicies) {
        if (this.generatedPolicies == null) {
            this.setGeneratedPolicies(new ArrayList<GeneratedPolicy>(generatedPolicies.length));
        }
        for (GeneratedPolicy ele : generatedPolicies) {
            this.generatedPolicies.add(ele);
        }
        return this;
    }

    public GeneratedPolicyResult withGeneratedPolicies(Collection<GeneratedPolicy> generatedPolicies) {
        this.setGeneratedPolicies(generatedPolicies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getGeneratedPolicies() != null) {
            sb.append("GeneratedPolicies: ").append(this.getGeneratedPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedPolicyResult)) {
            return false;
        }
        GeneratedPolicyResult other = (GeneratedPolicyResult)obj;
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getGeneratedPolicies() == null ^ this.getGeneratedPolicies() == null) {
            return false;
        }
        return other.getGeneratedPolicies() == null || other.getGeneratedPolicies().equals(this.getGeneratedPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getGeneratedPolicies() == null ? 0 : this.getGeneratedPolicies().hashCode());
        return hashCode;
    }

    public GeneratedPolicyResult clone() {
        try {
            return (GeneratedPolicyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeneratedPolicyResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

