/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.Configuration;

@SdkInternalApi
public class ConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> EBSSNAPSHOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebsSnapshot").build();
    private static final MarshallingInfo<StructuredPojo> ECRREPOSITORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ecrRepository").build();
    private static final MarshallingInfo<StructuredPojo> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamRole").build();
    private static final MarshallingInfo<StructuredPojo> EFSFILESYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("efsFileSystem").build();
    private static final MarshallingInfo<StructuredPojo> KMSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKey").build();
    private static final MarshallingInfo<StructuredPojo> RDSDBCLUSTERSNAPSHOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rdsDbClusterSnapshot").build();
    private static final MarshallingInfo<StructuredPojo> RDSDBSNAPSHOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rdsDbSnapshot").build();
    private static final MarshallingInfo<StructuredPojo> SECRETSMANAGERSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretsManagerSecret").build();
    private static final MarshallingInfo<StructuredPojo> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<StructuredPojo> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopic").build();
    private static final MarshallingInfo<StructuredPojo> SQSQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sqsQueue").build();
    private static final MarshallingInfo<StructuredPojo> S3EXPRESSDIRECTORYBUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3ExpressDirectoryBucket").build();
    private static final ConfigurationMarshaller instance = new ConfigurationMarshaller();

    public static ConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Configuration configuration, ProtocolMarshaller protocolMarshaller) {
        if (configuration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configuration.getEbsSnapshot(), EBSSNAPSHOT_BINDING);
            protocolMarshaller.marshall((Object)configuration.getEcrRepository(), ECRREPOSITORY_BINDING);
            protocolMarshaller.marshall((Object)configuration.getIamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)configuration.getEfsFileSystem(), EFSFILESYSTEM_BINDING);
            protocolMarshaller.marshall((Object)configuration.getKmsKey(), KMSKEY_BINDING);
            protocolMarshaller.marshall((Object)configuration.getRdsDbClusterSnapshot(), RDSDBCLUSTERSNAPSHOT_BINDING);
            protocolMarshaller.marshall((Object)configuration.getRdsDbSnapshot(), RDSDBSNAPSHOT_BINDING);
            protocolMarshaller.marshall((Object)configuration.getSecretsManagerSecret(), SECRETSMANAGERSECRET_BINDING);
            protocolMarshaller.marshall((Object)configuration.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)configuration.getSnsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall((Object)configuration.getSqsQueue(), SQSQUEUE_BINDING);
            protocolMarshaller.marshall((Object)configuration.getS3ExpressDirectoryBucket(), S3EXPRESSDIRECTORYBUCKET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

