/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.transform.KmsGrantConstraintsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KmsGrantConstraints
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> encryptionContextEquals;
    private Map<String, String> encryptionContextSubset;

    public Map<String, String> getEncryptionContextEquals() {
        return this.encryptionContextEquals;
    }

    public void setEncryptionContextEquals(Map<String, String> encryptionContextEquals) {
        this.encryptionContextEquals = encryptionContextEquals;
    }

    public KmsGrantConstraints withEncryptionContextEquals(Map<String, String> encryptionContextEquals) {
        this.setEncryptionContextEquals(encryptionContextEquals);
        return this;
    }

    public KmsGrantConstraints addEncryptionContextEqualsEntry(String key, String value) {
        if (null == this.encryptionContextEquals) {
            this.encryptionContextEquals = new HashMap<String, String>();
        }
        if (this.encryptionContextEquals.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.encryptionContextEquals.put(key, value);
        return this;
    }

    public KmsGrantConstraints clearEncryptionContextEqualsEntries() {
        this.encryptionContextEquals = null;
        return this;
    }

    public Map<String, String> getEncryptionContextSubset() {
        return this.encryptionContextSubset;
    }

    public void setEncryptionContextSubset(Map<String, String> encryptionContextSubset) {
        this.encryptionContextSubset = encryptionContextSubset;
    }

    public KmsGrantConstraints withEncryptionContextSubset(Map<String, String> encryptionContextSubset) {
        this.setEncryptionContextSubset(encryptionContextSubset);
        return this;
    }

    public KmsGrantConstraints addEncryptionContextSubsetEntry(String key, String value) {
        if (null == this.encryptionContextSubset) {
            this.encryptionContextSubset = new HashMap<String, String>();
        }
        if (this.encryptionContextSubset.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.encryptionContextSubset.put(key, value);
        return this;
    }

    public KmsGrantConstraints clearEncryptionContextSubsetEntries() {
        this.encryptionContextSubset = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionContextEquals() != null) {
            sb.append("EncryptionContextEquals: ").append(this.getEncryptionContextEquals()).append(",");
        }
        if (this.getEncryptionContextSubset() != null) {
            sb.append("EncryptionContextSubset: ").append(this.getEncryptionContextSubset());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsGrantConstraints)) {
            return false;
        }
        KmsGrantConstraints other = (KmsGrantConstraints)obj;
        if (other.getEncryptionContextEquals() == null ^ this.getEncryptionContextEquals() == null) {
            return false;
        }
        if (other.getEncryptionContextEquals() != null && !other.getEncryptionContextEquals().equals(this.getEncryptionContextEquals())) {
            return false;
        }
        if (other.getEncryptionContextSubset() == null ^ this.getEncryptionContextSubset() == null) {
            return false;
        }
        return other.getEncryptionContextSubset() == null || other.getEncryptionContextSubset().equals(this.getEncryptionContextSubset());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionContextEquals() == null ? 0 : this.getEncryptionContextEquals().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionContextSubset() == null ? 0 : this.getEncryptionContextSubset().hashCode());
        return hashCode;
    }

    public KmsGrantConstraints clone() {
        try {
            return (KmsGrantConstraints)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KmsGrantConstraintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

