/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.kms.DiscoveryFilter;
import com.amazonaws.encryptionsdk.kms.KmsMasterKey;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class KmsMasterKeyProvider
extends MasterKeyProvider<KmsMasterKey>
implements KmsMethods {
    private static final String PROVIDER_NAME = "aws-kms";
    private final List<String> keyIds_;
    private final List<String> grantTokens_;
    private static final boolean IS_DISCOVERY_DEFAULT = true;
    private final boolean isDiscovery_;
    private final DiscoveryFilter discoveryFilter_;
    private final RegionalClientSupplier regionalClientSupplier_;
    private final String defaultRegion_;

    public static Builder builder() {
        return new Builder();
    }

    private KmsMasterKeyProvider(RegionalClientSupplier supplier, String defaultRegion, List<String> keyIds, List<String> grantTokens, boolean onlyOneRegion, boolean isDiscovery, DiscoveryFilter discoveryFilter) {
        if (!isDiscovery && (keyIds == null || keyIds.isEmpty())) {
            throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
        }
        if (!isDiscovery && discoveryFilter != null) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a discovery filter.");
        }
        if (onlyOneRegion) {
            RegionalClientSupplier originalSupplier = supplier;
            supplier = region -> {
                if (!Objects.equals(region, defaultRegion)) {
                    return null;
                }
                return originalSupplier.getClient(region);
            };
        }
        this.regionalClientSupplier_ = supplier;
        this.defaultRegion_ = defaultRegion;
        this.keyIds_ = Collections.unmodifiableList(new ArrayList<String>(keyIds));
        this.isDiscovery_ = isDiscovery;
        this.discoveryFilter_ = discoveryFilter;
        this.grantTokens_ = grantTokens;
    }

    private KmsMasterKeyProvider(RegionalClientSupplier supplier, String defaultRegion, List<String> keyIds) {
        this(supplier, defaultRegion, keyIds, new ArrayList<String>(), true, true, null);
    }

    private static RegionalClientSupplier defaultProvider() {
        return KmsMasterKeyProvider.builder().clientFactory();
    }

    @Deprecated
    public KmsMasterKeyProvider() {
        this(KmsMasterKeyProvider.defaultProvider(), Regions.DEFAULT_REGION.getName(), Collections.emptyList());
    }

    @Deprecated
    public KmsMasterKeyProvider(String keyId) {
        this(KmsMasterKeyProvider.defaultProvider(), KmsMasterKeyProvider.getStartingRegion(keyId).getName(), Collections.singletonList(keyId));
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentials creds, String keyId) {
        this((AWSCredentialsProvider)new AWSStaticCredentialsProvider(creds), KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds, String keyId) {
        this(creds, KmsMasterKeyProvider.getStartingRegion(keyId), new ClientConfiguration(), keyId);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentials creds) {
        this((AWSCredentialsProvider)new AWSStaticCredentialsProvider(creds), Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds) {
        this(creds, Region.getRegion((Regions)Regions.DEFAULT_REGION), new ClientConfiguration(), Collections.emptyList());
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, String keyId) {
        this(creds, region, clientConfiguration, Collections.singletonList(keyId));
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSCredentialsProvider creds, Region region, ClientConfiguration clientConfiguration, List<String> keyIds) {
        this(KmsMasterKeyProvider.builder().withClientBuilder((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials(creds)).clientFactory(), region.getName(), keyIds);
    }

    @Deprecated
    public KmsMasterKeyProvider(AWSKMS kms, Region region, List<String> keyIds) {
        this((String requestedRegion) -> kms, region.getName(), keyIds);
        kms.setRegion(region);
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public KmsMasterKey getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException();
        }
        if (!this.isDiscovery_ && !this.keyIds_.contains(keyId)) {
            throw new NoSuchMasterKeyException("Key must be in supplied list of keyIds.");
        }
        AwsKmsCmkArnInfo arnInfo = KmsMasterKeyProvider.parseInfoFromKeyArn(keyId);
        if (this.isDiscovery_ && this.discoveryFilter_ != null && arnInfo == null) {
            throw new NoSuchMasterKeyException("Cannot use non-ARN key identifiers or aliases if discovery filter is configured.");
        }
        if (this.isDiscovery_ && this.discoveryFilter_ != null && !this.discoveryFilter_.allowsPartitionAndAccount(arnInfo.getPartition(), arnInfo.getAccountId())) {
            throw new NoSuchMasterKeyException("Cannot use key in partition " + arnInfo.getPartition() + " with account id " + arnInfo.getAccountId() + " with configured discovery filter.");
        }
        String regionName = this.defaultRegion_;
        if (arnInfo != null) {
            regionName = arnInfo.getRegion();
        }
        String regionName_ = regionName;
        Supplier<AWSKMS> kmsSupplier = () -> {
            AWSKMS kms = this.regionalClientSupplier_.getClient(regionName_);
            if (kms == null) {
                throw new AwsCryptoException("Can't use keys from region " + regionName_);
            }
            return kms;
        };
        KmsMasterKey result = KmsMasterKey.getInstance(kmsSupplier, keyId, this);
        result.setGrantTokens(this.grantTokens_);
        return result;
    }

    @Override
    public List<KmsMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.keyIds_ == null) {
            return Collections.emptyList();
        }
        ArrayList<KmsMasterKey> result = new ArrayList<KmsMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result.add((KmsMasterKey)this.getMasterKey(id));
        }
        return result;
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            if (!this.canProvide(encryptedDataKey.getProviderId())) continue;
            try {
                String keyArn = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8);
                return ((KmsMasterKey)this.getMasterKey(keyArn)).decryptDataKey(algorithm, Collections.singletonList(encryptedDataKey), encryptionContext);
            }
            catch (Exception asex) {
                exceptions.add(asex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    @Override
    @Deprecated
    public void setGrantTokens(List<String> grantTokens) {
        try {
            this.grantTokens_.clear();
            this.grantTokens_.addAll(grantTokens);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    @Override
    public List<String> getGrantTokens() {
        return new ArrayList<String>(this.grantTokens_);
    }

    @Override
    @Deprecated
    public void addGrantToken(String grantToken) {
        try {
            this.grantTokens_.add(grantToken);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    private RuntimeException grantTokenError() {
        return new IllegalStateException("This master key provider is immutable. Use withGrantTokens instead.");
    }

    public KmsMasterKeyProvider withGrantTokens(List<String> grantTokens) {
        grantTokens = Collections.unmodifiableList(new ArrayList<String>(grantTokens));
        return new KmsMasterKeyProvider(this.regionalClientSupplier_, this.defaultRegion_, this.keyIds_, grantTokens, false, this.isDiscovery_, this.discoveryFilter_);
    }

    public KmsMasterKeyProvider withGrantTokens(String ... grantTokens) {
        return this.withGrantTokens(Arrays.asList(grantTokens));
    }

    private static Region getStartingRegion(String keyArn) {
        AwsKmsCmkArnInfo arnInfo = KmsMasterKeyProvider.parseInfoFromKeyArn(keyArn);
        if (arnInfo != null) {
            return RegionUtils.getRegion((String)arnInfo.getRegion());
        }
        Region currentRegion = Regions.getCurrentRegion();
        if (currentRegion != null) {
            return currentRegion;
        }
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    private static AwsKmsCmkArnInfo parseInfoFromKeyArn(String keyArn) {
        String[] parts = keyArn.split(":", 6);
        if (!parts[0].equals("arn") || parts.length < 6) {
            return null;
        }
        if (!parts[2].equals("kms")) {
            return null;
        }
        if (parts[1].isEmpty() || parts[3].isEmpty() || parts[4].isEmpty()) {
            return null;
        }
        return new AwsKmsCmkArnInfo(parts[1], parts[3], parts[4]);
    }

    private static class SuccessfulRequestCacher
    extends RequestHandler2 {
        private final ConcurrentHashMap<String, AWSKMS> cache_;
        private final String region_;
        private AWSKMS client_;
        volatile boolean ranBefore_ = false;

        private SuccessfulRequestCacher(ConcurrentHashMap<String, AWSKMS> cache, String region) {
            this.region_ = region;
            this.cache_ = cache;
        }

        public void afterResponse(Request<?> request, Response<?> response) {
            if (this.ranBefore_) {
                return;
            }
            this.ranBefore_ = true;
            this.cache_.putIfAbsent(this.region_, this.client_);
        }

        public void afterError(Request<?> request, Response<?> response, Exception e) {
            if (this.ranBefore_) {
                return;
            }
            if (e instanceof AmazonServiceException) {
                this.ranBefore_ = true;
                this.cache_.putIfAbsent(this.region_, this.client_);
            }
        }
    }

    public static class Builder
    implements Cloneable {
        private String defaultRegion_ = null;
        private RegionalClientSupplier regionalClientSupplier_ = null;
        private AWSKMSClientBuilder templateBuilder_ = null;
        private List<String> keyIds_ = new ArrayList<String>();
        private boolean isDiscovery_ = true;
        private DiscoveryFilter discoveryFilter_ = null;

        Builder() {
        }

        public Builder clone() {
            try {
                Builder cloned = (Builder)super.clone();
                if (this.templateBuilder_ != null) {
                    cloned.templateBuilder_ = this.cloneClientBuilder(this.templateBuilder_);
                }
                cloned.keyIds_ = new ArrayList<String>(this.keyIds_);
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Impossible: CloneNotSupportedException", e);
            }
        }

        @Deprecated
        public Builder withKeysForEncryption(String ... keyIds) {
            this.keyIds_.addAll(Arrays.asList(keyIds));
            return this;
        }

        @Deprecated
        public Builder withKeysForEncryption(List<String> keyIds) {
            this.keyIds_.addAll(keyIds);
            return this;
        }

        public Builder withDefaultRegion(String defaultRegion) {
            this.defaultRegion_ = defaultRegion;
            return this;
        }

        public Builder withCustomClientFactory(RegionalClientSupplier regionalClientSupplier) {
            if (this.templateBuilder_ != null) {
                throw this.clientSupplierComboException();
            }
            this.regionalClientSupplier_ = regionalClientSupplier;
            return this;
        }

        private RuntimeException clientSupplierComboException() {
            return new IllegalStateException("withCustomClientFactory cannot be used in conjunction with withCredentials or withClientBuilder");
        }

        public Builder withCredentials(AWSCredentialsProvider credentialsProvider) {
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            if (this.templateBuilder_ == null) {
                this.templateBuilder_ = AWSKMSClientBuilder.standard();
            }
            this.templateBuilder_.setCredentials(credentialsProvider);
            return this;
        }

        public Builder withCredentials(AWSCredentials credentials) {
            return this.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials));
        }

        public Builder withClientBuilder(AWSKMSClientBuilder builder) {
            AWSKMSClientBuilder newBuilder;
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.templateBuilder_ = newBuilder = this.cloneClientBuilder(builder);
            return this;
        }

        private AWSKMSClientBuilder cloneClientBuilder(AWSKMSClientBuilder builder) {
            if (builder.getEndpoint() != null) {
                throw new IllegalArgumentException("Setting endpoint configuration is not compatible with passing a builder to the KmsMasterKeyProvider. Use withCustomClientFactory instead.");
            }
            AWSKMSClientBuilder newBuilder = AWSKMSClient.builder();
            newBuilder.setClientConfiguration(builder.getClientConfiguration());
            newBuilder.setCredentials(builder.getCredentials());
            newBuilder.setEndpointConfiguration(builder.getEndpoint());
            newBuilder.setMetricsCollector(builder.getMetricsCollector());
            if (builder.getRequestHandlers() != null) {
                newBuilder.setRequestHandlers(builder.getRequestHandlers().toArray(new RequestHandler2[0]));
            }
            return newBuilder;
        }

        public KmsMasterKeyProvider buildDiscovery() {
            if (this.keyIds_.size() > 0) {
                throw new IllegalStateException("Cannot explicitly build Discovery KMS Master Key Provider with keyIds configured");
            }
            this.isDiscovery_ = true;
            return this.buildBase();
        }

        public KmsMasterKeyProvider buildDiscovery(DiscoveryFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Discovery filter must not be null if specifying a discovery filter.");
            }
            this.discoveryFilter_ = filter;
            return this.buildDiscovery();
        }

        public KmsMasterKeyProvider buildStrict(List<String> keyIds) {
            if (keyIds == null) {
                throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
            }
            if (this.keyIds_.size() > 0) {
                throw new IllegalStateException("buildStrict cannot be used in conjunction with withKeysForEncryption. Please supply keys to encrypt and decrypt with to buildStrict()");
            }
            if (keyIds.contains(null)) {
                throw new IllegalArgumentException("Cannot configure Strict KMS Master Key Provider with null key identifier.");
            }
            this.isDiscovery_ = false;
            this.keyIds_.addAll(keyIds);
            return this.buildBase();
        }

        public KmsMasterKeyProvider buildStrict(String ... keyIds) {
            return this.buildStrict(Arrays.asList(keyIds));
        }

        @Deprecated
        public KmsMasterKeyProvider build() {
            return this.buildBase();
        }

        private KmsMasterKeyProvider buildBase() {
            if (this.defaultRegion_ == null) {
                for (String keyId : this.keyIds_) {
                    AwsKmsCmkArnInfo arnInfo = KmsMasterKeyProvider.parseInfoFromKeyArn(keyId);
                    if (arnInfo != null) continue;
                    throw new AwsCryptoException("Can't use non-ARN key identifiers or aliases when no default region is set");
                }
            }
            RegionalClientSupplier supplier = this.clientFactory();
            return new KmsMasterKeyProvider(supplier, this.defaultRegion_, this.keyIds_, Collections.emptyList(), false, this.isDiscovery_, this.discoveryFilter_);
        }

        private RegionalClientSupplier clientFactory() {
            if (this.regionalClientSupplier_ != null) {
                return this.regionalClientSupplier_;
            }
            AWSKMSClientBuilder builder = this.templateBuilder_ != null ? this.cloneClientBuilder(this.templateBuilder_) : AWSKMSClientBuilder.standard();
            ConcurrentHashMap<String, AWSKMS> clientCache = new ConcurrentHashMap<String, AWSKMS>();
            this.snoopClientCache(clientCache);
            return region -> {
                AWSKMS kms = (AWSKMS)clientCache.get(region);
                if (kms != null) {
                    return kms;
                }
                SuccessfulRequestCacher cacher = new SuccessfulRequestCacher(clientCache, region);
                ArrayList<SuccessfulRequestCacher> handlers = new ArrayList<SuccessfulRequestCacher>();
                if (builder.getRequestHandlers() != null) {
                    handlers.addAll(builder.getRequestHandlers());
                }
                handlers.add(cacher);
                kms = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)this.cloneClientBuilder(builder).withRegion(region)).withRequestHandlers(handlers.toArray(new RequestHandler2[handlers.size()]))).build();
                cacher.client_ = kms;
                return kms;
            };
        }

        protected void snoopClientCache(ConcurrentHashMap<String, AWSKMS> map) {
        }
    }

    @FunctionalInterface
    public static interface RegionalClientSupplier {
        public AWSKMS getClient(String var1);
    }
}

