/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class EncryptionContext {
    private final String tableName;
    private final Map<String, AttributeValue> attributeValues;
    private final Class<?> modeledClass;
    private final Object developerContext;
    private final String hashKeyName;
    private final String rangeKeyName;
    private final Map<String, String> materialDescription;

    private EncryptionContext(Builder builder) {
        this.tableName = builder.getTableName();
        this.attributeValues = builder.getAttributeValues();
        this.modeledClass = builder.getModeledClass();
        this.developerContext = builder.getDeveloperContext();
        this.hashKeyName = builder.getHashKeyName();
        this.rangeKeyName = builder.getRangeKeyName();
        this.materialDescription = builder.getMaterialDescription();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> getAttributeValues() {
        return this.attributeValues;
    }

    public Class<?> getModeledClass() {
        return this.modeledClass;
    }

    public Object getDeveloperContext() {
        return this.developerContext;
    }

    public String getHashKeyName() {
        return this.hashKeyName;
    }

    public String getRangeKeyName() {
        return this.rangeKeyName;
    }

    public Map<String, String> getMaterialDescription() {
        return this.materialDescription;
    }

    public String toString() {
        return "EncryptionContext [tableName=" + this.tableName + ", attributeValues=" + this.attributeValues + ", modeledClass=" + this.modeledClass + ", developerContext=" + this.developerContext + ", hashKeyName=" + this.hashKeyName + ", rangeKeyName=" + this.rangeKeyName + ", materialDescription=" + this.materialDescription + "]";
    }

    public static final class Builder {
        private String tableName = null;
        private Map<String, AttributeValue> attributeValues = null;
        private Class<?> modeledClass = null;
        private Object developerContext = null;
        private String hashKeyName = null;
        private String rangeKeyName = null;
        private Map<String, String> materialDescription = null;

        public Builder() {
        }

        public Builder(EncryptionContext context) {
            this.tableName = context.getTableName();
            this.attributeValues = context.getAttributeValues();
            this.modeledClass = context.getModeledClass();
            this.developerContext = context.getDeveloperContext();
            this.hashKeyName = context.getHashKeyName();
            this.rangeKeyName = context.getRangeKeyName();
            this.materialDescription = context.getMaterialDescription();
        }

        public EncryptionContext build() {
            return new EncryptionContext(this);
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withAttributeValues(Map<String, AttributeValue> attributeValues) {
            this.attributeValues = Collections.unmodifiableMap(new HashMap<String, AttributeValue>(attributeValues));
            return this;
        }

        public Builder withModeledClass(Class<?> modeledClass) {
            this.modeledClass = modeledClass;
            return this;
        }

        public Builder withDeveloperContext(Object developerContext) {
            this.developerContext = developerContext;
            return this;
        }

        public Builder withHashKeyName(String hashKeyName) {
            this.hashKeyName = hashKeyName;
            return this;
        }

        public Builder withRangeKeyName(String rangeKeyName) {
            this.rangeKeyName = rangeKeyName;
            return this;
        }

        public Builder withMaterialDescription(Map<String, String> materialDescription) {
            this.materialDescription = Collections.unmodifiableMap(new HashMap<String, String>(materialDescription));
            return this;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Map<String, AttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        public Class<?> getModeledClass() {
            return this.modeledClass;
        }

        public Object getDeveloperContext() {
            return this.developerContext;
        }

        public String getHashKeyName() {
            return this.hashKeyName;
        }

        public String getRangeKeyName() {
            return this.rangeKeyName;
        }

        public Map<String, String> getMaterialDescription() {
            return this.materialDescription;
        }
    }
}

