/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.utils;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import java.util.Map;
import java.util.function.UnaryOperator;

public class EncryptionContextOperators {
    private EncryptionContextOperators() {
    }

    public static UnaryOperator<EncryptionContext> overrideEncryptionContextTableName(String originalTableName, String newTableName) {
        return encryptionContext -> {
            if (encryptionContext == null || encryptionContext.getTableName() == null || originalTableName == null || newTableName == null) {
                return encryptionContext;
            }
            if (originalTableName.equals(encryptionContext.getTableName())) {
                return new EncryptionContext.Builder((EncryptionContext)encryptionContext).withTableName(newTableName).build();
            }
            return encryptionContext;
        };
    }

    public static UnaryOperator<EncryptionContext> overrideEncryptionContextTableNameUsingMap(Map<String, String> tableNameOverrideMap) {
        return encryptionContext -> {
            if (tableNameOverrideMap == null || encryptionContext == null || encryptionContext.getTableName() == null) {
                return encryptionContext;
            }
            String newTableName = (String)tableNameOverrideMap.get(encryptionContext.getTableName());
            if (newTableName != null) {
                return new EncryptionContext.Builder((EncryptionContext)encryptionContext).withTableName(newTableName).build();
            }
            return encryptionContext;
        };
    }
}

