/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public abstract class AbstractRawMaterials
implements DecryptionMaterials,
EncryptionMaterials {
    private Map<String, String> description;
    private final Key signingKey;
    private final Key verificationKey;

    protected AbstractRawMaterials(KeyPair signingPair) {
        this(signingPair, (Map<String, String>)Collections.EMPTY_MAP);
    }

    protected AbstractRawMaterials(KeyPair signingPair, Map<String, String> description) {
        this.signingKey = signingPair.getPrivate();
        this.verificationKey = signingPair.getPublic();
        this.setMaterialDescription(description);
    }

    protected AbstractRawMaterials(SecretKey macKey) {
        this(macKey, (Map<String, String>)Collections.EMPTY_MAP);
    }

    protected AbstractRawMaterials(SecretKey macKey, Map<String, String> description) {
        this.signingKey = macKey;
        this.verificationKey = macKey;
        this.description = Collections.unmodifiableMap(new HashMap<String, String>(description));
    }

    @Override
    public Map<String, String> getMaterialDescription() {
        return new HashMap<String, String>(this.description);
    }

    public void setMaterialDescription(Map<String, String> description) {
        this.description = Collections.unmodifiableMap(new HashMap<String, String>(description));
    }

    @Override
    public Key getSigningKey() {
        return this.signingKey;
    }

    @Override
    public Key getVerificationKey() {
        return this.verificationKey;
    }
}

