/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store.ProviderStore;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.LRUCache;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

@Deprecated
public class MostRecentProvider
implements EncryptionMaterialsProvider {
    private static final long MILLI_TO_NANO = 1000000L;
    private static final long TTL_GRACE_IN_NANO = 500000000L;
    private final ProviderStore keystore;
    protected final String defaultMaterialName;
    private final long ttlInNanos;
    private final LRUCache<EncryptionMaterialsProvider> cache;
    private final LRUCache<LockedState> currentVersions;

    public MostRecentProvider(ProviderStore keystore, String materialName, long ttlInMillis) {
        this.keystore = Utils.checkNotNull(keystore, "keystore must not be null");
        this.defaultMaterialName = materialName;
        this.ttlInNanos = ttlInMillis * 1000000L;
        this.cache = new LRUCache(1000);
        this.currentVersions = new LRUCache(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        String materialName = this.getMaterialName(context);
        LockedState ls = this.getCurrentVersion(materialName);
        State s = ls.getState();
        if (s.provider != null && System.nanoTime() - s.lastUpdated <= this.ttlInNanos) {
            return s.provider.getEncryptionMaterials(context);
        }
        if (s.provider == null || System.nanoTime() - s.lastUpdated > this.ttlInNanos + 500000000L) {
            ls.lock();
        } else if (!ls.tryLock()) {
            return s.provider.getEncryptionMaterials(context);
        }
        try {
            EncryptionMaterialsProvider currentProvider;
            long currentVersion;
            long newVersion = this.keystore.getMaxVersion(materialName);
            if (newVersion < 0L) {
                currentVersion = 0L;
                currentProvider = this.keystore.getOrCreate(materialName, currentVersion);
                this.cache.add(MostRecentProvider.buildCacheKey(materialName, currentVersion), currentProvider);
            } else if (newVersion != s.currentVersion) {
                currentVersion = newVersion;
                currentProvider = this.keystore.getProvider(materialName, currentVersion);
                this.cache.add(MostRecentProvider.buildCacheKey(materialName, currentVersion), currentProvider);
            } else {
                currentVersion = newVersion;
                currentProvider = s.provider;
            }
            ls.update(currentProvider, currentVersion);
            EncryptionMaterials encryptionMaterials = ls.getState().provider.getEncryptionMaterials(context);
            return encryptionMaterials;
        }
        finally {
            ls.unlock();
        }
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        long version;
        String materialName = this.getMaterialName(context);
        EncryptionMaterialsProvider provider = this.cache.get(MostRecentProvider.buildCacheKey(materialName, version = this.keystore.getVersionFromMaterialDescription(context.getMaterialDescription())));
        if (provider == null) {
            provider = this.keystore.getProvider(materialName, version);
            this.cache.add(MostRecentProvider.buildCacheKey(materialName, version), provider);
        }
        return provider.getDecryptionMaterials(context);
    }

    @Override
    public void refresh() {
        this.currentVersions.clear();
        this.cache.clear();
    }

    public String getMaterialName() {
        return this.defaultMaterialName;
    }

    public long getTtlInMills() {
        return this.ttlInNanos / 1000000L;
    }

    public long getCurrentVersion() {
        return this.getCurrentVersion((String)this.getMaterialName()).getState().currentVersion;
    }

    public long getLastUpdated() {
        return this.getCurrentVersion((String)this.getMaterialName()).getState().lastUpdated / 1000000L;
    }

    protected String getMaterialName(EncryptionContext context) {
        return this.defaultMaterialName;
    }

    private LockedState getCurrentVersion(String materialName) {
        LockedState result = this.currentVersions.get(materialName);
        if (result == null) {
            this.currentVersions.add(materialName, new LockedState());
            return this.currentVersions.get(materialName);
        }
        return result;
    }

    private static String buildCacheKey(String materialName, long version) {
        StringBuilder result = new StringBuilder(materialName);
        result.append('#');
        result.append(version);
        return result.toString();
    }

    private static class State {
        public final EncryptionMaterialsProvider provider;
        public final long currentVersion;
        public final long lastUpdated;

        public State() {
            this(null, -1L);
        }

        public State(EncryptionMaterialsProvider provider, long currentVersion) {
            this.provider = provider;
            this.currentVersion = currentVersion;
            this.lastUpdated = currentVersion == -1L ? 0L : System.nanoTime();
        }
    }

    private static class LockedState {
        private final ReentrantLock lock = new ReentrantLock(true);
        private volatile AtomicReference<State> state = new AtomicReference<State>(new State());

        private LockedState() {
        }

        public State getState() {
            return this.state.get();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public void lock() {
            this.lock.lock();
        }

        public void update(EncryptionMaterialsProvider provider, long currentVersion) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Lock not held by current thread");
            }
            this.state.set(new State(provider, currentVersion));
        }
    }
}

