/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.CreateProjectResult;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.UpdateProjectResult;
import java.util.ArrayList;

public class ProjectFactory {
    private AWSCodeBuildClient cbClient;

    public ProjectFactory(AWSCodeBuildClient cbClient) {
        this.cbClient = cbClient;
    }

    public String createProject(String projectName, String description, ProjectSource source, ProjectArtifacts artifacts, ProjectEnvironment environment, String serviceIAMRole, String timeout, String encryptionKey) throws Exception {
        ArrayList projects = new ArrayList();
        String nextToken = null;
        do {
            ListProjectsRequest lpRequest = new ListProjectsRequest().withNextToken(nextToken);
            ListProjectsResult lpResult = this.cbClient.listProjects(lpRequest);
            nextToken = lpResult.getNextToken();
            projects.addAll(lpResult.getProjects());
        } while (nextToken != null);
        if (projects.contains(projectName)) {
            UpdateProjectResult upResult = this.cbClient.updateProject(new UpdateProjectRequest().withName(projectName).withDescription(description).withSource(source).withArtifacts(artifacts).withEnvironment(environment).withServiceRole(serviceIAMRole).withTimeoutInMinutes(Validation.parseInt(timeout)).withEncryptionKey(encryptionKey));
            return upResult.getProject().getName();
        }
        CreateProjectResult cpResult = this.cbClient.createProject(new CreateProjectRequest().withName(projectName).withDescription(description).withSource(source).withArtifacts(artifacts).withEnvironment(environment).withServiceRole(serviceIAMRole).withTimeoutInMinutes(Validation.parseInt(timeout)).withEncryptionKey(encryptionKey));
        return cpResult.getProject().getName();
    }
}

