/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.LogsLocation;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.services.logs.model.GetLogEventsResult;
import com.amazonaws.services.logs.model.OutputLogEvent;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloudWatchMonitor {
    private AWSLogsClient logsClient;
    private LogsLocation logsLocation;
    private List<String> latestLogs;
    private Long lastPollTime;
    private static final int htmlMaxLineLength = 197;
    public static final String noLogsMessage = "No CloudWatch logs found for this build.";
    public static final String failedConfigurationLogsMessage = "CloudWatch configuration for this build is incorrect.";

    public CloudWatchMonitor(AWSLogsClient client) {
        this.logsClient = client;
        if (!Validation.checkCloudWatchMonitorConfig(this.logsClient)) {
            this.latestLogs = Arrays.asList(failedConfigurationLogsMessage);
            return;
        }
        this.lastPollTime = 0L;
    }

    public void pollForLogs(TaskListener listener) {
        if (this.logsLocation != null) {
            this.latestLogs = new ArrayList<String>();
            GetLogEventsRequest logRequest = new GetLogEventsRequest().withStartTime(this.lastPollTime).withStartFromHead(Boolean.valueOf(true)).withLogGroupName(this.logsLocation.getGroupName()).withLogStreamName(this.logsLocation.getStreamName());
            try {
                GetLogEventsResult logsResult = this.logsClient.getLogEvents(logRequest);
                this.getAndFormatLogs(logsResult.getEvents(), listener);
            }
            catch (Exception e) {
                this.latestLogs = Arrays.asList(e.getMessage());
                return;
            }
        } else {
            this.latestLogs = Arrays.asList(noLogsMessage);
            return;
        }
    }

    private void getAndFormatLogs(List<OutputLogEvent> logs, TaskListener listener) {
        if (logs.size() != 0) {
            for (int i = 0; i < logs.size(); ++i) {
                String entry = logs.get(i).getMessage();
                if (entry.startsWith("[Container]")) {
                    entry = entry.substring(entry.indexOf("]") + 2);
                }
                if (entry.length() > 197) {
                    entry = Utils.formatStringWithEllipsis(entry, 197);
                }
                LoggingHelper.log(listener, entry.replace("\n", ""));
                this.latestLogs.add(entry);
            }
            this.lastPollTime = logs.get(logs.size() - 1).getTimestamp() + 1L;
        }
    }

    public void setLogsClient(AWSLogsClient logsClient) {
        this.logsClient = logsClient;
    }

    public void setLogsLocation(LogsLocation logsLocation) {
        this.logsLocation = logsLocation;
    }

    public LogsLocation getLogsLocation() {
        return this.logsLocation;
    }

    public List<String> getLatestLogs() {
        return this.latestLogs;
    }

    public Long getLastPollTime() {
        return this.lastPollTime;
    }
}

