/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.ObjectRestoreHeaderHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractS3ResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private static final Log log = LogFactory.getLog(S3MetadataResponseHandler.class);
    private static final Set<String> IGNORED_HEADERS = new HashSet<String>();

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected AmazonWebServiceResponse<T> parseResponseMetadata(HttpResponse response) {
        AmazonWebServiceResponse awsResponse = new AmazonWebServiceResponse();
        String awsRequestId = (String)response.getHeaders().get("x-amz-request-id");
        String hostId = (String)response.getHeaders().get("x-amz-id-2");
        String cloudFrontId = (String)response.getHeaders().get("X-Amz-Cf-Id");
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("AWS_REQUEST_ID", awsRequestId);
        metadataMap.put("HOST_ID", hostId);
        metadataMap.put("CLOUD_FRONT_ID", cloudFrontId);
        awsResponse.setResponseMetadata((ResponseMetadata)new S3ResponseMetadata(metadataMap));
        return awsResponse;
    }

    protected void populateObjectMetadata(HttpResponse response, ObjectMetadata metadata) {
        for (Map.Entry header : response.getHeaders().entrySet()) {
            String key = (String)header.getKey();
            if (key.startsWith("x-amz-meta-")) {
                key = key.substring("x-amz-meta-".length());
                metadata.addUserMetadata(key, (String)header.getValue());
                continue;
            }
            if (IGNORED_HEADERS.contains(key)) {
                log.debug((Object)String.format("%s is ignored.", key));
                continue;
            }
            if (key.equalsIgnoreCase("Last-Modified")) {
                try {
                    metadata.setHeader(key, ServiceUtils.parseRfc822Date((String)header.getValue()));
                }
                catch (Exception pe) {
                    log.warn((Object)("Unable to parse last modified date: " + (String)header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("Content-Length")) {
                try {
                    metadata.setHeader(key, Long.parseLong((String)header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Unable to parse content length: " + (String)header.getValue()), (Throwable)nfe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("ETag")) {
                metadata.setHeader(key, ServiceUtils.removeQuotes((String)header.getValue()));
                continue;
            }
            if (key.equalsIgnoreCase("Expires")) {
                try {
                    metadata.setHttpExpiresDate(DateUtils.parseRFC822Date((String)((String)header.getValue())));
                }
                catch (Exception pe) {
                    log.warn((Object)("Unable to parse http expiration date: " + (String)header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-request-charged")) {
                new S3RequesterChargedHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-mp-parts-count")) {
                try {
                    metadata.setHeader(key, Integer.parseInt((String)header.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new AmazonClientException("Unable to parse part count. Header x-amz-mp-parts-count has corrupted data" + nfe.getMessage(), (Throwable)nfe);
                }
            }
            metadata.setHeader(key, header.getValue());
        }
    }

    static {
        IGNORED_HEADERS.add("Date");
        IGNORED_HEADERS.add("Server");
        IGNORED_HEADERS.add("x-amz-request-id");
        IGNORED_HEADERS.add("x-amz-id-2");
        IGNORED_HEADERS.add("X-Amz-Cf-Id");
        IGNORED_HEADERS.add("Connection");
    }
}

