/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressReportingInputStream;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.internal.CompleteMultipartUploadRetryCondition;
import com.amazonaws.services.s3.internal.DeleteObjectTaggingHeaderHandler;
import com.amazonaws.services.s3.internal.DeleteObjectsResponse;
import com.amazonaws.services.s3.internal.GetObjectTaggingResponseHeaderHandler;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.ResponseHeaderHandlerChain;
import com.amazonaws.services.s3.internal.S3ErrorResponseHandler;
import com.amazonaws.services.s3.internal.S3ExecutionContext;
import com.amazonaws.services.s3.internal.S3HttpUtils;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3ObjectResponseHandler;
import com.amazonaws.services.s3.internal.S3QueryStringSigner;
import com.amazonaws.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.amazonaws.services.s3.internal.S3Signer;
import com.amazonaws.services.s3.internal.S3StringResponseHandler;
import com.amazonaws.services.s3.internal.S3VersionHeaderHandler;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.services.s3.internal.ServerSideEncryptionHeaderHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.SetObjectTaggingResponseHeaderHandler;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GenericBucketRequest;
import com.amazonaws.services.s3.model.GetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAclRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectAclRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.GetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.GetS3AccountOwnerRequest;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiFactorAuthentication;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.RequestPaymentConfiguration;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.S3AccelerateUnsupported;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAclRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectAclRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingResult;
import com.amazonaws.services.s3.model.SetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import com.amazonaws.services.s3.model.transform.AclXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketNotificationConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.HeadBucketResultHandler;
import com.amazonaws.services.s3.model.transform.MultiObjectDeleteXmlFactory;
import com.amazonaws.services.s3.model.transform.ObjectTaggingXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestPaymentConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestXmlFactory;
import com.amazonaws.services.s3.model.transform.Unmarshallers;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import com.amazonaws.services.s3.util.Mimetypes;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.RuntimeHttpUtils;
import com.amazonaws.util.ServiceClientHolderInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class AmazonS3Client
extends AmazonWebServiceClient
implements AmazonS3 {
    public static final String S3_SERVICE_NAME = "s3";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private final S3ErrorResponseHandler errorResponseHandler = new S3ErrorResponseHandler();
    private final S3XmlResponseHandler<Void> voidResponseHandler = new S3XmlResponseHandler(null);
    private static final BucketConfigurationXmlFactory bucketConfigurationXmlFactory;
    private static final RequestPaymentConfigurationXmlFactory requestPaymentConfigurationXmlFactory;
    protected S3ClientOptions clientOptions = new S3ClientOptions();
    private final AWSCredentialsProvider awsCredentialsProvider;
    volatile String clientRegion;
    private int notificationThreshold = 1024;
    private static final int BUCKET_REGION_CACHE_SIZE = 300;
    private static final Map<String, String> bucketRegionCache;
    private final CompleteMultipartUploadRetryCondition completeMultipartUploadRetryCondition = new CompleteMultipartUploadRetryCondition();

    static Map<String, String> getBucketRegionCache() {
        return bucketRegionCache;
    }

    @Deprecated
    public AmazonS3Client() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(awsCredentials), clientConfiguration);
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = credentialsProvider;
        this.init();
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        super(clientConfiguration, httpClient);
        this.awsCredentialsProvider = credentialsProvider;
        this.init();
    }

    @Deprecated
    public AmazonS3Client(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonS3Client(AWSCredentials awsCredentials, com.amazonaws.regions.Region region) {
        this(awsCredentials, region, new ClientConfiguration());
    }

    public AmazonS3Client(AWSCredentials awsCredentials, com.amazonaws.regions.Region region, ClientConfiguration clientConfiguration) {
        this(awsCredentials, region, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    public AmazonS3Client(AWSCredentials awsCredentials, com.amazonaws.regions.Region region, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(awsCredentials), region, clientConfiguration, httpClient);
    }

    public AmazonS3Client(AWSCredentialsProvider awsCredentialsProvider, com.amazonaws.regions.Region region) {
        this(awsCredentialsProvider, region, new ClientConfiguration());
    }

    public AmazonS3Client(AWSCredentialsProvider awsCredentialsProvider, com.amazonaws.regions.Region region, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, region, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    public AmazonS3Client(AWSCredentialsProvider awsCredentialsProvider, com.amazonaws.regions.Region region, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        super(clientConfiguration, httpClient);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init(region, clientConfiguration);
    }

    public AmazonS3Client(ClientConfiguration clientConfiguration, com.amazonaws.regions.Region region) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), region, clientConfiguration);
    }

    @Deprecated
    private void init() {
        this.setEndpoint("s3.amazonaws.com");
        this.endpointPrefix = S3_SERVICE_NAME;
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3/request.handler2s"));
    }

    private void init(com.amazonaws.regions.Region region, ClientConfiguration clientConfiguration) {
        if (this.awsCredentialsProvider == null) {
            throw new IllegalArgumentException("Credentials cannot be null. Credentials is required to sign the request");
        }
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null. Region is required to sign the request");
        }
        this.clientConfiguration = clientConfiguration;
        this.endpointPrefix = S3_SERVICE_NAME;
        this.setEndpoint("s3.amazonaws.com");
        this.setRegion(region);
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3/request.handler2s"));
        log.debug((Object)("initialized with endpoint = " + this.endpoint));
    }

    public void setNotificationThreshold(int threshold) {
        this.notificationThreshold = threshold;
    }

    @Override
    public void setEndpoint(String endpoint) {
        if (endpoint.endsWith("s3-accelerate.amazonaws.com")) {
            throw new IllegalStateException("To enable accelerate mode, please use AmazonS3Client.setS3ClientOptions(S3ClientOptions.builder().setAccelerateModeEnabled(true).build());");
        }
        super.setEndpoint(endpoint);
        if (!endpoint.endsWith("s3.amazonaws.com")) {
            this.clientRegion = AwsHostNameUtils.parseRegionName((String)this.endpoint.getHost(), (String)S3_SERVICE_NAME);
        }
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        super.setRegion(region);
        this.clientRegion = region.getName();
    }

    @Override
    public void setS3ClientOptions(S3ClientOptions clientOptions) {
        this.clientOptions = new S3ClientOptions(clientOptions);
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws AmazonClientException, AmazonServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(previousVersionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)listNextBatchOfVersionsRequest, (String)"The request object parameter must be specified when listing the next batch of versions in a bucket");
        VersionListing previousVersionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!previousVersionListing.isTruncated()) {
            VersionListing emptyListing = new VersionListing();
            emptyListing.setBucketName(previousVersionListing.getBucketName());
            emptyListing.setDelimiter(previousVersionListing.getDelimiter());
            emptyListing.setKeyMarker(previousVersionListing.getNextKeyMarker());
            emptyListing.setVersionIdMarker(previousVersionListing.getNextVersionIdMarker());
            emptyListing.setMaxKeys(previousVersionListing.getMaxKeys());
            emptyListing.setPrefix(previousVersionListing.getPrefix());
            emptyListing.setEncodingType(previousVersionListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxKeys) throws AmazonClientException, AmazonServiceException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxKeys);
        return this.listVersions(request);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)listVersionsRequest.getBucketName(), (String)"The bucket name parameter must be specified when listing versions in a bucket");
        boolean shouldSDKDecodeResponse = "url".equals(listVersionsRequest.getEncodingType());
        Request<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listVersionsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listVersionsRequest.getDelimiter());
        AmazonS3Client.addParameterIfNotNull(request, "key-marker", listVersionsRequest.getKeyMarker());
        AmazonS3Client.addParameterIfNotNull(request, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        AmazonS3Client.addParameterIfNotNull(request, "encoding-type", listVersionsRequest.getEncodingType());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(shouldSDKDecodeResponse), listVersionsRequest.getBucketName(), null);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)listObjectsRequest.getBucketName(), (String)"The bucket name parameter must be specified when listing objects in a bucket");
        boolean shouldSDKDecodeResponse = "url".equals(listObjectsRequest.getEncodingType());
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsRequest.getDelimiter());
        AmazonS3Client.addParameterIfNotNull(request, "marker", listObjectsRequest.getMarker());
        AmazonS3Client.addParameterIfNotNull(request, "encoding-type", listObjectsRequest.getEncodingType());
        AmazonS3Client.populateRequesterPaysHeader(request, listObjectsRequest.isRequesterPays());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(shouldSDKDecodeResponse), listObjectsRequest.getBucketName(), null);
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(bucketName));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)listObjectsV2Request.getBucketName(), (String)"The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsV2Request> request = this.createRequest(listObjectsV2Request.getBucketName(), null, listObjectsV2Request, HttpMethodName.GET);
        request.addParameter("list-type", "2");
        AmazonS3Client.addParameterIfNotNull(request, "start-after", listObjectsV2Request.getStartAfter());
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listObjectsV2Request.getContinuationToken());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsV2Request.getDelimiter());
        AmazonS3Client.addParameterIfNotNull(request, "max-keys", listObjectsV2Request.getMaxKeys());
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsV2Request.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "encoding-type", listObjectsV2Request.getEncodingType());
        request.addParameter("fetch-owner", Boolean.toString(listObjectsV2Request.isFetchOwner()));
        AmazonS3Client.populateRequesterPaysHeader(request, listObjectsV2Request.isRequesterPays());
        boolean shouldSDKDecodeResponse = "url".equals(listObjectsV2Request.getEncodingType());
        return this.invoke(request, new Unmarshallers.ListObjectsV2Unmarshaller(shouldSDKDecodeResponse), listObjectsV2Request.getBucketName(), null);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)previousObjectListing, (String)"The previous object listing parameter must be specified when listing the next batch of objects in a bucket");
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(previousObjectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws AmazonClientException, AmazonServiceException {
        ObjectListing previousObjectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setEncodingType(previousObjectListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public Owner getS3AccountOwner() throws AmazonClientException, AmazonServiceException {
        return this.getS3AccountOwner(new GetS3AccountOwnerRequest());
    }

    @Override
    public Owner getS3AccountOwner(GetS3AccountOwnerRequest getS3AccountOwnerRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getS3AccountOwnerRequest, (String)"The request object parameter getS3AccountOwnerRequest must be specified.");
        Request<ListBucketsRequest> request = this.createRequest(null, null, new ListBucketsRequest(), HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsOwnerUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws AmazonClientException, AmazonServiceException {
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws AmazonClientException, AmazonServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getBucketLocationRequest, (String)"The request parameter must be specified when requesting a bucket's location");
        String bucketName = getBucketLocationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting a bucket's location");
        Request<GetBucketLocationRequest> request = this.createRequest(bucketName, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller(), bucketName, null);
    }

    @Override
    public String getBucketLocation(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    @Override
    public Bucket createBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(String bucketName, Region region) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    public Bucket createBucket(String bucketName, String region) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)createBucketRequest, (String)"The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        String region = createBucketRequest.getRegion();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when creating a bucket");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        BucketNameUtils.validateBucketName(bucketName);
        Request<CreateBucketRequest> request = this.createRequest(bucketName, null, createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", createBucketRequest.getCannedAcl().toString());
        }
        if (!this.endpoint.getHost().equals("s3.amazonaws.com") && (region == null || region.isEmpty())) {
            try {
                region = RegionUtils.getRegionByEndpoint((String)this.endpoint.getHost()).getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (region != null && !StringUtils.upperCase((String)region).equals(Region.US_Standard.toString())) {
            XmlWriter xml = new XmlWriter();
            xml.start("CreateBucketConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            xml.start("LocationConstraint").value(region).end();
            xml.end();
            byte[] bytes = xml.getBytes();
            request.addHeader("Content-Length", String.valueOf(bytes.length));
            request.setContent((InputStream)new ByteArrayInputStream(bytes));
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        return new Bucket(bucketName);
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key));
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key, versionId));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getObjectAclRequest, (String)"The request parameter must be specified when requesting an object's ACL");
        ValidationUtils.assertParameterNotNull((Object)getObjectAclRequest.getBucketName(), (String)"The bucket name parameter must be specified when requesting an object's ACL");
        ValidationUtils.assertParameterNotNull((Object)getObjectAclRequest.getKey(), (String)"The key parameter must be specified when requesting an object's ACL");
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest.isRequesterPays(), getObjectAclRequest);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, versionId, acl));
    }

    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(bucketName, key, versionId, acl).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, versionId, acl));
    }

    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl, RequestMetricCollector requestMetricCollector) {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(bucketName, key, versionId, acl).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)setObjectAclRequest, (String)"The request must not be null.");
        ValidationUtils.assertParameterNotNull((Object)setObjectAclRequest.getBucketName(), (String)"The bucket name parameter must be specified when setting an object's ACL");
        ValidationUtils.assertParameterNotNull((Object)setObjectAclRequest.getKey(), (String)"The key parameter must be specified when setting an object's ACL");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, false, null);
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = getBucketAclRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, false, getBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(bucketName, acl, null);
    }

    public void setBucketAcl(String bucketName, AccessControlList acl, RequestMetricCollector requestMetricCollector) {
        this.setBucketAcl0(bucketName, acl, requestMetricCollector);
    }

    private void setBucketAcl0(String bucketName, AccessControlList acl, RequestMetricCollector requestMetricCollector) {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting a bucket's ACL");
        ValidationUtils.assertParameterNotNull((Object)acl, (String)"The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(bucketName, null, null, acl, false, new GenericBucketRequest(bucketName).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = setBucketAclRequest.getBucketName();
        AccessControlList acl = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAcl = setBucketAclRequest.getCannedAcl();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting a bucket's ACL");
        if (acl != null) {
            this.setAcl(bucketName, null, null, acl, false, (AmazonWebServiceRequest)setBucketAclRequest);
        } else if (cannedAcl != null) {
            this.setAcl(bucketName, null, null, cannedAcl, false, (AmazonWebServiceRequest)setBucketAclRequest);
        } else {
            ValidationUtils.assertParameterNotNull(null, (String)"The ACL parameter must be specified when setting a bucket's ACL");
        }
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(bucketName, acl, null);
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(bucketName, acl, requestMetricCollector);
    }

    private void setBucketAcl0(String bucketName, CannedAccessControlList acl, RequestMetricCollector col) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting a bucket's ACL");
        ValidationUtils.assertParameterNotNull((Object)((Object)acl), (String)"The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(bucketName, null, null, acl, false, new GenericBucketRequest(bucketName).withRequestMetricCollector(col));
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getObjectMetadataRequest, (String)"The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        String versionId = getObjectMetadataRequest.getVersionId();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting an object's metadata");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectMetadataRequest.isRequesterPays());
        this.addPartNumberIfNotNull(request, getObjectMetadataRequest.getPartNumber());
        AmazonS3Client.populateSSE_C(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
    }

    @Override
    public S3Object getObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws AmazonClientException, AmazonServiceException {
        try {
            this.headBucket(new HeadBucketRequest(bucketName));
            return true;
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 301 || ase.getStatusCode() == 403) {
                return true;
            }
            if (ase.getStatusCode() == 404) {
                return false;
            }
            throw ase;
        }
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws AmazonServiceException, AmazonClientException {
        try {
            this.getObjectMetadata(bucketName, objectName);
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = headBucketRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucketName parameter must be specified.");
        Request<HeadBucketRequest> request = this.createRequest(bucketName, null, headBucketRequest, HttpMethodName.HEAD);
        return this.invoke(request, new HeadBucketResultHandler(), bucketName, null);
    }

    @Override
    public void changeObjectStorageClass(String bucketName, String key, StorageClass newStorageClass) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucketName parameter must be specified when changing an object's storage class");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when changing an object's storage class");
        ValidationUtils.assertParameterNotNull((Object)((Object)newStorageClass), (String)"The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withStorageClass(newStorageClass.toString()));
    }

    @Override
    public void setObjectRedirectLocation(String bucketName, String key, String newRedirectLocation) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucketName parameter must be specified when changing an object's storage class");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when changing an object's storage class");
        ValidationUtils.assertParameterNotNull((Object)newRedirectLocation, (String)"The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withRedirectLocation(newRedirectLocation));
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        long[] range;
        ValidationUtils.assertParameterNotNull((Object)getObjectRequest, (String)"The GetObjectRequest parameter must be specified when requesting an object");
        ValidationUtils.assertParameterNotNull((Object)getObjectRequest.getBucketName(), (String)"The bucket name parameter must be specified when requesting an object");
        ValidationUtils.assertParameterNotNull((Object)getObjectRequest.getKey(), (String)"The key parameter must be specified when requesting an object");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        if ((range = getObjectRequest.getRange()) != null) {
            String rangeHeader = "bytes=" + Long.toString(range[0]) + "-";
            if (range[1] >= 0L) {
                rangeHeader = rangeHeader + Long.toString(range[1]);
            }
            request.addHeader("Range", rangeHeader);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectRequest.isRequesterPays());
        AmazonS3Client.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        AmazonS3Client.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        AmazonS3Client.populateSSE_C(request, getObjectRequest.getSSECustomerKey());
        ProgressListener progressListener = getObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListener);
        try {
            S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            s3Object.setBucketName(getObjectRequest.getBucketName());
            s3Object.setKey(getObjectRequest.getKey());
            S3ObjectInputStream input = s3Object.getObjectContent();
            input = new ServiceClientHolderInputStream((InputStream)((Object)input), (AmazonWebServiceClient)this);
            if (progressListenerCallbackExecutor != null) {
                ProgressReportingInputStream progressReportingInputStream = new ProgressReportingInputStream((InputStream)((Object)input), progressListenerCallbackExecutor);
                progressReportingInputStream.setFireCompletedEvent(true);
                progressReportingInputStream.setNotificationThreshold(this.notificationThreshold);
                input = progressReportingInputStream;
                this.fireProgressEvent(progressListenerCallbackExecutor, 2);
            }
            input = new LengthCheckInputStream((InputStream)((Object)input), s3Object.getObjectMetadata().getContentLength(), true);
            s3Object.setObjectContent(new S3ObjectInputStream((InputStream)((Object)input)));
            return s3Object;
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412 || ase.getStatusCode() == 304) {
                this.fireProgressEvent(progressListenerCallbackExecutor, 16);
                return null;
            }
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ase;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File destinationFile) throws AmazonClientException, AmazonServiceException {
        S3Object s3Object;
        ValidationUtils.assertParameterNotNull((Object)destinationFile, (String)"The destination file parameter must be specified when downloading an object directly to a file");
        boolean mode = false;
        if (getObjectRequest.getRange() != null && getObjectRequest.getRange()[0] > 0L) {
            mode = true;
        }
        if ((s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(destinationFile, new ServiceUtils.RetryableS3DownloadTask(){

            @Override
            public S3Object getS3ObjectStream() {
                return AmazonS3Client.this.getObject(getObjectRequest);
            }

            @Override
            public boolean needIntegrityCheck() {
                return !ServiceUtils.skipMd5CheckPerRequest(getObjectRequest, AmazonS3Client.this.clientOptions);
            }
        }, mode)) == null) {
            return null;
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public void deleteBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketRequest, (String)"The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(bucketName, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        bucketRegionCache.remove(bucketName);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)putObjectRequest, (String)"The PutObjectRequest parameter must be specified when uploading an object");
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        Object input = putObjectRequest.getInputStream();
        ProgressListener progressListener = putObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListener);
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when uploading an object");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when uploading an object");
        boolean skipContentMd5Check = ServiceUtils.skipMd5CheckPerRequest(putObjectRequest, this.clientOptions);
        if (putObjectRequest.getFile() != null) {
            boolean calculateMD5;
            File file = putObjectRequest.getFile();
            metadata.setContentLength(file.length());
            boolean bl = calculateMD5 = metadata.getContentMD5() == null;
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            if (calculateMD5 && !skipContentMd5Check) {
                try {
                    String contentMd5_b64 = Md5Utils.md5AsBase64((File)file);
                    metadata.setContentMD5(contentMd5_b64);
                }
                catch (Exception e) {
                    throw new AmazonClientException("Unable to calculate MD5 hash: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                input = new RepeatableFileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new AmazonClientException("Unable to find file to upload", (Throwable)fnfe);
            }
        }
        Request<PutObjectRequest> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
        if (putObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, putObjectRequest.getAccessControlList());
        } else if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (putObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", putObjectRequest.getStorageClass());
        }
        if (putObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", putObjectRequest.getRedirectLocation());
            if (input == null) {
                this.setZeroContentLength(request);
                input = new ByteArrayInputStream(new byte[0]);
            }
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(putObjectRequest.getTagging()));
        AmazonS3Client.populateRequesterPaysHeader(request, putObjectRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, putObjectRequest.getSSECustomerKey());
        Long contentLength = (Long)metadata.getRawMetadataValue("Content-Length");
        if (contentLength == null) {
            if (!((InputStream)input).markSupported()) {
                log.warn((Object)"No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
                ByteArrayInputStream bais = this.toByteArray((InputStream)input);
                request.addHeader("Content-Length", String.valueOf(bais.available()));
                request.setStreaming(true);
                input = bais;
            } else {
                long len = this.calculateContentLength((InputStream)input);
                request.addHeader("Content-Length", String.valueOf(len));
            }
        } else {
            long expectedLength = contentLength;
            if (expectedLength >= 0L) {
                LengthCheckInputStream lcis = new LengthCheckInputStream((InputStream)input, expectedLength, false);
                input = lcis;
                request.addHeader("Content-Length", contentLength.toString());
            }
        }
        if (progressListenerCallbackExecutor != null) {
            input = new ProgressReportingInputStream((InputStream)input, progressListenerCallbackExecutor);
            ((ProgressReportingInputStream)input).setNotificationThreshold(this.notificationThreshold);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        AmazonS3Client.populateRequestMetadata(request, metadata);
        AmazonS3Client.populateSSE_KMS(request, putObjectRequest.getSSEAwsKeyManagementParams());
        request.setContent((InputStream)input);
        ObjectMetadata returnedMetadata = null;
        try {
            returnedMetadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
        }
        catch (AmazonClientException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw ace;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (AbortedException abortedException) {
            }
            catch (Exception e) {
                log.debug((Object)("Unable to cleanly close input stream: " + e.getMessage()), (Throwable)e);
            }
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 4);
        PutObjectResult result = new PutObjectResult();
        result.setVersionId(returnedMetadata.getVersionId());
        result.setSSEAlgorithm(returnedMetadata.getSSEAlgorithm());
        result.setSSECustomerAlgorithm(returnedMetadata.getSSECustomerAlgorithm());
        result.setSSECustomerKeyMd5(returnedMetadata.getSSECustomerKeyMd5());
        result.setExpirationTime(returnedMetadata.getExpirationTime());
        result.setExpirationTimeRuleId(returnedMetadata.getExpirationTimeRuleId());
        result.setETag(returnedMetadata.getETag());
        result.setMetadata(returnedMetadata);
        result.setRequesterCharged(returnedMetadata.isRequesterCharged());
        result.setContentMd5(returnedMetadata.getContentMD5());
        return result;
    }

    private long calculateContentLength(InputStream is) {
        long len = 0L;
        byte[] buf = new byte[8192];
        is.mark(-1);
        try {
            int read;
            while ((read = is.read(buf)) != -1) {
                len += (long)read;
            }
            is.reset();
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Could not calculate content length.", (Throwable)ioe);
        }
        return len;
    }

    private static void addAclHeaders(Request<? extends AmazonWebServiceRequest> request, AccessControlList acl) {
        Set<Grant> grants = acl.getGrants();
        HashMap grantsByPermission = new HashMap();
        for (Grant grant : grants) {
            if (!grantsByPermission.containsKey((Object)grant.getPermission())) {
                grantsByPermission.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)grantsByPermission.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!grantsByPermission.containsKey((Object)permission)) continue;
            Collection grantees = (Collection)grantsByPermission.get((Object)permission);
            boolean seenOne = false;
            StringBuilder granteeString = new StringBuilder();
            for (Grantee grantee : grantees) {
                if (!seenOne) {
                    seenOne = true;
                } else {
                    granteeString.append(", ");
                }
                granteeString.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), granteeString.toString());
        }
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws AmazonClientException, AmazonServiceException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)copyObjectRequest.getSourceBucketName(), (String)"The source bucket name must be specified when copying an object");
        ValidationUtils.assertParameterNotNull((Object)copyObjectRequest.getSourceKey(), (String)"The source object key must be specified when copying an object");
        ValidationUtils.assertParameterNotNull((Object)copyObjectRequest.getDestinationBucketName(), (String)"The destination bucket name must be specified when copying an object");
        ValidationUtils.assertParameterNotNull((Object)copyObjectRequest.getDestinationKey(), (String)"The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        AmazonS3Client.populateSSE_KMS(request, copyObjectRequest.getSSEAwsKeyManagementParams());
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3RequesterChargedHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler, destinationBucketName, destinationKey);
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412) {
                return null;
            }
            throw ase;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            String hostId = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception ase = new AmazonS3Exception(errorMessage);
            ase.setErrorCode(errorCode);
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(hostId);
            ase.setServiceName(request.getServiceName());
            ase.setStatusCode(200);
            throw ase;
        }
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag(copyObjectResultHandler.getETag());
        copyObjectResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyObjectResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyObjectResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyObjectResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyObjectResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        copyObjectResult.setExpirationTime(copyObjectResultHandler.getExpirationTime());
        copyObjectResult.setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        copyObjectResult.setRequesterCharged(copyObjectResultHandler.isRequesterCharged());
        return copyObjectResult;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getSourceBucketName(), (String)"The source bucket name must be specified when copying a part");
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getSourceKey(), (String)"The source object key must be specified when copying a part");
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getDestinationBucketName(), (String)"The destination bucket name must be specified when copying a part");
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getUploadId(), (String)"The upload id must be specified when copying a part");
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getDestinationKey(), (String)"The destination object key must be specified when copying a part");
        ValidationUtils.assertParameterNotNull((Object)copyPartRequest.getPartNumber(), (String)"The part number must be specified when copying a part");
        String destinationKey = copyPartRequest.getDestinationKey();
        String destinationBucketName = copyPartRequest.getDestinationBucketName();
        Request<CopyPartRequest> request = this.createRequest(destinationBucketName, destinationKey, copyPartRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyPartParameters(request, copyPartRequest);
        request.addParameter("uploadId", copyPartRequest.getUploadId());
        request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler, destinationBucketName, destinationKey);
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412) {
                return null;
            }
            throw ase;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            String hostId = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception ase = new AmazonS3Exception(errorMessage);
            ase.setErrorCode(errorCode);
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(hostId);
            ase.setServiceName(request.getServiceName());
            ase.setStatusCode(200);
            throw ase;
        }
        CopyPartResult copyPartResult = new CopyPartResult();
        copyPartResult.setETag(copyObjectResultHandler.getETag());
        copyPartResult.setPartNumber(copyPartRequest.getPartNumber());
        copyPartResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyPartResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyPartResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyPartResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyPartResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        return copyPartResult;
    }

    @Override
    public void deleteObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)deleteObjectRequest, (String)"The delete object request must be specified when deleting an object");
        ValidationUtils.assertParameterNotNull((Object)deleteObjectRequest.getBucketName(), (String)"The bucket name must be specified when deleting an object");
        ValidationUtils.assertParameterNotNull((Object)deleteObjectRequest.getKey(), (String)"The key must be specified when deleting an object");
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        Request<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        if (deleteObjectsRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteObjectsRequest.getMfa());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, deleteObjectsRequest.isRequesterPays());
        byte[] content = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        ResponseHeaderHandlerChain<DeleteObjectsResponse> responseHandler = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoke(request, responseHandler, deleteObjectsRequest.getBucketName(), null);
        if (!response.getErrors().isEmpty()) {
            Map<String, String> headers = responseHandler.getResponseHeaders();
            MultiObjectDeleteException ex = new MultiObjectDeleteException(response.getErrors(), response.getDeletedObjects());
            ex.setStatusCode(200);
            ex.setRequestId(headers.get("x-amz-request-id"));
            ex.setExtendedRequestId(headers.get("x-amz-id-2"));
            ex.setCloudFrontId(headers.get("X-Amz-Cf-Id"));
            throw ex;
        }
        DeleteObjectsResult result = new DeleteObjectsResult(response.getDeletedObjects(), response.isRequesterCharged());
        return result;
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)deleteVersionRequest, (String)"The delete version request object must be specified when deleting a version");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when deleting a version");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key must be specified when deleting a version");
        ValidationUtils.assertParameterNotNull((Object)versionId, (String)"The version ID must be specified when deleting a version");
        Request<DeleteVersionRequest> request = this.createRequest(bucketName, key, deleteVersionRequest, HttpMethodName.DELETE);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        if (deleteVersionRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteVersionRequest.getMfa());
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketVersioningConfigurationRequest), (String)"The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String bucketName = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration versioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting versioning configuration");
        ValidationUtils.assertParameterNotNull((Object)versioningConfiguration, (String)"The bucket versioning parameter must be specified when setting versioning configuration");
        if (versioningConfiguration.isMfaDeleteEnabled() != null) {
            ValidationUtils.assertParameterNotNull((Object)setBucketVersioningConfigurationRequest.getMfa(), (String)"The MFA parameter must be specified when changing MFA Delete status in the versioning configuration");
        }
        Request<SetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        if (versioningConfiguration.isMfaDeleteEnabled() != null && setBucketVersioningConfigurationRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, setBucketVersioningConfigurationRequest.getMfa());
        }
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(versioningConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getBucketVersioningConfigurationRequest, (String)"The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String bucketName = getBucketVersioningConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when querying versioning configuration");
        Request<GetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = getBucketWebsiteConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting a bucket's website configuration");
        Request<GetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(request, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 404) {
                return null;
            }
            throw ase;
        }
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)getBucketLifecycleConfigurationRequest, (String)"The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String bucketName = getBucketLifecycleConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        Request<GetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketLifecycleConfigurationRequest), (String)"The set bucket lifecycle configuration request object must be specified.");
        String bucketName = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        ValidationUtils.assertParameterNotNull((Object)bucketLifecycleConfiguration, (String)"The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        Request<SetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketLifecycleConfigurationRequest, (String)"The delete bucket lifecycle configuration request object must be specified.");
        String bucketName = deleteBucketLifecycleConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        Request<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)getBucketCrossOriginConfigurationRequest, (String)"The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String bucketName = getBucketCrossOriginConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when retrieving the bucket cross origin configuration.");
        Request<GetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        request.addParameter("cors", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(bucketName, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketCrossOriginConfigurationRequest), (String)"The set bucket cross origin configuration request object must be specified.");
        String bucketName = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting bucket cross origin configuration.");
        ValidationUtils.assertParameterNotNull((Object)bucketCrossOriginConfiguration, (String)"The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        Request<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("cors", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String bucketName) {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketCrossOriginConfigurationRequest, (String)"The delete bucket cross origin configuration request object must be specified.");
        String bucketName = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        Request<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("cors", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String bucketName) {
        return this.getBucketTaggingConfiguration(new GetBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)getBucketTaggingConfigurationRequest, (String)"The request object parameter getBucketTaggingConfigurationRequest must be specifed.");
        String bucketName = getBucketTaggingConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when retrieving the bucket tagging configuration.");
        Request<GetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, getBucketTaggingConfigurationRequest, HttpMethodName.GET);
        request.addParameter("tagging", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketTaggingConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String bucketName, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(bucketName, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketTaggingConfigurationRequest), (String)"The set bucket tagging configuration request object must be specified.");
        String bucketName = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting bucket tagging configuration.");
        ValidationUtils.assertParameterNotNull((Object)bucketTaggingConfiguration, (String)"The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        Request<SetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String bucketName) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketTaggingConfigurationRequest, (String)"The delete bucket tagging configuration request object must be specified.");
        String bucketName = deleteBucketTaggingConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting bucket tagging configuration.");
        Request<DeleteBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) throws AmazonClientException, AmazonServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration configuration = setBucketWebsiteConfigurationRequest.getConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting a bucket's website configuration");
        ValidationUtils.assertParameterNotNull((Object)configuration, (String)"The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (configuration.getRedirectAllRequestsTo() == null) {
            ValidationUtils.assertParameterNotNull((Object)configuration.getIndexDocumentSuffix(), (String)"The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        Request<SetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(configuration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = deleteBucketWebsiteConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting a bucket's website configuration");
        Request<DeleteBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void setBucketNotificationConfiguration(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws AmazonClientException, AmazonServiceException {
        this.setBucketNotificationConfiguration(new SetBucketNotificationConfigurationRequest(bucketName, bucketNotificationConfiguration));
    }

    @Override
    public void setBucketNotificationConfiguration(SetBucketNotificationConfigurationRequest setBucketNotificationConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketNotificationConfigurationRequest), (String)"The set bucket notification configuration request object must be specified.");
        String bucketName = setBucketNotificationConfigurationRequest.getBucketName();
        BucketNotificationConfiguration bucketNotificationConfiguration = setBucketNotificationConfigurationRequest.getNotificationConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting bucket notification configuration.");
        ValidationUtils.assertParameterNotNull((Object)bucketNotificationConfiguration, (String)"The notification configuration parameter must be specified when setting bucket notification configuration.");
        Request<SetBucketNotificationConfigurationRequest> request = this.createRequest(bucketName, null, setBucketNotificationConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("notification", null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketNotificationConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when querying notification configuration");
        return this.getBucketNotificationConfiguration(new GetBucketNotificationConfigurationRequest(bucketName));
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = getBucketNotificationConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket request must specify a bucket name when querying notification configuration");
        Request<GetBucketNotificationConfigurationRequest> request = this.createRequest(bucketName, null, getBucketNotificationConfigurationRequest, HttpMethodName.GET);
        request.addParameter("notification", null);
        return this.invoke(request, BucketNotificationConfigurationStaxUnmarshaller.getInstance(), bucketName, null);
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when requesting a bucket's logging status");
        return this.getBucketLoggingConfiguration(new GetBucketLoggingConfigurationRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(GetBucketLoggingConfigurationRequest getBucketLoggingConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getBucketLoggingConfigurationRequest, (String)"The bucket logging configuration");
        String bucketName = getBucketLoggingConfigurationRequest.getBucketName();
        Request<GetBucketLoggingConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLoggingConfigurationRequest, HttpMethodName.GET);
        request.addParameter("logging", null);
        return this.invoke(request, new Unmarshallers.BucketLoggingConfigurationnmarshaller(), getBucketLoggingConfigurationRequest.getBucketName(), null);
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketLoggingConfigurationRequest), (String)"The set bucket logging configuration request object must be specified when enabling server access logging");
        String bucketName = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration loggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when enabling server access logging");
        ValidationUtils.assertParameterNotNull((Object)loggingConfiguration, (String)"The logging configuration parameter must be specified when enabling server access logging");
        Request<SetBucketLoggingConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("logging", null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(loggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(String bucketName) throws AmazonServiceException, AmazonClientException {
        return this.getBucketAccelerateConfiguration(new GetBucketAccelerateConfigurationRequest(bucketName));
    }

    @Override
    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)getBucketAccelerateConfigurationRequest, (String)"getBucketAccelerateConfigurationRequest must be specified.");
        String bucketName = getBucketAccelerateConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when querying accelerate configuration");
        Request<GetBucketAccelerateConfigurationRequest> request = this.createRequest(bucketName, null, getBucketAccelerateConfigurationRequest, HttpMethodName.GET);
        request.addParameter("accelerate", null);
        return this.invoke(request, new Unmarshallers.BucketAccelerateConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public void setBucketAccelerateConfiguration(String bucketName, BucketAccelerateConfiguration accelerateConfiguration) throws AmazonServiceException, AmazonClientException {
        this.setBucketAccelerateConfiguration(new SetBucketAccelerateConfigurationRequest(bucketName, accelerateConfiguration));
    }

    @Override
    public void setBucketAccelerateConfiguration(SetBucketAccelerateConfigurationRequest setBucketAccelerateConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)setBucketAccelerateConfigurationRequest, (String)"setBucketAccelerateConfigurationRequest must be specified");
        String bucketName = setBucketAccelerateConfigurationRequest.getBucketName();
        BucketAccelerateConfiguration accelerateConfiguration = setBucketAccelerateConfigurationRequest.getAccelerateConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting accelerate configuration.");
        ValidationUtils.assertParameterNotNull((Object)accelerateConfiguration, (String)"The bucket accelerate configuration parameter must be specified.");
        ValidationUtils.assertParameterNotNull((Object)accelerateConfiguration.getStatus(), (String)"The status parameter must be specified when updating bucket accelerate configuration.");
        Request<SetBucketAccelerateConfigurationRequest> request = this.createRequest(bucketName, null, setBucketAccelerateConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("accelerate", null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(accelerateConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketPolicy getBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(bucketName));
    }

    @Override
    public void setBucketPolicy(String bucketName, String policyText) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when setting a bucket policy");
        ValidationUtils.assertParameterNotNull((Object)policyText, (String)"The policy text must be specified when setting a bucket policy");
        Request<GenericBucketRequest> request = this.createRequest(bucketName, null, new GenericBucketRequest(bucketName), HttpMethodName.PUT);
        request.addParameter("policy", null);
        byte[] bytes = ServiceUtils.toByteArray(policyText);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(bucketName));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)getBucketPolicyRequest, (String)"The request object must be specified when getting a bucket policy");
        String bucketName = getBucketPolicyRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when getting a bucket policy");
        Request<GetBucketPolicyRequest> request = this.createRequest(bucketName, null, getBucketPolicyRequest, HttpMethodName.GET);
        request.addParameter("policy", null);
        BucketPolicy result = new BucketPolicy();
        try {
            String policyText = this.invoke(request, new S3StringResponseHandler(), bucketName, null);
            result.setPolicyText(policyText);
            return result;
        }
        catch (AmazonServiceException ase) {
            if (ase.getErrorCode().equals("NoSuchBucketPolicy")) {
                return result;
            }
            throw ase;
        }
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketPolicyRequest), (String)"The request object must be specified when setting a bucket policy");
        String bucketName = setBucketPolicyRequest.getBucketName();
        String policyText = setBucketPolicyRequest.getPolicyText();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when setting a bucket policy");
        ValidationUtils.assertParameterNotNull((Object)policyText, (String)"The policy text must be specified when setting a bucket policy");
        Request<SetBucketPolicyRequest> request = this.createRequest(bucketName, null, setBucketPolicyRequest, HttpMethodName.PUT);
        request.addParameter("policy", null);
        byte[] bytes = ServiceUtils.toByteArray(policyText);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketPolicyRequest, (String)"The request object must be specified when deleting a bucket policy");
        String bucketName = deleteBucketPolicyRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name must be specified when deleting a bucket policy");
        Request<DeleteBucketPolicyRequest> request = this.createRequest(bucketName, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        request.addParameter("policy", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws AmazonClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws AmazonClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)generatePresignedUrlRequest, (String)"The request parameter must be specified when generating a pre-signed URL");
        String bucketName = generatePresignedUrlRequest.getBucketName();
        String key = generatePresignedUrlRequest.getKey();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when generating a pre-signed URL");
        ValidationUtils.assertParameterNotNull((Object)generatePresignedUrlRequest.getMethod(), (String)"The HTTP method request parameter must be specified when generating a pre-signed URL");
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethod = HttpMethodName.valueOf((String)generatePresignedUrlRequest.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, generatePresignedUrlRequest, httpMethod);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", generatePresignedUrlRequest.getVersionId());
        if (generatePresignedUrlRequest.isZeroByteContent()) {
            request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        for (Map.Entry<String, String> entry : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (generatePresignedUrlRequest.getContentType() != null) {
            request.addHeader("Content-Type", generatePresignedUrlRequest.getContentType());
        }
        if (generatePresignedUrlRequest.getContentMd5() != null) {
            request.addHeader("Content-MD5", generatePresignedUrlRequest.getContentMd5());
        }
        AmazonS3Client.populateSSE_C(request, generatePresignedUrlRequest.getSSECustomerKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", generatePresignedUrlRequest.getSSEAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", generatePresignedUrlRequest.getKmsCmkId());
        Map<String, String> customQueryParameters = generatePresignedUrlRequest.getCustomQueryParameters();
        if (customQueryParameters != null) {
            for (Map.Entry<String, String> entry : customQueryParameters.entrySet()) {
                request.addParameter(entry.getKey(), entry.getValue());
            }
        }
        AmazonS3Client.addResponseHeaderParameters(request, generatePresignedUrlRequest.getResponseHeaders());
        Signer signer = this.createSigner(request, bucketName, key);
        if (signer instanceof Presigner) {
            ((Presigner)signer).presignRequest(request, this.awsCredentialsProvider.getCredentials(), generatePresignedUrlRequest.getExpiration());
        } else {
            this.presignRequest(request, generatePresignedUrlRequest.getMethod(), bucketName, key, generatePresignedUrlRequest.getExpiration(), null);
        }
        return ServiceUtils.convertRequestToUrl(request, true);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)abortMultipartUploadRequest, (String)"The request parameter must be specified when aborting a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)abortMultipartUploadRequest.getBucketName(), (String)"The bucket name parameter must be specified when aborting a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)abortMultipartUploadRequest.getKey(), (String)"The key parameter must be specified when aborting a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)abortMultipartUploadRequest.getUploadId(), (String)"The upload ID parameter must be specified when aborting a multipart upload");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        Request<AbortMultipartUploadRequest> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        AmazonS3Client.populateRequesterPaysHeader(request, abortMultipartUploadRequest.isRequesterPays());
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler;
        ValidationUtils.assertParameterNotNull((Object)completeMultipartUploadRequest, (String)"The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when completing a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when completing a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)uploadId, (String)"The upload ID parameter must be specified when completing a multipart upload");
        ValidationUtils.assertParameterNotNull(completeMultipartUploadRequest.getPartETags(), (String)"The part ETags parameter must be specified when completing a multipart upload");
        int retries = 0;
        do {
            Request<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
            request.addParameter("uploadId", uploadId);
            AmazonS3Client.populateRequesterPaysHeader(request, completeMultipartUploadRequest.isRequesterPays());
            byte[] xml = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            request.addHeader("Content-Type", "application/xml");
            request.addHeader("Content-Length", String.valueOf(xml.length));
            request.setContent((InputStream)new ByteArrayInputStream(xml));
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3VersionHeaderHandler(), new S3RequesterChargedHeaderHandler());
            handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHandler, bucketName, key);
            if (handler.getCompleteMultipartUploadResult() == null) continue;
            return handler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, handler.getAmazonS3Exception(), retries++));
        throw handler.getAmazonS3Exception();
    }

    private boolean shouldRetryCompleteMultipartUpload(AmazonWebServiceRequest originalRequest, AmazonS3Exception exception, int retriesAttempted) {
        RetryPolicy retryPolicy = this.clientConfiguration.getRetryPolicy();
        if (retryPolicy == null || retryPolicy.getRetryCondition() == null) {
            return false;
        }
        if (retryPolicy == PredefinedRetryPolicies.NO_RETRY_POLICY) {
            return false;
        }
        return this.completeMultipartUploadRetryCondition.shouldRetry(originalRequest, (AmazonClientException)((Object)exception), retriesAttempted);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)initiateMultipartUploadRequest, (String)"The request parameter must be specified when initiating a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)initiateMultipartUploadRequest.getBucketName(), (String)"The bucket name parameter must be specified when initiating a multipart upload");
        ValidationUtils.assertParameterNotNull((Object)initiateMultipartUploadRequest.getKey(), (String)"The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-amz-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(initiateMultipartUploadRequest.getTagging()));
        AmazonS3Client.populateRequesterPaysHeader(request, initiateMultipartUploadRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, initiateMultipartUploadRequest.getSSECustomerKey());
        AmazonS3Client.populateSSE_KMS(request, initiateMultipartUploadRequest.getSSEAwsKeyManagementParams());
        this.setZeroContentLength(request);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)listMultipartUploadsRequest), (String)"The request parameter must be specified when listing multipart uploads");
        ValidationUtils.assertParameterNotNull((Object)listMultipartUploadsRequest.getBucketName(), (String)"The bucket name parameter must be specified when listing multipart uploads");
        Request<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller(), listMultipartUploadsRequest.getBucketName(), null);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws AmazonClientException, AmazonServiceException {
        ValidationUtils.assertParameterNotNull((Object)((Object)listPartsRequest), (String)"The request parameter must be specified when listing parts");
        ValidationUtils.assertParameterNotNull((Object)listPartsRequest.getBucketName(), (String)"The bucket name parameter must be specified when listing parts");
        ValidationUtils.assertParameterNotNull((Object)listPartsRequest.getKey(), (String)"The key parameter must be specified when listing parts");
        ValidationUtils.assertParameterNotNull((Object)listPartsRequest.getUploadId(), (String)"The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, listPartsRequest.isRequesterPays());
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller(), listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        ProgressListener progressListener;
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor;
        ValidationUtils.assertParameterNotNull((Object)uploadPartRequest, (String)"The request parameter must be specified when uploading a part");
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when uploading a part");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when uploading a part");
        ValidationUtils.assertParameterNotNull((Object)uploadId, (String)"The upload ID parameter must be specified when uploading a part");
        ValidationUtils.assertParameterNotNull((Object)partNumber, (String)"The part number parameter must be specified when uploading a part");
        ValidationUtils.assertParameterNotNull((Object)partSize, (String)"The part size parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        request.addHeader("Content-Length", Long.toString(partSize));
        AmazonS3Client.populateRequesterPaysHeader(request, uploadPartRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, uploadPartRequest.getSSECustomerKey());
        Object inputStream = null;
        if (uploadPartRequest.getInputStream() != null) {
            inputStream = uploadPartRequest.getInputStream();
        } else if (uploadPartRequest.getFile() != null) {
            try {
                inputStream = new InputSubstream((InputStream)((Object)new RepeatableFileInputStream(uploadPartRequest.getFile())), uploadPartRequest.getFileOffset(), partSize, true);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The specified file doesn't exist", e);
            }
        } else {
            throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
        }
        if (uploadPartRequest.getMd5Digest() == null && !ServiceUtils.skipMd5CheckPerRequest(uploadPartRequest, this.clientOptions) && ((InputStream)inputStream).markSupported()) {
            try {
                String contentMd5_b64 = Md5Utils.md5AsBase64((InputStream)inputStream);
                AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", contentMd5_b64);
                ((InputStream)inputStream).reset();
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to calculate MD5 hash: " + e.getMessage(), (Throwable)e);
            }
        }
        if ((progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)(progressListener = uploadPartRequest.getGeneralProgressListener()))) != null) {
            inputStream = new ProgressReportingInputStream((InputStream)inputStream, progressListenerCallbackExecutor);
            ((ProgressReportingInputStream)inputStream).setNotificationThreshold(this.notificationThreshold);
            this.fireProgressEvent(progressListenerCallbackExecutor, 1024);
        }
        try {
            request.setContent((InputStream)inputStream);
            ObjectMetadata metadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2048);
            UploadPartResult result = new UploadPartResult();
            result.setETag(metadata.getETag());
            result.setPartNumber(partNumber);
            result.setSSEAlgorithm(metadata.getSSEAlgorithm());
            result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
            result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
            result.setRequesterCharged(metadata.isRequesterCharged());
            UploadPartResult uploadPartResult = result;
            return uploadPartResult;
        }
        catch (AmazonClientException ace) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 4096);
            throw ace;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return (S3ResponseMetadata)this.client.getResponseMetadataForRequest(request);
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws AmazonServiceException {
        String bucketName = restoreObjectRequest.getBucketName();
        String key = restoreObjectRequest.getKey();
        String versionId = restoreObjectRequest.getVersionId();
        int expirationIndays = restoreObjectRequest.getExpirationInDays();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when copying a glacier object");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"The key parameter must be specified when copying a glacier object");
        if (expirationIndays == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a glacier object");
        }
        Request<RestoreObjectRequest> request = this.createRequest(bucketName, key, restoreObjectRequest, HttpMethodName.POST);
        request.addParameter("restore", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, restoreObjectRequest.isRequesterPays());
        byte[] content = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void restoreObject(String bucketName, String key, int expirationInDays) throws AmazonServiceException {
        this.restoreObject(new RestoreObjectRequest(bucketName, key, expirationInDays));
    }

    private void fireProgressEvent(ProgressListenerCallbackExecutor progressListenerCallbackExecutor, int eventType) {
        if (progressListenerCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        progressListenerCallbackExecutor.progressChanged(event);
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        return this.invoke(request, new Unmarshallers.AccessControlListUnmarshaller(), bucketName, key);
    }

    private void setAcl(String bucketName, String key, String versionId, CannedAccessControlList cannedAcl, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-amz-acl", cannedAcl.toString());
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    private void setAcl(String bucketName, String key, String versionId, AccessControlList acl, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        byte[] aclAsXml = new AclXmlFactory().convertToXmlByteArray(acl);
        request.addHeader("Content-Type", "application/xml");
        request.addHeader("Content-Length", String.valueOf(aclAsXml.length));
        request.setContent((InputStream)new ByteArrayInputStream(aclAsXml));
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    protected Signer createSigner(Request<?> request, String bucketName, String key) {
        URI uri = this.clientOptions.isAccelerateModeEnabled() ? this.endpoint : request.getEndpoint();
        Signer signer = this.getSignerByURI(uri);
        if (!this.isSignerOverridden()) {
            String regionOverride;
            if (signer instanceof AWSS3V4Signer && this.noExplicitRegionProvided(request)) {
                String region;
                String string = region = this.clientRegion == null ? bucketRegionCache.get(bucketName) : this.clientRegion;
                if (region != null) {
                    this.resolveRequestEndpoint(request, bucketName, key, RuntimeHttpUtils.toUri((String)RegionUtils.getRegion((String)region).getServiceEndpoint(S3_SERVICE_NAME), (ClientConfiguration)this.clientConfiguration));
                    AWSS3V4Signer sigV4Signer = (AWSS3V4Signer)signer;
                    this.setAWSS3V4SignerWithServiceNameAndRegion((AWSS3V4Signer)signer, region);
                    return sigV4Signer;
                }
                if (request.getOriginalRequest() instanceof GeneratePresignedUrlRequest) {
                    return this.createSigV2Signer(request, bucketName, key);
                }
            }
            String string = this.getSignerRegionOverride() == null ? (this.clientRegion == null ? bucketRegionCache.get(bucketName) : this.clientRegion) : (regionOverride = this.getSignerRegionOverride());
            if (regionOverride != null) {
                AWSS3V4Signer sigV4Signer = new AWSS3V4Signer();
                this.setAWSS3V4SignerWithServiceNameAndRegion(sigV4Signer, regionOverride);
                return sigV4Signer;
            }
        }
        if (signer instanceof S3Signer) {
            return this.createSigV2Signer(request, bucketName, key);
        }
        return signer;
    }

    private void setAWSS3V4SignerWithServiceNameAndRegion(AWSS3V4Signer sigV4Signer, String region) {
        sigV4Signer.setServiceName(this.getServiceNameIntern());
        sigV4Signer.setRegionName(region);
    }

    private boolean isSignerOverridden() {
        return this.clientConfiguration != null && this.clientConfiguration.getSignerOverride() != null;
    }

    private boolean noExplicitRegionProvided(Request<?> request) {
        return this.isStandardEndpoint(request.getEndpoint()) && this.getSignerRegion() == null;
    }

    private String getSignerRegion() {
        String region = this.getSignerRegionOverride();
        if (region == null) {
            region = this.clientRegion;
        }
        return region;
    }

    private boolean isStandardEndpoint(URI endpoint) {
        return endpoint.getHost().endsWith("s3.amazonaws.com");
    }

    @Deprecated
    private S3Signer createSigV2Signer(Request<?> request, String bucketName, String key) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        return new S3Signer(request.getHttpMethod().toString(), resourcePath);
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod methodName, String bucketName, String key, Date expiration, String subResource) {
        this.beforeRequest(request);
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "") + (subResource != null ? "?" + subResource : "");
        resourcePath = resourcePath.replaceAll("(?<=/)/", "%2F");
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        new S3QueryStringSigner(methodName.toString(), resourcePath, expiration).sign(request, credentials);
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String value = (String)request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", value);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private <T> void beforeRequest(Request<T> request) {
        if (this.requestHandler2s != null) {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.beforeRequest(request);
            }
        }
    }

    private URI convertToVirtualHostEndpoint(URI endpoint, String bucketName) {
        try {
            return new URI(endpoint.getScheme() + "://" + bucketName + "." + endpoint.getAuthority());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid bucket name: " + bucketName, e);
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Date httpExpiresDate;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata.get("x-amz-server-side-encryption-aws-kms-key-id") != null && !ObjectMetadata.KMS_SERVER_SIDE_ENCRYPTION.equals(rawMetadata.get("x-amz-server-side-encryption"))) {
            throw new IllegalArgumentException("If you specify a KMS key id for server side encryption, you must also set the SSEAlgorithm to ObjectMetadata.KMS_SERVER_SIDE_ENCRYPTION");
        }
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((httpExpiresDate = metadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date((Date)httpExpiresDate));
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                if ("x-amz-tagging".equals(key)) continue;
                request.addHeader("x-amz-meta-" + key, value);
            }
        }
    }

    private void populateRequestWithMfaDetails(Request<?> request, MultiFactorAuthentication mfa) {
        if (mfa == null) {
            return;
        }
        String endpoint = request.getEndpoint().toString();
        if (endpoint.startsWith("http://")) {
            String httpsEndpoint = endpoint.replace("http://", "https://");
            request.setEndpoint(URI.create(httpsEndpoint));
            log.info((Object)"Overriding current endpoint to use HTTPS as required by S3 for requests containing an MFA header");
        }
        request.addHeader("x-amz-mfa", mfa.getDeviceSerialNumber() + " " + mfa.getToken());
    }

    private void populateRequestWithCopyObjectParameters(Request<? extends AmazonWebServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + copyObjectRequest.getSourceKey();
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", copySourceHeader);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, copyObjectRequest.isRequesterPays());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
            AmazonS3Client.populateRequestMetadata(request, newObjectMetadata);
        }
        AmazonS3Client.populateSourceSSE_C(request, copyObjectRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyObjectRequest.getDestinationSSECustomerKey());
    }

    private void populateRequestWithCopyPartParameters(Request<?> request, CopyPartRequest copyPartRequest) {
        String copySourceHeader = "/" + copyPartRequest.getSourceBucketName() + "/" + copyPartRequest.getSourceKey();
        if (copyPartRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", copySourceHeader);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String range = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-amz-copy-source-range", range);
        }
        AmazonS3Client.populateSourceSSE_C(request, copyPartRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyPartRequest.getDestinationSSECustomerKey());
    }

    private static void populateSSE_C(Request<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key", sseKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode((String)encryptionKey_b64);
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])encryptionKey));
        }
    }

    private static void populateSourceSSE_C(Request<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key", sseKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode((String)encryptionKey_b64);
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])encryptionKey));
        }
    }

    private static void populateSSE_KMS(Request<?> request, SSEAwsKeyManagementParams sseParams) {
        if (sseParams != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", sseParams.getEncryption());
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", sseParams.getAwsKmsKeyId());
        }
    }

    private void addPartNumberIfNotNull(Request<?> request, Integer partNumber) {
        if (partNumber != null) {
            request.addParameter("partNumber", partNumber.toString());
        }
    }

    private static void addHeaderIfNotNull(Request<?> request, String header, String value) {
        if (value != null) {
            request.addHeader(header, value);
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String paramName, Integer paramValue) {
        if (paramValue != null) {
            AmazonS3Client.addParameterIfNotNull(request, paramName, paramValue.toString());
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String paramName, String paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, paramValue);
        }
    }

    private static void addDateHeader(Request<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, ServiceUtils.formatRfc822Date(value));
        }
    }

    private static void addStringListHeader(Request<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, ServiceUtils.join(values));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }

    public String getResourceUrl(String bucketName, String key) {
        try {
            return this.getUrl(bucketName, key).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URL getUrl(String bucketName, String key) {
        DefaultRequest request = new DefaultRequest("Amazon S3");
        this.resolveRequestEndpoint((Request<?>)request, bucketName, key);
        return ServiceUtils.convertRequestToUrl(request);
    }

    @Override
    public Region getRegion() {
        String authority = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(authority)) {
            return Region.US_Standard;
        }
        Matcher m = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(authority);
        if (m.matches()) {
            return Region.fromValue(m.group(1));
        }
        throw new IllegalStateException("S3 client with invalid S3 endpoint configured");
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        return this.createRequest(bucketName, key, originalRequest, httpMethod, null);
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod, URI endpoint) {
        DefaultRequest request = new DefaultRequest(originalRequest, "Amazon S3");
        if (this.clientOptions.isAccelerateModeEnabled() && !(request.getOriginalRequest() instanceof S3AccelerateUnsupported)) {
            endpoint = this.clientOptions.isDualstackEnabled() ? RuntimeHttpUtils.toUri((String)"s3-accelerate.dualstack.amazonaws.com", (ClientConfiguration)this.clientConfiguration) : RuntimeHttpUtils.toUri((String)"s3-accelerate.amazonaws.com", (ClientConfiguration)this.clientConfiguration);
        } else if (this.clientOptions.isDualstackEnabled()) {
            String hostname = String.format("s3.dualstack.%s.amazonaws.com", this.getRegionName());
            endpoint = RuntimeHttpUtils.toUri((String)hostname, (ClientConfiguration)this.clientConfiguration);
        }
        request.setHttpMethod(httpMethod);
        this.resolveRequestEndpoint((Request<?>)request, bucketName, key, endpoint);
        return request;
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String bucketName, String key) {
        return this.invoke(request, new S3XmlResponseHandler<X>(unmarshaller), bucketName, key);
    }

    protected final ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req) || AmazonS3Client.isProfilingEnabled();
        return new S3ExecutionContext(this.requestHandler2s, isMetricsEnabled, this);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, String bucket, String key) {
        Object object;
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        request.setAWSRequestMetrics(awsRequestMetrics);
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Response response = null;
        try {
            request.setTimeOffset(this.timeOffset);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/octet-stream");
            }
            if (bucket != null && !(request.getOriginalRequest() instanceof CreateBucketRequest) && this.noExplicitRegionProvided(request)) {
                this.fetchRegionFromCache(bucket);
            }
            AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
            if (originalRequest.getRequestCredentials() != null) {
                credentials = originalRequest.getRequestCredentials();
            }
            executionContext.setSigner(this.createSigner(request, bucket, key));
            executionContext.setCredentials(credentials);
            response = this.client.execute(request, responseHandler, (HttpResponseHandler)this.errorResponseHandler, executionContext);
            object = response.getAwsResponse();
        }
        catch (AmazonS3Exception ase) {
            try {
                if (ase.getStatusCode() == 301 && ase.getAdditionalDetails() != null) {
                    String region = ase.getAdditionalDetails().get("x-amz-bucket-region");
                    bucketRegionCache.put(bucket, region);
                    ase.setErrorMessage("The bucket is in this region: " + region + ". Please use this region to retry the request");
                }
                throw ase;
            }
            catch (Throwable throwable) {
                this.endClientExecution(awsRequestMetrics, request, response);
                throw throwable;
            }
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return (X)object;
    }

    @Override
    public void enableRequesterPays(String bucketName) {
        RequestPaymentConfiguration configuration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.Requester);
        this.setBucketRequestPayment(new SetRequestPaymentConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void disableRequesterPays(String bucketName) {
        RequestPaymentConfiguration configuration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.BucketOwner);
        this.setBucketRequestPayment(new SetRequestPaymentConfigurationRequest(bucketName, configuration));
    }

    @Override
    public boolean isRequesterPaysEnabled(String bucketName) {
        RequestPaymentConfiguration configuration = this.getBucketRequestPayment(new GetRequestPaymentConfigurationRequest(bucketName));
        return configuration.getPayer() == RequestPaymentConfiguration.Payer.Requester;
    }

    private void setBucketRequestPayment(SetRequestPaymentConfigurationRequest setRequestPaymentConfigurationRequest) {
        String bucketName = setRequestPaymentConfigurationRequest.getBucketName();
        RequestPaymentConfiguration configuration = setRequestPaymentConfigurationRequest.getConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified while setting the Requester Pays.");
        ValidationUtils.assertParameterNotNull((Object)configuration, (String)"The request payment configuration parameter must be specified when setting the Requester Pays.");
        Request<SetRequestPaymentConfigurationRequest> request = this.createRequest(bucketName, null, setRequestPaymentConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = requestPaymentConfigurationXmlFactory.convertToXmlByteArray(configuration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    private RequestPaymentConfiguration getBucketRequestPayment(GetRequestPaymentConfigurationRequest getRequestPaymentConfigurationRequest) {
        String bucketName = getRequestPaymentConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified while getting the Request Payment Configuration.");
        Request<GetRequestPaymentConfigurationRequest> request = this.createRequest(bucketName, null, getRequestPaymentConfigurationRequest, HttpMethodName.GET);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        return this.invoke(request, new Unmarshallers.RequestPaymentConfigurationUnmarshaller(), bucketName, null);
    }

    private void setZeroContentLength(Request<?> req) {
        req.addHeader("Content-Length", String.valueOf(0));
    }

    private ByteArrayInputStream toByteArray(InputStream is) {
        int size = 262144;
        byte[] buf = new byte[262144];
        int len = 0;
        try {
            int read;
            for (int available = 262144; available > 0 && (read = is.read(buf, len, available)) != -1; available -= read) {
                len += read;
            }
            if (is.read() != -1) {
                throw new AmazonClientException("Input stream exceeds 256k buffer.");
            }
            is.close();
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Failed to read from inputstream", (Throwable)ioe);
        }
        return new ByteArrayInputStream(buf, 0, len);
    }

    @Override
    public void setBucketReplicationConfiguration(String bucketName, BucketReplicationConfiguration configuration) throws AmazonServiceException, AmazonClientException {
        this.setBucketReplicationConfiguration(new SetBucketReplicationConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)((Object)setBucketReplicationConfigurationRequest), (String)"The set bucket replication configuration request object must be specified.");
        String bucketName = setBucketReplicationConfigurationRequest.getBucketName();
        BucketReplicationConfiguration bucketReplicationConfiguration = setBucketReplicationConfigurationRequest.getReplicationConfiguration();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when setting replication configuration.");
        ValidationUtils.assertParameterNotNull((Object)bucketReplicationConfiguration, (String)"The replication configuration parameter must be specified when setting replication configuration.");
        Request<SetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, setBucketReplicationConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("replication", null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketReplicationConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        try {
            request.addHeader("Content-MD5", BinaryUtils.toBase64((byte[])Md5Utils.computeMD5Hash((byte[])bytes)));
        }
        catch (Exception e) {
            throw new AmazonClientException("Not able to compute MD5 of the replication rule configuration. Exception Message : " + e.getMessage(), (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws AmazonServiceException, AmazonClientException {
        return this.getBucketReplicationConfiguration(new GetBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)getBucketReplicationConfigurationRequest, (String)"The bucket request parameter must be specified when retrieving replication configuration");
        String bucketName = getBucketReplicationConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket request must specify a bucket name when retrieving replication configuration");
        Request<GetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, getBucketReplicationConfigurationRequest, HttpMethodName.GET);
        request.addParameter("replication", null);
        return this.invoke(request, new Unmarshallers.BucketReplicationConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public void deleteBucketReplicationConfiguration(String bucketName) throws AmazonServiceException, AmazonClientException {
        this.deleteBucketReplicationConfiguration(new DeleteBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest deleteBucketReplicationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        String bucketName = deleteBucketReplicationConfigurationRequest.getBucketName();
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"The bucket name parameter must be specified when deleting replication configuration");
        Request<DeleteBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketReplicationConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("replication", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.deleteBucketMetricsConfiguration(new DeleteBucketMetricsConfigurationRequest(bucketName, id));
    }

    @Override
    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketMetricsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)deleteBucketMetricsConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)deleteBucketMetricsConfigurationRequest.getId(), (String)"Metrics Id");
        Request<DeleteBucketMetricsConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketMetricsConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("metrics", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.DeleteBucketMetricsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.getBucketMetricsConfiguration(new GetBucketMetricsConfigurationRequest(bucketName, id));
    }

    @Override
    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)getBucketMetricsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)getBucketMetricsConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)getBucketMetricsConfigurationRequest.getId(), (String)"Metrics Id");
        Request<GetBucketMetricsConfigurationRequest> request = this.createRequest(bucketName, null, getBucketMetricsConfigurationRequest, HttpMethodName.GET);
        request.addParameter("metrics", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.GetBucketMetricsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(String bucketName, MetricsConfiguration metricsConfiguration) throws AmazonServiceException, AmazonClientException {
        return this.setBucketMetricsConfiguration(new SetBucketMetricsConfigurationRequest(bucketName, metricsConfiguration));
    }

    @Override
    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(SetBucketMetricsConfigurationRequest setBucketMetricsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        new SetBucketMetricsConfigurationRequest();
        ValidationUtils.assertParameterNotNull((Object)setBucketMetricsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)setBucketMetricsConfigurationRequest.getBucketName(), (String)"BucketName");
        MetricsConfiguration metricsConfiguration = (MetricsConfiguration)ValidationUtils.assertNotNull((Object)setBucketMetricsConfigurationRequest.getMetricsConfiguration(), (String)"Metrics Configuration");
        String id = (String)ValidationUtils.assertNotNull((Object)metricsConfiguration.getId(), (String)"Metrics Id");
        Request<SetBucketMetricsConfigurationRequest> request = this.createRequest(bucketName, null, setBucketMetricsConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("metrics", null);
        request.addParameter("id", id);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(metricsConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        return this.invoke(request, new Unmarshallers.SetBucketMetricsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public ListBucketMetricsConfigurationsResult listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)listBucketMetricsConfigurationsRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)listBucketMetricsConfigurationsRequest.getBucketName(), (String)"BucketName");
        Request<ListBucketMetricsConfigurationsRequest> request = this.createRequest(bucketName, null, listBucketMetricsConfigurationsRequest, HttpMethodName.GET);
        request.addParameter("metrics", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketMetricsConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketMetricsConfigurationsUnmarshaller(), bucketName, null);
    }

    @Override
    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.deleteBucketAnalyticsConfiguration(new DeleteBucketAnalyticsConfigurationRequest(bucketName, id));
    }

    @Override
    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketAnalyticsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)deleteBucketAnalyticsConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)deleteBucketAnalyticsConfigurationRequest.getId(), (String)"Analytics Id");
        Request<DeleteBucketAnalyticsConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketAnalyticsConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("analytics", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.DeleteBucketAnalyticsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.getBucketAnalyticsConfiguration(new GetBucketAnalyticsConfigurationRequest(bucketName, id));
    }

    @Override
    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)getBucketAnalyticsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)getBucketAnalyticsConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)getBucketAnalyticsConfigurationRequest.getId(), (String)"Analytics Id");
        Request<GetBucketAnalyticsConfigurationRequest> request = this.createRequest(bucketName, null, getBucketAnalyticsConfigurationRequest, HttpMethodName.GET);
        request.addParameter("analytics", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.GetBucketAnalyticsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(String bucketName, AnalyticsConfiguration analyticsConfiguration) throws AmazonServiceException, AmazonClientException {
        return this.setBucketAnalyticsConfiguration(new SetBucketAnalyticsConfigurationRequest(bucketName, analyticsConfiguration));
    }

    @Override
    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(SetBucketAnalyticsConfigurationRequest setBucketAnalyticsConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)setBucketAnalyticsConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)setBucketAnalyticsConfigurationRequest.getBucketName(), (String)"BucketName");
        AnalyticsConfiguration analyticsConfiguration = (AnalyticsConfiguration)ValidationUtils.assertNotNull((Object)setBucketAnalyticsConfigurationRequest.getAnalyticsConfiguration(), (String)"Analytics Configuration");
        String id = (String)ValidationUtils.assertNotNull((Object)analyticsConfiguration.getId(), (String)"Analytics Id");
        Request<SetBucketAnalyticsConfigurationRequest> request = this.createRequest(bucketName, null, setBucketAnalyticsConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("analytics", null);
        request.addParameter("id", id);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(analyticsConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        return this.invoke(request, new Unmarshallers.SetBucketAnalyticsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public ListBucketAnalyticsConfigurationsResult listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)listBucketAnalyticsConfigurationsRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)listBucketAnalyticsConfigurationsRequest.getBucketName(), (String)"BucketName");
        Request<ListBucketAnalyticsConfigurationsRequest> request = this.createRequest(bucketName, null, listBucketAnalyticsConfigurationsRequest, HttpMethodName.GET);
        request.addParameter("analytics", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketAnalyticsConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketAnalyticsConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.deleteBucketInventoryConfiguration(new DeleteBucketInventoryConfigurationRequest(bucketName, id));
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)deleteBucketInventoryConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)deleteBucketInventoryConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)deleteBucketInventoryConfigurationRequest.getId(), (String)"Inventory id");
        Request<DeleteBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketInventoryConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.DeleteBucketInventoryConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String bucketName, String id) throws AmazonServiceException, AmazonClientException {
        return this.getBucketInventoryConfiguration(new GetBucketInventoryConfigurationRequest(bucketName, id));
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)getBucketInventoryConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)getBucketInventoryConfigurationRequest.getBucketName(), (String)"BucketName");
        String id = ValidationUtils.assertStringNotEmpty((String)getBucketInventoryConfigurationRequest.getId(), (String)"Inventory id");
        Request<GetBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, getBucketInventoryConfigurationRequest, HttpMethodName.GET);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.GetBucketInventoryConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(String bucketName, InventoryConfiguration inventoryConfiguration) throws AmazonServiceException, AmazonClientException {
        return this.setBucketInventoryConfiguration(new SetBucketInventoryConfigurationRequest(bucketName, inventoryConfiguration));
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)setBucketInventoryConfigurationRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)setBucketInventoryConfigurationRequest.getBucketName(), (String)"BucketName");
        InventoryConfiguration inventoryConfiguration = (InventoryConfiguration)ValidationUtils.assertNotNull((Object)setBucketInventoryConfigurationRequest.getInventoryConfiguration(), (String)"InventoryConfiguration");
        String id = (String)ValidationUtils.assertNotNull((Object)inventoryConfiguration.getId(), (String)"Inventory id");
        Request<SetBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, setBucketInventoryConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(inventoryConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        return this.invoke(request, new Unmarshallers.SetBucketInventoryConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)listBucketInventoryConfigurationsRequest, (String)"The request cannot be null");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)listBucketInventoryConfigurationsRequest.getBucketName(), (String)"BucketName");
        Request<ListBucketInventoryConfigurationsRequest> request = this.createRequest(bucketName, null, listBucketInventoryConfigurationsRequest, HttpMethodName.GET);
        request.addParameter("inventory", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketInventoryConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketInventoryConfigurationsUnmarshaller(), bucketName, null);
    }

    private String urlEncodeTags(ObjectTagging tagging) {
        if (tagging == null || tagging.getTagSet() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Tag> tagIter = tagging.getTagSet().iterator();
        while (tagIter.hasNext()) {
            Tag tag = tagIter.next();
            sb.append(S3HttpUtils.urlEncode(tag.getKey(), false)).append('=').append(S3HttpUtils.urlEncode(tag.getValue(), false));
            if (!tagIter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private void setContent(Request<?> request, byte[] content, String contentType, boolean setMd5) {
        request.setContent((InputStream)new ByteArrayInputStream(content));
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", contentType);
        if (setMd5) {
            try {
                byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
                String md5Base64 = BinaryUtils.toBase64((byte[])md5);
                request.addHeader("Content-MD5", md5Base64);
            }
            catch (Exception e) {
                throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
            }
        }
    }

    protected static void populateRequesterPaysHeader(Request<?> request, boolean isRequesterPays) {
        if (isRequesterPays) {
            request.addHeader("x-amz-request-payer", "requester");
        }
    }

    @Override
    public String getObjectAsString(String bucketName, String key) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"Bucket name must be provided");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"Object key must be provided");
        S3Object object = this.getObject(bucketName, key);
        try {
            return IOUtils.toString((InputStream)((Object)object.getObjectContent()));
        }
        catch (IOException e) {
            throw new AmazonClientException("Error streaming content from S3 during download");
        }
    }

    @Override
    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        ValidationUtils.assertParameterNotNull((Object)getObjectTaggingRequest, (String)"The request parameter must be specified when getting the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)getObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = (String)ValidationUtils.assertNotNull((Object)getObjectTaggingRequest.getKey(), (String)"Key");
        Request<GetObjectTaggingRequest> request = this.createRequest(bucketName, key, getObjectTaggingRequest, HttpMethodName.GET);
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", getObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<GetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<GetObjectTaggingResult>(new Unmarshallers.GetObjectTaggingResponseUnmarshaller(), new GetObjectTaggingResponseHeaderHandler());
        return (GetObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        ValidationUtils.assertParameterNotNull((Object)setObjectTaggingRequest, (String)"The request parameter must be specified setting the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)setObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = (String)ValidationUtils.assertNotNull((Object)setObjectTaggingRequest.getKey(), (String)"Key");
        ObjectTagging tagging = (ObjectTagging)ValidationUtils.assertNotNull((Object)setObjectTaggingRequest.getTagging(), (String)"ObjectTagging");
        Request<SetObjectTaggingRequest> request = this.createRequest(bucketName, key, setObjectTaggingRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", setObjectTaggingRequest.getVersionId());
        byte[] content = new ObjectTaggingXmlFactory().convertToXmlByteArray(tagging);
        this.setContent(request, content, "application/xml", true);
        ResponseHeaderHandlerChain<SetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<SetObjectTaggingResult>(new Unmarshallers.SetObjectTaggingResponseUnmarshaller(), new SetObjectTaggingResponseHeaderHandler());
        return (SetObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        ValidationUtils.assertParameterNotNull((Object)deleteObjectTaggingRequest, (String)"The request parameter must be specified when delete the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)deleteObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = ValidationUtils.assertStringNotEmpty((String)deleteObjectTaggingRequest.getKey(), (String)"Key");
        Request<DeleteObjectTaggingRequest> request = this.createRequest(bucketName, key, deleteObjectTaggingRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", deleteObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<DeleteObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<DeleteObjectTaggingResult>(new Unmarshallers.DeleteObjectTaggingResponseUnmarshaller(), new DeleteObjectTaggingHeaderHandler());
        return (DeleteObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, String content) throws AmazonServiceException, AmazonClientException {
        ValidationUtils.assertParameterNotNull((Object)bucketName, (String)"Bucket name must be provided");
        ValidationUtils.assertParameterNotNull((Object)key, (String)"Object key must be provided");
        ValidationUtils.assertParameterNotNull((Object)content, (String)"String content must be provided");
        byte[] contentBytes = content.getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        metadata.setContentLength(contentBytes.length);
        return this.putObject(new PutObjectRequest(bucketName, key, is, metadata));
    }

    @Override
    public String getRegionName() {
        String authority = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(authority)) {
            return "us-east-1";
        }
        Matcher m = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(authority);
        try {
            m.matches();
            return RegionUtils.getRegion((String)m.group(1)).getName();
        }
        catch (Exception e) {
            throw new IllegalStateException("No valid region has been specified. Unable to return region name", e);
        }
    }

    private String fetchRegionFromCache(String bucketName) {
        String bucketRegion = bucketRegionCache.get(bucketName);
        if (bucketRegion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bucket region cache doesn't have an entry for " + bucketName + ". Trying to get bucket region from Amazon S3."));
            }
            if ((bucketRegion = this.getBucketRegionViaHeadRequest(bucketName)) != null) {
                bucketRegionCache.put(bucketName, bucketRegion);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Region for " + bucketName + " is " + bucketRegion));
        }
        return bucketRegion;
    }

    private String getBucketRegionViaHeadRequest(String bucketName) {
        String bucketRegion = null;
        try {
            String endpoint = "https://s3-us-west-1.amazonaws.com";
            Request<HeadBucketRequest> request = this.createRequest(bucketName, null, new HeadBucketRequest(bucketName), HttpMethodName.HEAD, new URI("https://s3-us-west-1.amazonaws.com"));
            HeadBucketResult result = this.invoke(request, new HeadBucketResultHandler(), bucketName, null);
            bucketRegion = result.getBucketRegion();
        }
        catch (AmazonS3Exception exception) {
            if (exception.getAdditionalDetails() != null) {
                bucketRegion = exception.getAdditionalDetails().get("x-amz-bucket-region");
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Error while creating URI");
        }
        if (bucketRegion == null && log.isDebugEnabled()) {
            log.debug((Object)("Not able to derive region of the " + bucketName + " from the HEAD Bucket requests."));
        }
        return bucketRegion;
    }

    public void resolveRequestEndpoint(Request<?> request, String bucketName, String key) {
        this.resolveRequestEndpoint(request, bucketName, key, null);
    }

    public void resolveRequestEndpoint(Request<?> request, String bucketName, String key, URI endpoint) {
        URI ep;
        URI uRI = ep = endpoint == null ? this.endpoint : endpoint;
        if (this.shouldUseVirtualAddressing(ep, bucketName)) {
            log.debug((Object)("Using virtual style addressing. Endpoint = " + ep));
            request.setEndpoint(this.convertToVirtualHostEndpoint(ep, bucketName));
            request.setResourcePath(this.getHostStyleResourcePath(key));
        } else {
            log.debug((Object)("Using path style addressing. Endpoint = " + ep));
            request.setEndpoint(ep);
            if (bucketName != null) {
                request.setResourcePath(this.getPathStyleResourcePath(bucketName, key));
            }
        }
        log.debug((Object)("Key: " + key + "; Request: " + request));
    }

    private boolean shouldUseVirtualAddressing(URI endpoint, String bucketName) {
        return !this.clientOptions.isPathStyleAccess() && BucketNameUtils.isDNSBucketName(bucketName) && !AmazonS3Client.isValidIpV4Address(endpoint.getHost());
    }

    private String getHostStyleResourcePath(String key) {
        String resourcePath = key;
        if (key != null && key.startsWith("/")) {
            resourcePath = "/" + key;
        }
        return resourcePath;
    }

    private String getPathStyleResourcePath(String bucketName, String key) {
        return bucketName + "/" + (key != null ? key : "");
    }

    static boolean isValidIpV4Address(String ipAddr) {
        if (ipAddr == null) {
            return false;
        }
        String[] tokens = ipAddr.split("\\.");
        if (tokens.length != 4) {
            return false;
        }
        for (String token : tokens) {
            try {
                int tokenInt = Integer.parseInt(token);
                if (tokenInt >= 0 && tokenInt <= 255) continue;
                return false;
            }
            catch (NumberFormatException ase) {
                return false;
            }
        }
        return true;
    }

    static {
        AwsSdkMetrics.addAll(Arrays.asList(S3ServiceMetric.values()));
        SignerFactory.registerSigner((String)S3_V4_SIGNER, AWSS3V4Signer.class);
        bucketConfigurationXmlFactory = new BucketConfigurationXmlFactory();
        requestPaymentConfigurationXmlFactory = new RequestPaymentConfigurationXmlFactory();
        bucketRegionCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(300, 1.1f, true){
            private static final long serialVersionUID = 23453L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > 300;
            }
        });
    }
}

