/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.services.s3.internal.S3HttpUtils;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

public class ServiceUtils {
    private static final Log log = LogFactory.getLog(ServiceUtils.class);
    private static final int DEAFAULT_BYTE_SIZE = 10240;
    public static final boolean APPEND_MODE = true;
    public static final boolean OVERWRITE_MODE = false;
    @Deprecated
    protected static final DateUtils DATE_UTILS = new DateUtils();

    public static Date parseIso8601Date(String dateString) {
        return DateUtils.parseISO8601Date((String)dateString);
    }

    public static String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date((Date)date);
    }

    public static Date parseRfc822Date(String dateString) {
        return DateUtils.parseRFC822Date((String)dateString);
    }

    public static String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date((Date)date);
    }

    public static boolean isMultipartUploadETag(String eTag) {
        return eTag.contains("-");
    }

    public static byte[] toByteArray(String s) {
        return s.getBytes(StringUtils.UTF8);
    }

    public static String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static URL convertRequestToUrl(Request<?> request) {
        return ServiceUtils.convertRequestToUrl(request, false);
    }

    public static URL convertRequestToUrl(Request<?> request, boolean removeLeadingSlashInResourcePath) {
        String resourcePath = S3HttpUtils.urlEncode(request.getResourcePath(), true);
        if (removeLeadingSlashInResourcePath && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        String urlString = request.getEndpoint() + urlPath;
        boolean firstParam = true;
        for (String param : request.getParameters().keySet()) {
            if (firstParam) {
                urlString = urlString + "?";
                firstParam = false;
            } else {
                urlString = urlString + "&";
            }
            String value = (String)request.getParameters().get(param);
            urlString = urlString + param + "=" + S3HttpUtils.urlEncode(value, false);
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new AmazonClientException("Unable to convert request to well formed URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String join(List<String> strings) {
        String result = "";
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result = result + ", ";
            }
            result = result + s;
            first = false;
        }
        return result;
    }

    public static void downloadObjectToFile(S3Object s3Object, File destinationFile, boolean performIntegrityCheck, boolean appendData) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile, appendData));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            s3Object.getObjectContent().abort();
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                log.debug((Object)"Caught exception. Ignoring.");
            }
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception e) {
                log.debug((Object)"Caught exception. Ignoring.");
            }
        }
        byte[] clientSideHash = null;
        byte[] serverSideHash = null;
        try {
            if (!ServiceUtils.isMultipartUploadETag(s3Object.getObjectMetadata().getETag())) {
                clientSideHash = Md5Utils.computeMD5Hash((InputStream)new FileInputStream(destinationFile));
                serverSideHash = BinaryUtils.fromHex((String)s3Object.getObjectMetadata().getETag());
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to calculate MD5 hash to validate download: " + e.getMessage()), (Throwable)e);
        }
        if (performIntegrityCheck && clientSideHash != null && serverSideHash != null && !Arrays.equals(clientSideHash, serverSideHash)) {
            throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data stored in '" + destinationFile.getAbsolutePath() + "' may be corrupt.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S3Object retryableDownloadS3ObjectToFile(File file, RetryableS3DownloadTask retryableS3DownloadTask, boolean appendData) {
        S3Object s3Object;
        boolean needRetry;
        boolean hasRetried = false;
        do {
            needRetry = false;
            s3Object = retryableS3DownloadTask.getS3ObjectStream();
            if (s3Object == null) {
                return null;
            }
            try {
                ServiceUtils.downloadObjectToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), appendData);
            }
            catch (AmazonClientException ace) {
                if (!ace.isRetryable()) {
                    throw ace;
                }
                if (ace.getCause() instanceof SocketException || ace.getCause() instanceof SSLProtocolException) {
                    throw ace;
                }
                needRetry = true;
                if (hasRetried) {
                    throw ace;
                }
                log.info((Object)("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")"), (Throwable)ace);
                hasRetried = true;
            }
            finally {
                s3Object.getObjectContent().abort();
            }
        } while (needRetry);
        return s3Object;
    }

    public static boolean skipMd5CheckPerResponse(ObjectMetadata metadata) {
        if (metadata == null) {
            return false;
        }
        boolean sseKMS = SSEAlgorithm.KMS.toString().equals(metadata.getSSEAlgorithm());
        return metadata.getSSECustomerAlgorithm() != null || sseKMS;
    }

    public static boolean skipMd5CheckPerRequest(AmazonWebServiceRequest request) {
        if (System.getProperty("com.amazonaws.services.s3.disableGetObjectMD5Validation") != null) {
            return true;
        }
        if (request instanceof GetObjectRequest) {
            GetObjectRequest getObjectRequest = (GetObjectRequest)request;
            if (getObjectRequest.getRange() != null) {
                return true;
            }
            if (getObjectRequest.getSSECustomerKey() != null) {
                return true;
            }
        } else {
            if (request instanceof PutObjectRequest) {
                PutObjectRequest putObjectRequest = (PutObjectRequest)request;
                ObjectMetadata om = putObjectRequest.getMetadata();
                if (om != null && om.getSSEAlgorithm() != null) {
                    return true;
                }
                return putObjectRequest.getSSECustomerKey() != null;
            }
            if (request instanceof UploadPartRequest) {
                UploadPartRequest uploadPartRequest = (UploadPartRequest)request;
                return uploadPartRequest.getSSECustomerKey() != null;
            }
        }
        return false;
    }

    public static interface RetryableS3DownloadTask {
        public S3Object getS3ObjectStream();

        public boolean needIntegrityCheck();
    }
}

