/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;

public enum TransferState {
    WAITING,
    IN_PROGRESS,
    PAUSED,
    RESUMED_WAITING,
    COMPLETED,
    CANCELED,
    FAILED,
    WAITING_FOR_NETWORK,
    PART_COMPLETED,
    PENDING_CANCEL,
    PENDING_PAUSE,
    PENDING_NETWORK_DISCONNECT,
    UNKNOWN;

    private static final Map<String, TransferState> MAP;
    private static final Log LOGGER;

    public static TransferState getState(String stateAsString) {
        if (MAP.containsKey(stateAsString)) {
            return MAP.get(stateAsString);
        }
        LOGGER.error((Object)("Unknown state " + stateAsString + " transfer will be have state set to UNKNOWN."));
        return UNKNOWN;
    }

    protected static boolean isFinalState(TransferState transferState) {
        return COMPLETED.equals((Object)transferState) || FAILED.equals((Object)transferState) || CANCELED.equals((Object)transferState);
    }

    static {
        MAP = new HashMap<String, TransferState>();
        for (TransferState state : TransferState.values()) {
            MAP.put(state.toString(), state);
        }
        LOGGER = LogFactory.getLog(TransferState.class);
    }
}

