/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkConnectionType;
import java.io.Serializable;

public class TransferUtilityOptions
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(TransferUtilityOptions.class);
    private static final long serialVersionUID = 1L;
    private static final int MILLIS_IN_MINUTE = 60000;
    @Deprecated
    private long transferServiceCheckTimeInterval = TransferUtilityOptions.getDefaultCheckTimeInterval();
    private int transferThreadPoolSize;
    private long minimumUploadPartSizeInBytes;
    protected TransferNetworkConnectionType transferNetworkConnectionType;

    public TransferUtilityOptions() {
        this.transferThreadPoolSize = TransferUtilityOptions.getDefaultThreadPoolSize();
        this.transferNetworkConnectionType = TransferUtilityOptions.getDefaultTransferNetworkConnectionType();
        this.minimumUploadPartSizeInBytes = 0x500000L;
    }

    public TransferUtilityOptions(int transferThreadPoolSize, TransferNetworkConnectionType transferNetworkConnectionType) {
        this.transferThreadPoolSize = transferThreadPoolSize;
        this.transferNetworkConnectionType = transferNetworkConnectionType;
        this.minimumUploadPartSizeInBytes = 0x500000L;
    }

    @Deprecated
    public long getTransferServiceCheckTimeInterval() {
        return this.transferServiceCheckTimeInterval;
    }

    @Deprecated
    public void setTransferServiceCheckTimeInterval(long transferServiceCheckTimeInterval) {
    }

    public int getTransferThreadPoolSize() {
        return this.transferThreadPoolSize;
    }

    public void setTransferThreadPoolSize(int transferThreadPoolSize) {
        this.transferThreadPoolSize = transferThreadPoolSize < 0 ? TransferUtilityOptions.getDefaultThreadPoolSize() : transferThreadPoolSize;
    }

    public TransferNetworkConnectionType getTransferNetworkConnectionType() {
        return this.transferNetworkConnectionType;
    }

    static int getDefaultThreadPoolSize() {
        return 2 * (Runtime.getRuntime().availableProcessors() + 1);
    }

    protected long getMinimumUploadPartSizeInBytes() {
        return this.minimumUploadPartSizeInBytes;
    }

    public int getMinimumUploadPartSizeInMB() {
        return (int)(this.minimumUploadPartSizeInBytes / 0x100000L);
    }

    public void setMinimumUploadPartSizeInMB(int minimumUploadPartSizeInMB) {
        long minimumUploadPartSizeInBytes = (long)minimumUploadPartSizeInMB * 0x100000L;
        if (minimumUploadPartSizeInBytes > 0x140000000L) {
            LOGGER.warn((Object)"The provided minimumUploadPartSize is greater than the maximum upload part size limit. Setting upload part size to the maximum allowed value of5MB.");
            this.minimumUploadPartSizeInBytes = 0x140000000L;
        } else if (minimumUploadPartSizeInBytes < 0x500000L) {
            LOGGER.warn((Object)"The provided minimumUploadPartSize is less than the minimum upload part size limit. Setting upload part size to the minimum allowed value of5MB.");
            this.minimumUploadPartSizeInBytes = 0x500000L;
        } else {
            this.minimumUploadPartSizeInBytes = minimumUploadPartSizeInBytes;
        }
    }

    @Deprecated
    static long getDefaultCheckTimeInterval() {
        return 60000L;
    }

    static TransferNetworkConnectionType getDefaultTransferNetworkConnectionType() {
        return TransferNetworkConnectionType.ANY;
    }
}

