/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.database.Cursor;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import java.io.File;

public class TransferObserver {
    private final int id;
    private final TransferDBUtil dbUtil;
    private String bucket;
    private String key;
    private long bytesTotal;
    private long bytesTransferred;
    private TransferState transferState;
    private String filePath;
    private TransferListener transferListener;
    private TransferStatusListener statusListener;

    TransferObserver(int id, TransferDBUtil dbUtil, String bucket, String key, File file) {
        this.id = id;
        this.dbUtil = dbUtil;
        this.bucket = bucket;
        this.key = key;
        this.filePath = file.getAbsolutePath();
        this.bytesTotal = file.length();
        this.transferState = TransferState.WAITING;
    }

    TransferObserver(int id, TransferDBUtil dbUtil, String bucket, String key, File file, TransferListener listener) {
        this(id, dbUtil, bucket, key, file);
        this.setTransferListener(listener);
    }

    TransferObserver(int id, TransferDBUtil dbUtil) {
        this.id = id;
        this.dbUtil = dbUtil;
    }

    public void refresh() {
        try (Cursor c = null;){
            c = this.dbUtil.queryTransferById(this.id);
            if (c.moveToFirst()) {
                this.updateFromDB(c);
            }
        }
    }

    protected void updateFromDB(Cursor c) {
        this.bucket = c.getString(c.getColumnIndexOrThrow("bucket_name"));
        this.key = c.getString(c.getColumnIndexOrThrow("key"));
        this.bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        this.bytesTransferred = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
        this.transferState = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        this.filePath = c.getString(c.getColumnIndexOrThrow("file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferListener(TransferListener listener) {
        TransferObserver transferObserver = this;
        synchronized (transferObserver) {
            this.cleanTransferListener();
            if (this.statusListener == null) {
                this.statusListener = new TransferStatusListener();
                TransferStatusUpdater.registerListener(this.id, this.statusListener);
            }
            if (listener != null) {
                this.transferListener = listener;
                this.transferListener.onStateChanged(this.id, this.transferState);
                TransferStatusUpdater.registerListener(this.id, this.transferListener);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public String getAbsoluteFilePath() {
        return this.filePath;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public TransferState getState() {
        return this.transferState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTransferListener() {
        TransferObserver transferObserver = this;
        synchronized (transferObserver) {
            if (this.transferListener != null) {
                TransferStatusUpdater.unregisterListener(this.id, this.transferListener);
                this.transferListener = null;
            }
            if (this.statusListener != null) {
                TransferStatusUpdater.unregisterListener(this.id, this.statusListener);
                this.statusListener = null;
            }
        }
    }

    public String toString() {
        return "TransferObserver{id=" + this.id + ", bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", bytesTotal=" + this.bytesTotal + ", bytesTransferred=" + this.bytesTransferred + ", transferState=" + (Object)((Object)this.transferState) + ", filePath='" + this.filePath + '\'' + '}';
    }

    protected class TransferStatusListener
    implements TransferListener {
        protected TransferStatusListener() {
        }

        @Override
        public void onStateChanged(int id, TransferState state) {
            TransferObserver.this.transferState = state;
        }

        @Override
        public void onProgressChanged(int id, long bytesCurrent, long bytesTotal) {
            TransferObserver.this.bytesTransferred = bytesCurrent;
            TransferObserver.this.bytesTotal = bytesTotal;
        }

        @Override
        public void onError(int id, Exception ex) {
        }
    }
}

