/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

@Deprecated
public class CipherLiteInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    private static final int BYTE_MASK = 255;
    private CipherLite cipherLite;
    private final boolean multipart;
    private final boolean lastMultiPart;
    private boolean eof = false;
    private final byte[] bufin;
    private byte[] bufout;
    private int currPos = 0;
    private int maxPos = 0;

    public CipherLiteInputStream(InputStream is, CipherLite cipherLite) {
        this(is, cipherLite, 512, false, false);
    }

    public CipherLiteInputStream(InputStream is, CipherLite cipherLite, int buffsize) {
        this(is, cipherLite, buffsize, false, false);
    }

    public CipherLiteInputStream(InputStream is, CipherLite cipherLite, int buffsize, boolean multipart, boolean lastMultiPart) {
        super(is);
        if (lastMultiPart && !multipart) {
            throw new IllegalArgumentException("lastMultiPart can only be true if multipart is true");
        }
        this.multipart = multipart;
        this.lastMultiPart = lastMultiPart;
        this.cipherLite = cipherLite;
        if (buffsize <= 0 || buffsize % 512 != 0) {
            throw new IllegalArgumentException("buffsize (" + buffsize + ") must be a positive multiple of " + 512);
        }
        this.bufin = new byte[buffsize];
    }

    protected CipherLiteInputStream(InputStream is) {
        this(is, CipherLite.NULL, 512, false, false);
    }

    public int read() throws IOException {
        if (this.currPos >= this.maxPos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        return this.bufout[this.currPos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buf, int off, int targetLen) throws IOException {
        if (this.currPos >= this.maxPos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        if (targetLen <= 0) {
            return 0;
        }
        int len = this.maxPos - this.currPos;
        if (targetLen < len) {
            len = targetLen;
        }
        System.arraycopy(this.bufout, this.currPos, buf, off, len);
        this.currPos += len;
        return len;
    }

    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        int available = this.maxPos - this.currPos;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.currPos = (int)((long)this.currPos + n);
        return n;
    }

    public int available() {
        this.abortIfNeeded();
        return this.maxPos - this.currPos;
    }

    public void close() throws IOException {
        this.in.close();
        if (!this.multipart && !S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) {
            try {
                this.cipherLite.doFinal();
            }
            catch (BadPaddingException badPaddingException) {
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                // empty catch block
            }
        }
        this.currPos = 0;
        this.maxPos = 0;
        this.abortIfNeeded();
    }

    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported() && this.cipherLite.markSupported();
    }

    public void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
        this.cipherLite.mark();
    }

    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.cipherLite.reset();
        this.resetInternal();
    }

    final void resetInternal() {
        if (this.markSupported()) {
            this.currPos = 0;
            this.maxPos = 0;
            this.eof = false;
        }
    }

    private int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        this.bufout = null;
        int len = this.in.read(this.bufin);
        if (len == -1) {
            block7: {
                this.eof = true;
                if (!this.multipart || this.lastMultiPart) {
                    try {
                        this.bufout = this.cipherLite.doFinal();
                        if (this.bufout == null) {
                            return -1;
                        }
                        this.currPos = 0;
                        this.maxPos = this.bufout.length;
                        return this.maxPos;
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                    }
                    catch (BadPaddingException e) {
                        if (!S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) break block7;
                        throw new SecurityException(e);
                    }
                }
            }
            return -1;
        }
        this.bufout = this.cipherLite.update(this.bufin, 0, len);
        this.currPos = 0;
        this.maxPos = this.bufout == null ? 0 : this.bufout.length;
        return this.maxPos;
    }

    void renewCipherLite() {
        this.cipherLite = this.cipherLite.recreate();
    }
}

