/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBBase;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.json.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransferDBUtil {
    private static final Log LOGGER = LogFactory.getLog(TransferDBUtil.class);
    private static final String QUERY_PLACE_HOLDER_STRING = ",?";
    private static TransferDBBase transferDBBase;

    public TransferDBUtil(Context context) {
        if (transferDBBase == null) {
            transferDBBase = new TransferDBBase(context);
        }
    }

    public void closeDB() {
        if (transferDBBase != null) {
            transferDBBase.closeDBHelper();
        }
    }

    public Uri insertMultipartUploadRecord(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart) {
        ContentValues values = this.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, partNumber, uploadId, bytesTotal, isLastPart, new ObjectMetadata(), null);
        return transferDBBase.insert(transferDBBase.getContentUri(), values);
    }

    public Uri insertSingleTransferRecord(TransferType type, String bucket, String key, File file, ObjectMetadata metadata) {
        return this.insertSingleTransferRecord(type, bucket, key, file, metadata, null);
    }

    public Uri insertSingleTransferRecord(TransferType type, String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        ContentValues values = this.generateContentValuesForSinglePartTransfer(type, bucket, key, file, metadata, cannedAcl);
        return transferDBBase.insert(transferDBBase.getContentUri(), values);
    }

    public Uri insertSingleTransferRecord(TransferType type, String bucket, String key, File file) {
        return this.insertSingleTransferRecord(type, bucket, key, file, new ObjectMetadata());
    }

    public int bulkInsertTransferRecords(ContentValues[] valuesArray) {
        return transferDBBase.bulkInsert(transferDBBase.getContentUri(), valuesArray);
    }

    public int updateTransferRecord(TransferRecord transfer) {
        ContentValues cv = new ContentValues();
        cv.put("_id", Integer.valueOf(transfer.id));
        cv.put("state", transfer.state.toString());
        cv.put("bytes_total", Long.valueOf(transfer.bytesTotal));
        cv.put("bytes_current", Long.valueOf(transfer.bytesCurrent));
        return transferDBBase.update(this.getRecordUri(transfer.id), cv, null, null);
    }

    public int updateBytesTransferred(int id, long bytes) {
        ContentValues values = new ContentValues();
        values.put("bytes_current", Long.valueOf(bytes));
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateBytesTotalForDownload(int id, long bytes) {
        ContentValues values = new ContentValues();
        values.put("bytes_total", Long.valueOf(bytes));
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateState(int id, TransferState state) {
        ContentValues values = new ContentValues();
        values.put("state", state.toString());
        if (TransferState.FAILED.equals((Object)state)) {
            return transferDBBase.update(this.getRecordUri(id), values, "state not in (?,?,?,?,?) ", new String[]{TransferState.COMPLETED.toString(), TransferState.PENDING_NETWORK_DISCONNECT.toString(), TransferState.PAUSED.toString(), TransferState.CANCELED.toString(), TransferState.WAITING_FOR_NETWORK.toString()});
        }
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateStateAndNotifyUpdate(int id, TransferState state) {
        ContentValues values = new ContentValues();
        values.put("state", state.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "_id=" + id, null);
    }

    public int updateMultipartId(int id, String multipartId) {
        ContentValues values = new ContentValues();
        values.put("multipart_id", multipartId);
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateETag(int id, String etag) {
        ContentValues values = new ContentValues();
        values.put("etag", etag);
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateNetworkDisconnected() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_NETWORK_DISCONNECT.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?,?)", new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()});
    }

    public int updateNetworkConnected() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.RESUMED_WAITING.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?)", new String[]{TransferState.PENDING_NETWORK_DISCONNECT.toString(), TransferState.WAITING_FOR_NETWORK.toString()});
    }

    public int setAllRunningRecordsToPausedBeforeShutdownService() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PAUSED.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?,?,?)", new String[]{TransferState.IN_PROGRESS.toString(), TransferState.PENDING_PAUSE.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()});
    }

    public int pauseAllWithType(TransferType type) {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_PAUSE.toString());
        String selection = null;
        String[] selectionArgs = null;
        if (type == TransferType.ANY) {
            selection = "state in (?,?,?)";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()};
        } else {
            selection = "state in (?,?,?) and type=?";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), type.toString()};
        }
        return transferDBBase.update(transferDBBase.getContentUri(), values, selection, selectionArgs);
    }

    public int cancelAllWithType(TransferType type) {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_CANCEL.toString());
        String selection = null;
        String[] selectionArgs = null;
        if (type == TransferType.ANY) {
            selection = "state in (?,?,?,?,?)";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), TransferState.PAUSED.toString(), TransferState.WAITING_FOR_NETWORK.toString()};
        } else {
            selection = "state in (?,?,?,?,?) and type=?";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), TransferState.PAUSED.toString(), TransferState.WAITING_FOR_NETWORK.toString(), type.toString()};
        }
        return transferDBBase.update(transferDBBase.getContentUri(), values, selection, selectionArgs);
    }

    public Cursor queryAllTransfersWithType(TransferType type) {
        if (type == TransferType.ANY) {
            return transferDBBase.query(transferDBBase.getContentUri(), null, null, null, null);
        }
        return transferDBBase.query(transferDBBase.getContentUri(), null, "type=?", new String[]{type.toString()}, null);
    }

    public Cursor queryTransfersWithTypeAndState(TransferType type, TransferState state) {
        if (type == TransferType.ANY) {
            return transferDBBase.query(this.getStateUri(state), null, null, null, null);
        }
        return transferDBBase.query(this.getStateUri(state), null, "type=?", new String[]{type.toString()}, null);
    }

    public Cursor queryTransfersWithTypeAndStates(TransferType type, TransferState[] states) {
        String[] selectionArgs;
        String selection;
        int index = 0;
        int numStates = states.length;
        String placeholderString = this.createPlaceholders(numStates);
        if (type == TransferType.ANY) {
            selection = "state in (" + placeholderString + ")";
            selectionArgs = new String[numStates];
            for (index = 0; index < numStates; ++index) {
                selectionArgs[index] = states[index].toString();
            }
        } else {
            selection = "state in (" + placeholderString + ") and " + "type" + "=?";
            selectionArgs = new String[numStates + 1];
            for (index = 0; index < numStates; ++index) {
                selectionArgs[index] = states[index].toString();
            }
            selectionArgs[index] = type.toString();
        }
        return transferDBBase.query(transferDBBase.getContentUri(), null, selection, selectionArgs, null);
    }

    public Cursor queryTransferById(int id) {
        return transferDBBase.query(this.getRecordUri(id), null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long queryBytesTransferredByMainUploadId(int mainUploadId) {
        Cursor c = null;
        long bytesTotal = 0L;
        try {
            c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
            while (c.moveToNext()) {
                String state = c.getString(c.getColumnIndexOrThrow("state"));
                if (!TransferState.PART_COMPLETED.equals((Object)TransferState.getState(state))) continue;
                bytesTotal += c.getLong(c.getColumnIndexOrThrow("bytes_total"));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return bytesTotal;
    }

    public int deleteTransferRecords(int id) {
        return transferDBBase.delete(this.getRecordUri(id), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartETag> queryPartETagsOfUpload(int mainUploadId) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        Cursor c = null;
        int partNum = 0;
        String eTag = null;
        try {
            c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
            while (c.moveToNext()) {
                partNum = c.getInt(c.getColumnIndexOrThrow("part_num"));
                eTag = c.getString(c.getColumnIndexOrThrow("etag"));
                partETags.add(new PartETag(partNum, eTag));
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return partETags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UploadPartRequest> getNonCompletedPartRequestsFromDB(int mainUploadId, String multipartId) {
        ArrayList<UploadPartRequest> list = new ArrayList<UploadPartRequest>();
        Cursor c = null;
        try {
            c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
            while (c.moveToNext()) {
                if (TransferState.PART_COMPLETED.equals((Object)TransferState.getState(c.getString(c.getColumnIndexOrThrow("state"))))) continue;
                UploadPartRequest putPartRequest = new UploadPartRequest().withId(c.getInt(c.getColumnIndexOrThrow("_id"))).withMainUploadId(c.getInt(c.getColumnIndexOrThrow("main_upload_id"))).withBucketName(c.getString(c.getColumnIndexOrThrow("bucket_name"))).withKey(c.getString(c.getColumnIndexOrThrow("key"))).withUploadId(multipartId).withFile(new File(c.getString(c.getColumnIndexOrThrow("file")))).withFileOffset(c.getLong(c.getColumnIndexOrThrow("file_offset"))).withPartNumber(c.getInt(c.getColumnIndexOrThrow("part_num"))).withPartSize(c.getLong(c.getColumnIndexOrThrow("bytes_total"))).withLastPart(1 == c.getInt(c.getColumnIndexOrThrow("is_last_part")));
                list.add(putPartRequest);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkWaitingForNetworkPartRequestsFromDB(int mainUploadId) {
        boolean isNetworkInterrupted = false;
        Cursor c = null;
        try {
            c = transferDBBase.query(this.getPartUri(mainUploadId), null, "state=?", new String[]{TransferState.WAITING_FOR_NETWORK.toString()}, null);
            if (c.moveToNext()) {
                isNetworkInterrupted = true;
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return isNetworkInterrupted;
    }

    private String createPlaceholders(int numPlaceHolders) {
        if (numPlaceHolders <= 0) {
            LOGGER.error((Object)"Cannot create a string of 0 or less placeholders.");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(numPlaceHolders * QUERY_PLACE_HOLDER_STRING.length() - 1);
        stringBuilder.append("?");
        for (int index = 1; index < numPlaceHolders; ++index) {
            stringBuilder.append(QUERY_PLACE_HOLDER_STRING);
        }
        return stringBuilder.toString();
    }

    public ContentValues generateContentValuesForMultiPartUpload(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        ContentValues values = new ContentValues();
        values.put("type", TransferType.UPLOAD.toString());
        values.put("state", TransferState.WAITING.toString());
        values.put("bucket_name", bucket);
        values.put("key", key);
        values.put("file", file.getAbsolutePath());
        values.put("bytes_current", Long.valueOf(0L));
        values.put("bytes_total", Long.valueOf(bytesTotal));
        values.put("is_multipart", Integer.valueOf(1));
        values.put("part_num", Integer.valueOf(partNumber));
        values.put("file_offset", Long.valueOf(fileOffset));
        values.put("multipart_id", uploadId);
        values.put("is_last_part", Integer.valueOf(isLastPart));
        values.put("is_encrypted", Integer.valueOf(0));
        values.putAll(this.generateContentValuesForObjectMetadata(metadata));
        if (cannedAcl != null) {
            values.put("canned_acl", cannedAcl.toString());
        }
        return values;
    }

    private ContentValues generateContentValuesForObjectMetadata(ObjectMetadata metadata) {
        ContentValues values = new ContentValues();
        values.put("user_metadata", JsonUtils.mapToString(metadata.getUserMetadata()));
        values.put("header_content_type", metadata.getContentType());
        values.put("header_content_encoding", metadata.getContentEncoding());
        values.put("header_cache_control", metadata.getCacheControl());
        values.put("content_md5", metadata.getContentMD5());
        values.put("header_content_disposition", metadata.getContentDisposition());
        values.put("sse_algorithm", metadata.getSSEAlgorithm());
        values.put("kms_key", metadata.getSSEAwsKmsKeyId());
        values.put("expiration_time_rule_id", metadata.getExpirationTimeRuleId());
        if (metadata.getHttpExpiresDate() != null) {
            values.put("http_expires_date", String.valueOf(metadata.getHttpExpiresDate().getTime()));
        }
        return values;
    }

    private ContentValues generateContentValuesForSinglePartTransfer(TransferType type, String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        ContentValues values = new ContentValues();
        values.put("type", type.toString());
        values.put("state", TransferState.WAITING.toString());
        values.put("bucket_name", bucket);
        values.put("key", key);
        values.put("file", file.getAbsolutePath());
        values.put("bytes_current", Long.valueOf(0L));
        if (type.equals((Object)TransferType.UPLOAD)) {
            values.put("bytes_total", Long.valueOf(file == null ? 0L : file.length()));
        }
        values.put("is_multipart", Integer.valueOf(0));
        values.put("part_num", Integer.valueOf(0));
        values.put("is_encrypted", Integer.valueOf(0));
        values.putAll(this.generateContentValuesForObjectMetadata(metadata));
        if (cannedAcl != null) {
            values.put("canned_acl", cannedAcl.toString());
        }
        return values;
    }

    public Uri getContentUri() {
        return transferDBBase.getContentUri();
    }

    public Uri getRecordUri(int id) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/" + id));
    }

    public Uri getPartUri(int mainUploadId) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/part/" + mainUploadId));
    }

    public Uri getStateUri(TransferState state) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/state/" + state.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransferRecord getTransferById(int id) {
        TransferRecord transfer = null;
        Cursor c = null;
        try {
            c = this.queryTransferById(id);
            if (c.moveToFirst()) {
                transfer = new TransferRecord(0);
                transfer.updateFromDB(c);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return transfer;
    }

    static TransferDBBase getTransferDBBase() {
        return transferDBBase;
    }
}

