/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.model.AmazonS3Exception;

public class CompleteMultipartUploadRetryCondition
implements RetryPolicy.RetryCondition {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final String ERROR_CODE = "InternalError";
    private static final String RETYABLE_ERROR_MESSAGE = "Please try again.";
    private final int maxCompleteMultipartUploadRetries;

    public CompleteMultipartUploadRetryCondition() {
        this(3);
    }

    CompleteMultipartUploadRetryCondition(int maxRetryAttempts) {
        this.maxCompleteMultipartUploadRetries = maxRetryAttempts;
    }

    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception instanceof AmazonS3Exception) {
            return this.test((AmazonS3Exception)((Object)exception)) && retriesAttempted < this.maxCompleteMultipartUploadRetries;
        }
        return false;
    }

    boolean test(AmazonS3Exception exception) {
        if (exception == null || exception.getErrorCode() == null || exception.getErrorMessage() == null) {
            return false;
        }
        return exception.getErrorCode().contains(ERROR_CODE) && exception.getErrorMessage().contains(RETYABLE_ERROR_MESSAGE);
    }
}

