/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.transform.S3KeyFilterStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class FilterStaxUnmarshaller
implements Unmarshaller<Filter, StaxUnmarshallerContext> {
    private static FilterStaxUnmarshaller instance = new FilterStaxUnmarshaller();

    public static FilterStaxUnmarshaller getInstance() {
        return instance;
    }

    private FilterStaxUnmarshaller() {
    }

    public Filter unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        Filter filter = new Filter();
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (!context.testExpression("S3Key", targetDepth)) continue;
                filter.withS3KeyFilter(S3KeyFilterStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            return filter;
        }
        return filter;
    }
}

