/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import java.io.Serializable;
import java.security.Provider;

@Deprecated
public class CryptoConfiguration
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8646831898339939580L;
    private CryptoMode cryptoMode;
    private CryptoStorageMode storageMode = CryptoStorageMode.ObjectMetadata;
    private Provider cryptoProvider = null;
    private boolean ignoreMissingInstructionFile = true;
    private transient Region awskmsRegion;

    public CryptoConfiguration() {
        this(CryptoMode.EncryptionOnly);
    }

    public CryptoConfiguration(CryptoMode cryptoMode) {
        this.cryptoMode = cryptoMode;
    }

    public void setStorageMode(CryptoStorageMode storageMode) {
        this.storageMode = storageMode;
    }

    public CryptoConfiguration withStorageMode(CryptoStorageMode storageMode) {
        this.storageMode = storageMode;
        return this;
    }

    public CryptoStorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setCryptoProvider(Provider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
        this.check(this.cryptoMode);
    }

    public CryptoConfiguration withCryptoProvider(Provider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
        this.check(this.cryptoMode);
        return this;
    }

    public Provider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public CryptoMode getCryptoMode() {
        return this.cryptoMode;
    }

    public void setCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.cryptoMode = cryptoMode;
    }

    public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) {
        this.cryptoMode = cryptoMode;
        return this;
    }

    public boolean isIgnoreMissingInstructionFile() {
        return this.ignoreMissingInstructionFile;
    }

    public void setIgnoreMissingInstructionFile(boolean ignoreMissingInstructionFile) {
        this.ignoreMissingInstructionFile = ignoreMissingInstructionFile;
    }

    public CryptoConfiguration withIgnoreMissingInstructionFile(boolean ignoreMissingInstructionFile) {
        this.ignoreMissingInstructionFile = ignoreMissingInstructionFile;
        return this;
    }

    private void check(CryptoMode cryptoMode) {
        if (cryptoMode == CryptoMode.AuthenticatedEncryption || cryptoMode == CryptoMode.StrictAuthenticatedEncryption) {
            if (this.cryptoProvider == null && !CryptoRuntime.isBouncyCastleAvailable()) {
                CryptoRuntime.enableBouncyCastle();
                if (!CryptoRuntime.isBouncyCastleAvailable()) {
                    throw new UnsupportedOperationException("The Bouncy castle library jar is required on the classpath to enable authenticated encryption");
                }
            }
            if (!CryptoRuntime.isAesGcmAvailable(this.cryptoProvider)) {
                throw new UnsupportedOperationException("More recent version of the Bouncy castle library is required to enable authenticated encryption");
            }
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public CryptoConfiguration readOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.copyTo(new ReadOnly());
    }

    public CryptoConfiguration clone() {
        return this.copyTo(new CryptoConfiguration());
    }

    private CryptoConfiguration copyTo(CryptoConfiguration that) {
        that.cryptoMode = this.cryptoMode;
        that.storageMode = this.storageMode;
        that.cryptoProvider = this.cryptoProvider;
        that.ignoreMissingInstructionFile = this.ignoreMissingInstructionFile;
        that.awskmsRegion = this.awskmsRegion;
        return that;
    }

    @Deprecated
    public Regions getKmsRegion() {
        if (this.awskmsRegion == null) {
            return null;
        }
        return Regions.fromName((String)this.awskmsRegion.getName());
    }

    @Deprecated
    public void setKmsRegion(Regions kmsRegion) {
        if (kmsRegion != null) {
            this.setAwsKmsRegion(Region.getRegion((Regions)kmsRegion));
        } else {
            this.setAwsKmsRegion(null);
        }
    }

    @Deprecated
    public CryptoConfiguration withKmsRegion(Regions kmsRegion) {
        this.setKmsRegion(kmsRegion);
        return this;
    }

    public Region getAwsKmsRegion() {
        return this.awskmsRegion;
    }

    public void setAwsKmsRegion(Region awsKmsRegion) {
        this.awskmsRegion = awsKmsRegion;
    }

    public CryptoConfiguration withAwsKmsRegion(Region awsKmsRegion) {
        this.awskmsRegion = awsKmsRegion;
        return this;
    }

    private static final class ReadOnly
    extends CryptoConfiguration {
        private ReadOnly() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setStorageMode(CryptoStorageMode storageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withStorageMode(CryptoStorageMode storageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoProvider(Provider cryptoProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoProvider(Provider cryptoProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIgnoreMissingInstructionFile(boolean ignoreMissingInstructionFile) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withIgnoreMissingInstructionFile(boolean ignoreMissingInstructionFile) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setKmsRegion(Regions kmsRegion) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withKmsRegion(Regions kmsRegion) {
            throw new UnsupportedOperationException();
        }
    }
}

