/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadPartTask;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.util.Mimetypes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class UploadTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadTask.class);
    private final AmazonS3 s3;
    private final TransferRecord upload;
    private final TransferDBUtil dbUtil;
    private final TransferStatusUpdater updater;
    private final TransferService.NetworkInfoReceiver networkInfo;
    private static final Map<String, CannedAccessControlList> CANNED_ACL_MAP = new HashMap<String, CannedAccessControlList>();

    public UploadTask(TransferRecord uploadInfo, AmazonS3 s3, TransferDBUtil dbUtil, TransferStatusUpdater updater, TransferService.NetworkInfoReceiver networkInfo) {
        this.upload = uploadInfo;
        this.s3 = s3;
        this.dbUtil = dbUtil;
        this.updater = updater;
        this.networkInfo = networkInfo;
    }

    @Override
    public Boolean call() throws Exception {
        if (!this.networkInfo.isNetworkConnected()) {
            this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
            return false;
        }
        this.updater.updateState(this.upload.id, TransferState.IN_PROGRESS);
        if (this.upload.isMultipart == 1 && this.upload.partNumber == 0) {
            return this.uploadMultipartAndWaitForCompletion();
        }
        if (this.upload.isMultipart == 0) {
            return this.uploadSinglePartAndWaitForCompletion();
        }
        return false;
    }

    private Boolean uploadMultipartAndWaitForCompletion() throws ExecutionException {
        long bytesAlreadyTransferrd = 0L;
        if (this.upload.multipartId == null || this.upload.multipartId.isEmpty()) {
            PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
            TransferUtility.appendMultipartTransferServiceUserAgentString(putObjectRequest);
            try {
                this.upload.multipartId = this.initiateMultipartUpload(putObjectRequest);
            }
            catch (AmazonClientException ace) {
                LOGGER.error((Object)("Error initiating multipart upload: " + this.upload.id + " due to " + ace.getMessage()), (Throwable)ace);
                this.updater.throwError(this.upload.id, (Exception)((Object)ace));
                this.updater.updateState(this.upload.id, TransferState.FAILED);
                return false;
            }
            this.dbUtil.updateMultipartId(this.upload.id, this.upload.multipartId);
        } else {
            bytesAlreadyTransferrd = this.dbUtil.queryBytesTransferredByMainUploadId(this.upload.id);
            if (bytesAlreadyTransferrd > 0L) {
                LOGGER.debug((Object)String.format("Resume transfer %d from %d bytes", this.upload.id, bytesAlreadyTransferrd));
            }
        }
        this.updater.updateProgress(this.upload.id, bytesAlreadyTransferrd, this.upload.bytesTotal);
        List<UploadPartRequest> requestList = this.dbUtil.getNonCompletedPartRequestsFromDB(this.upload.id, this.upload.multipartId);
        LOGGER.debug((Object)("multipart upload " + this.upload.id + " in " + requestList.size() + " parts."));
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (UploadPartRequest uploadPartRequest : requestList) {
            TransferUtility.appendMultipartTransferServiceUserAgentString(uploadPartRequest);
            uploadPartRequest.setGeneralProgressListener(this.updater.newProgressListener(this.upload.id));
            futures.add(TransferThreadPool.submitTask(new UploadPartTask(uploadPartRequest, this.s3, this.dbUtil)));
        }
        try {
            boolean isSuccess = true;
            for (Future future : futures) {
                boolean b = (Boolean)future.get();
                isSuccess &= b;
            }
            if (!isSuccess) {
                return false;
            }
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            LOGGER.debug((Object)("Transfer " + this.upload.id + " is interrupted by user"));
            return false;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof Exception) {
                Exception exception = (Exception)ee.getCause();
                if (RetryUtils.isInterrupted((Throwable)exception)) {
                    LOGGER.debug((Object)("Transfer " + this.upload.id + " is interrupted by user"));
                    return false;
                }
                if (exception.getCause() != null && exception.getCause() instanceof IOException && !this.networkInfo.isNetworkConnected()) {
                    LOGGER.debug((Object)("Transfer " + this.upload.id + " waits for network"));
                    this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
                }
                this.updater.throwError(this.upload.id, exception);
            }
            this.updater.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
        try {
            this.completeMultiPartUpload(this.upload.id, this.upload.bucketName, this.upload.key, this.upload.multipartId);
            this.updater.updateProgress(this.upload.id, this.upload.bytesTotal, this.upload.bytesTotal);
            this.updater.updateState(this.upload.id, TransferState.COMPLETED);
            return true;
        }
        catch (AmazonClientException ace) {
            LOGGER.error((Object)("Failed to complete multipart: " + this.upload.id + " due to " + ace.getMessage()), (Throwable)ace);
            this.updater.throwError(this.upload.id, (Exception)((Object)ace));
            this.updater.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
    }

    private Boolean uploadSinglePartAndWaitForCompletion() {
        PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
        long length = putObjectRequest.getFile().length();
        TransferUtility.appendTransferServiceUserAgentString(putObjectRequest);
        this.updater.updateProgress(this.upload.id, 0L, length);
        putObjectRequest.setGeneralProgressListener(this.updater.newProgressListener(this.upload.id));
        try {
            this.s3.putObject(putObjectRequest);
            this.updater.updateProgress(this.upload.id, length, length);
            this.updater.updateState(this.upload.id, TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.debug((Object)("Transfer " + this.upload.id + " is interrupted by user"));
                return false;
            }
            if (e.getCause() != null && e.getCause() instanceof IOException && !this.networkInfo.isNetworkConnected()) {
                LOGGER.debug((Object)("Transfer " + this.upload.id + " waits for network"));
                this.updater.updateState(this.upload.id, TransferState.WAITING_FOR_NETWORK);
            }
            LOGGER.debug((Object)("Failed to upload: " + this.upload.id + " due to " + e.getMessage()), (Throwable)e);
            this.updater.throwError(this.upload.id, e);
            this.updater.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
    }

    private void completeMultiPartUpload(int mainUploadId, String bucket, String key, String multipartId) {
        List<PartETag> partETags = this.dbUtil.queryPartETagsOfUpload(mainUploadId);
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucket, key, multipartId, partETags);
        TransferUtility.appendMultipartTransferServiceUserAgentString(completeRequest);
        this.s3.completeMultipartUpload(completeRequest);
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata()).withSSEAwsKeyManagementParams(putObjectRequest.getSSEAwsKeyManagementParams());
        TransferUtility.appendMultipartTransferServiceUserAgentString(initiateMultipartUploadRequest);
        String uploadId = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        return uploadId;
    }

    private PutObjectRequest createPutObjectRequest(TransferRecord upload) {
        File file = new File(upload.file);
        PutObjectRequest putObjectRequest = new PutObjectRequest(upload.bucketName, upload.key, file);
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(file.length());
        if (upload.headerCacheControl != null) {
            om.setCacheControl(upload.headerCacheControl);
        }
        if (upload.headerContentDisposition != null) {
            om.setContentDisposition(upload.headerContentDisposition);
        }
        if (upload.headerContentEncoding != null) {
            om.setContentEncoding(upload.headerContentEncoding);
        }
        if (upload.headerContentType != null) {
            om.setContentType(upload.headerContentType);
        } else {
            om.setContentType(Mimetypes.getInstance().getMimetype(file));
        }
        if (upload.expirationTimeRuleId != null) {
            om.setExpirationTimeRuleId(upload.expirationTimeRuleId);
        }
        if (upload.httpExpires != null) {
            om.setHttpExpiresDate(new Date(Long.valueOf(upload.httpExpires)));
        }
        if (upload.sseAlgorithm != null) {
            om.setSSEAlgorithm(upload.sseAlgorithm);
        }
        if (upload.userMetadata != null) {
            om.setUserMetadata(upload.userMetadata);
        }
        if (upload.md5 != null) {
            om.setContentMD5(upload.md5);
        }
        if (upload.sseKMSKey != null) {
            putObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(upload.sseKMSKey));
        }
        putObjectRequest.setMetadata(om);
        putObjectRequest.setCannedAcl(UploadTask.getCannedAclFromString(upload.cannedAcl));
        return putObjectRequest;
    }

    private static CannedAccessControlList getCannedAclFromString(String cannedAcl) {
        return cannedAcl == null ? null : CANNED_ACL_MAP.get(cannedAcl);
    }

    static {
        for (CannedAccessControlList cannedAcl : CannedAccessControlList.values()) {
            CANNED_ACL_MAP.put(cannedAcl.toString(), cannedAcl);
        }
    }
}

