/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.Download;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableDownload;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transfermanager.exception.PauseException;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.AbstractTransfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.S3ProgressPublisher;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferManagerUtils;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferStateChangeListener;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    S3Object s3Object;
    private final PersistableDownload persistableDownload;

    public DownloadImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener, GetObjectRequest getObjectRequest, File file) {
        super(description, transferProgress, progressListenerChain, listener);
        this.s3Object = s3Object;
        this.persistableDownload = this.captureDownloadState(getObjectRequest, file);
        S3ProgressPublisher.publishTransferPersistable((ProgressListener)progressListenerChain, this.persistableDownload);
    }

    @Override
    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    @Override
    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    @Override
    public String getKey() {
        return this.s3Object.getKey();
    }

    @Override
    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        DownloadImpl downloadImpl = this;
        synchronized (downloadImpl) {
            this.state = Transfer.TransferState.Canceled;
        }
    }

    public synchronized void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    @Override
    public void setState(Transfer.TransferState state) {
        super.setState(state);
        if (state == Transfer.TransferState.Completed) {
            this.fireProgressEvent(4);
        }
    }

    private PersistableDownload captureDownloadState(GetObjectRequest getObjectRequest, File file) {
        if (getObjectRequest.getSSECustomerKey() == null) {
            return new PersistableDownload(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest.getVersionId(), getObjectRequest.getRange(), getObjectRequest.getResponseHeaders(), getObjectRequest.isRequesterPays(), file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public PersistableDownload pause() throws PauseException {
        boolean forceCancel = true;
        Transfer.TransferState currentState = this.getState();
        this.monitor.getFuture().cancel(true);
        if (this.persistableDownload == null) {
            throw new PauseException(TransferManagerUtils.determinePauseStatus(currentState, forceCancel));
        }
        return this.persistableDownload;
    }
}

