/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TransferUtility {
    private static final String TAG = "TransferUtility";
    static final int MINIMUM_UPLOAD_PART_SIZE = 0x500000;
    private final AmazonS3 s3;
    private final Context appContext;
    private final TransferDBUtil dbUtil;

    public TransferUtility(AmazonS3 s3, Context context) {
        this.s3 = s3;
        this.appContext = context.getApplicationContext();
        this.dbUtil = new TransferDBUtil(this.appContext);
    }

    public TransferObserver download(String bucket, String key, File file) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.DOWNLOAD, bucket, key, file);
        int recordId = Integer.parseInt(uri.getLastPathSegment());
        if (file.isFile()) {
            Log.w((String)TAG, (String)("Overwrite existing file: " + file));
            file.delete();
        }
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, this.dbUtil, bucket, key, file);
    }

    public TransferObserver upload(String bucket, String key, File file) {
        return this.upload(bucket, key, file, new ObjectMetadata());
    }

    public TransferObserver upload(String bucket, String key, File file, CannedAccessControlList cannedAcl) {
        return this.upload(bucket, key, file, new ObjectMetadata(), cannedAcl);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata) {
        return this.upload(bucket, key, file, metadata, null);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        int recordId = 0;
        if (this.shouldUploadInMultipart(file)) {
            recordId = this.createMultipartUploadRecords(bucket, key, file, metadata, cannedAcl);
        } else {
            Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.UPLOAD, bucket, key, file, metadata, cannedAcl);
            recordId = Integer.parseInt(uri.getLastPathSegment());
        }
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, this.dbUtil, bucket, key, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferObserver getTransferById(int id) {
        Cursor c = this.dbUtil.queryTransferById(id);
        try {
            if (c.moveToFirst()) {
                TransferObserver transferObserver = new TransferObserver(id, this.dbUtil, c);
                return transferObserver;
            }
            TransferObserver transferObserver = null;
            return transferObserver;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransferObserver> getTransfersWithType(TransferType type) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = this.dbUtil.queryAllTransfersWithType(type);
        try {
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                transferObservers.add(new TransferObserver(id, this.dbUtil, c));
            }
        }
        finally {
            c.close();
        }
        return transferObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransferObserver> getTransfersWithTypeAndState(TransferType type, TransferState state) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = this.dbUtil.queryTransfersWithTypeAndState(type, state);
        try {
            while (c.moveToNext()) {
                int partNum = c.getInt(c.getColumnIndexOrThrow("part_num"));
                if (partNum != 0) continue;
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                transferObservers.add(new TransferObserver(id, this.dbUtil, c));
            }
        }
        finally {
            c.close();
        }
        return transferObservers;
    }

    private int createMultipartUploadRecords(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        long remainingLenth = file.length();
        double partSize = (double)remainingLenth / 10000.0;
        partSize = Math.ceil(partSize);
        long optimalPartSize = (long)Math.max(partSize, 5242880.0);
        long fileOffset = 0L;
        int partNumber = 1;
        int partCount = (int)Math.ceil((double)remainingLenth / (double)optimalPartSize);
        ContentValues[] valuesArray = new ContentValues[partCount + 1];
        valuesArray[0] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, 0, "", file.length(), 0, metadata, cannedAcl);
        for (int i = 1; i < partCount + 1; ++i) {
            long bytesForPart = Math.min(optimalPartSize, remainingLenth);
            valuesArray[i] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, partNumber, "", bytesForPart, remainingLenth - optimalPartSize <= 0L ? 1 : 0, metadata, cannedAcl);
            fileOffset += optimalPartSize;
            remainingLenth -= optimalPartSize;
            ++partNumber;
        }
        return this.dbUtil.bulkInsertTransferRecords(valuesArray);
    }

    public boolean pause(int id) {
        this.sendIntent("pause_transfer", id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAllWithType(TransferType type) {
        Cursor c = this.dbUtil.queryAllTransfersWithType(type);
        try {
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                this.pause(id);
            }
        }
        finally {
            c.close();
        }
    }

    public TransferObserver resume(int id) {
        this.sendIntent("resume_transfer", id);
        return this.getTransferById(id);
    }

    public boolean cancel(int id) {
        this.sendIntent("cancel_transfer", id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllWithType(TransferType type) {
        Cursor c = this.dbUtil.queryAllTransfersWithType(type);
        try {
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                this.cancel(id);
            }
        }
        finally {
            c.close();
        }
    }

    public boolean deleteTransferRecord(int id) {
        this.cancel(id);
        return this.dbUtil.deleteTransferRecords(id) > 0;
    }

    private void sendIntent(String action, int id) {
        String s3Key = UUID.randomUUID().toString();
        S3ClientReference.put(s3Key, this.s3);
        Intent intent = new Intent(this.appContext, TransferService.class);
        intent.setAction(action);
        intent.putExtra("id", id);
        intent.putExtra("s3_reference_key", s3Key);
        this.appContext.startService(intent);
    }

    private boolean shouldUploadInMultipart(File file) {
        return file != null && file.length() > 0x500000L;
    }

    static <X extends AmazonWebServiceRequest> X appendTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService/" + VersionInfoUtils.getVersion());
        return request;
    }

    static <X extends AmazonWebServiceRequest> X appendMultipartTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService_multipart/" + VersionInfoUtils.getVersion());
        return request;
    }
}

