/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.concurrent.Callable;

class UploadPartTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadPartTask.class);
    private final UploadTask.UploadPartTaskMetadata uploadPartTaskMetadata;
    private final UploadTask.UploadTaskProgressListener uploadTaskProgressListener;
    private final UploadPartRequest uploadPartRequest;
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;

    public UploadPartTask(UploadTask.UploadPartTaskMetadata uploadPartTaskMetadata, UploadTask.UploadTaskProgressListener uploadTaskProgressListener, UploadPartRequest uploadPartRequest, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.uploadPartTaskMetadata = uploadPartTaskMetadata;
        this.uploadTaskProgressListener = uploadTaskProgressListener;
        this.uploadPartRequest = uploadPartRequest;
        this.s3 = s3;
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            this.uploadPartTaskMetadata.state = TransferState.IN_PROGRESS;
            this.uploadPartRequest.setGeneralProgressListener(new UploadPartTaskProgressListener(this.uploadTaskProgressListener));
            UploadPartResult putPartResult = this.s3.uploadPart(this.uploadPartRequest);
            this.uploadPartTaskMetadata.state = TransferState.PART_COMPLETED;
            this.dbUtil.updateState(this.uploadPartRequest.getId(), TransferState.PART_COMPLETED);
            this.dbUtil.updateETag(this.uploadPartRequest.getId(), putPartResult.getETag());
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Upload part interrupted: " + e));
            ProgressEvent resetEvent = new ProgressEvent(0L);
            resetEvent.setEventCode(32);
            this.uploadTaskProgressListener.progressChanged(new ProgressEvent(0L));
            try {
                if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                    LOGGER.info((Object)("Thread: [" + Thread.currentThread().getId() + "]: Network wasn't available."));
                    this.uploadPartTaskMetadata.state = TransferState.WAITING_FOR_NETWORK;
                    this.dbUtil.updateState(this.uploadPartRequest.getId(), TransferState.WAITING_FOR_NETWORK);
                    LOGGER.info((Object)"Network Connection Interrupted: Moving the TransferState to WAITING_FOR_NETWORK");
                    return false;
                }
            }
            catch (TransferUtilityException transferUtilityException) {
                LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
            }
            this.uploadPartTaskMetadata.state = TransferState.FAILED;
            this.dbUtil.updateState(this.uploadPartRequest.getId(), TransferState.FAILED);
            LOGGER.error((Object)"Encountered error uploading part ", (Throwable)e);
            throw e;
        }
    }

    private class UploadPartTaskProgressListener
    implements ProgressListener {
        private UploadTask.UploadTaskProgressListener uploadTaskProgressListener;
        private long bytesTransferredSoFar;

        public UploadPartTaskProgressListener(UploadTask.UploadTaskProgressListener progressListener) {
            this.uploadTaskProgressListener = progressListener;
        }

        public void progressChanged(ProgressEvent progressEvent) {
            if (32 == progressEvent.getEventCode()) {
                LOGGER.info((Object)"Reset Event triggered. Resetting the bytesCurrent to 0.");
                this.bytesTransferredSoFar = 0L;
            } else {
                this.bytesTransferredSoFar += progressEvent.getBytesTransferred();
            }
            this.uploadTaskProgressListener.onProgressChanged(UploadPartTask.this.uploadPartRequest.getPartNumber(), this.bytesTransferredSoFar);
        }
    }
}

