/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgressUpdatingListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadPartTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class UploadTask
implements Callable<Boolean> {
    private static final String TAG = "UploadTask";
    private final AmazonS3 s3;
    private final TransferRecord upload;
    private final TransferProgress transferProgress;
    private final TransferDBUtil dbUtil;

    public UploadTask(TransferRecord uploadInfo, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.upload = uploadInfo;
        this.s3 = s3;
        this.dbUtil = dbUtil;
        this.transferProgress = new TransferProgress();
    }

    @Override
    public Boolean call() throws Exception {
        this.dbUtil.updateState(this.upload.id, TransferState.IN_PROGRESS);
        if (this.upload.isMultipart == 1 && this.upload.partNumber == 0) {
            return this.uploadMultipartAndWaitForCompletion();
        }
        if (this.upload.isMultipart == 0) {
            return this.uploadSinglePartAndWaitForCompletion();
        }
        return false;
    }

    private Boolean uploadMultipartAndWaitForCompletion() throws ExecutionException {
        this.transferProgress.setTotalBytesToTransfer(this.upload.bytesTotal);
        if (this.upload.multipartId == null || this.upload.multipartId.equals("")) {
            PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
            TransferUtility.appendMultipartTransferServiceUserAgentString(putObjectRequest);
            try {
                this.upload.multipartId = this.initiateMultipartUpload(putObjectRequest);
            }
            catch (AmazonClientException ase) {
                Log.e((String)TAG, (String)"Error initiating multipart upload", (Throwable)ase);
                this.dbUtil.updateState(this.upload.id, TransferState.FAILED);
                return false;
            }
            this.dbUtil.updateMultipartId(this.upload.id, this.upload.multipartId);
        } else {
            long bytesAlreadyTransferrd = this.dbUtil.queryBytesTransferredByMainUploadId(this.upload.id);
            this.dbUtil.updateBytesTransferred(this.upload.id, bytesAlreadyTransferrd, true);
            this.transferProgress.updateProgress(bytesAlreadyTransferrd);
        }
        List<UploadPartRequest> requestList = this.dbUtil.getNonCompletedPartRequestsFromDB(this.upload.id, this.upload.multipartId);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (UploadPartRequest uploadPartRequest : requestList) {
            TransferUtility.appendMultipartTransferServiceUserAgentString(uploadPartRequest);
            futures.add(TransferThreadPool.submitTask(new UploadPartTask(uploadPartRequest, this.transferProgress, this.s3, this.dbUtil)));
        }
        boolean isSuccess = true;
        try {
            for (Future future : futures) {
                boolean bl = (Boolean)future.get();
                isSuccess = isSuccess && bl;
            }
        }
        catch (InterruptedException interruptedException) {
            isSuccess = false;
            for (Future future : futures) {
                future.cancel(true);
            }
            return false;
        }
        if (isSuccess) {
            CompleteMultipartUploadResult completeMultipartUploadResult = this.completeMultiPartUpload(this.upload.id, this.upload.bucketName, this.upload.key, this.upload.multipartId);
            if (completeMultipartUploadResult != null) {
                this.dbUtil.updateBytesTransferred(this.upload.id, this.upload.bytesTotal, true);
                this.dbUtil.updateState(this.upload.id, TransferState.COMPLETED);
            } else {
                this.dbUtil.updateState(this.upload.id, TransferState.FAILED);
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    private Boolean uploadSinglePartAndWaitForCompletion() {
        this.dbUtil.updateBytesTransferred(this.upload.id, 0L, true);
        PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
        TransferUtility.appendTransferServiceUserAgentString(putObjectRequest);
        this.transferProgress.setTotalBytesToTransfer(putObjectRequest.getFile().length());
        putObjectRequest.setGeneralProgressListener(new TransferProgressUpdatingListener(this.transferProgress){

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                super.progressChanged(progressEvent);
                if (((UploadTask)UploadTask.this).upload.bytesCurrent != UploadTask.this.transferProgress.getBytesTransferred()) {
                    UploadTask.this.dbUtil.updateBytesTransferred(((UploadTask)UploadTask.this).upload.id, UploadTask.this.transferProgress.getBytesTransferred(), false);
                }
            }
        });
        try {
            this.s3.putObject(putObjectRequest);
            this.dbUtil.updateBytesTransferred(this.upload.id, this.upload.bytesTotal, true);
            this.dbUtil.updateState(this.upload.id, TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            Log.e((String)UploadTask.class.getSimpleName(), (String)e.getMessage());
            this.dbUtil.updateState(this.upload.id, TransferState.FAILED);
            return false;
        }
    }

    private CompleteMultipartUploadResult completeMultiPartUpload(int mainUploadId, String bucket, String key, String multipartId) {
        List<PartETag> partETags = this.dbUtil.queryPartETagsOfUpload(mainUploadId);
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucket, key, multipartId, partETags);
        TransferUtility.appendMultipartTransferServiceUserAgentString(completeRequest);
        try {
            CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(completeRequest);
            return completeMultipartUploadResult;
        }
        catch (Exception e) {
            Log.e((String)UploadTask.class.getSimpleName(), (String)e.getMessage());
            return null;
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) throws AmazonClientException {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        TransferUtility.appendMultipartTransferServiceUserAgentString(initiateMultipartUploadRequest);
        String uploadId = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        return uploadId;
    }

    private PutObjectRequest createPutObjectRequest(TransferRecord upload) {
        File file = new File(upload.file);
        PutObjectRequest putObjectRequest = new PutObjectRequest(upload.bucketName, upload.key, new File(upload.file));
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(file.length());
        if (upload.headerCacheControl != null) {
            om.setCacheControl(upload.headerCacheControl);
        }
        if (upload.headerContentDisposition != null) {
            om.setContentDisposition(upload.headerContentDisposition);
        }
        if (upload.headerContentEncoding != null) {
            om.setContentEncoding(upload.headerContentEncoding);
        }
        if (upload.headerContentType != null) {
            om.setContentType(upload.headerContentType);
        } else {
            om.setContentType(Mimetypes.getInstance().getMimetype(file));
        }
        if (upload.expirationTimeRuleId != null) {
            om.setExpirationTimeRuleId(upload.expirationTimeRuleId);
        }
        if (upload.httpExpires != null) {
            om.setHttpExpiresDate(new Date(Long.valueOf(upload.httpExpires)));
        }
        if (upload.sseAlgorithm != null) {
            om.setSSEAlgorithm(upload.sseAlgorithm);
        }
        if (upload.userMetadata != null) {
            om.setUserMetadata(upload.userMetadata);
        }
        if (upload.md5 != null) {
            om.setContentMD5(upload.md5);
        }
        putObjectRequest.setMetadata(om);
        return putObjectRequest;
    }
}

