/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgressUpdatingListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.util.concurrent.Callable;

class DownloadTask
implements Callable<Boolean> {
    private final AmazonS3 s3;
    private final TransferRecord download;
    private final TransferProgress transferProgress;
    TransferDBUtil dbUtil;

    public DownloadTask(TransferRecord DownloadInfo, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.download = DownloadInfo;
        this.s3 = s3;
        this.transferProgress = new TransferProgress();
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() {
        return this.downloadAndWaitForCompletion();
    }

    private Boolean downloadAndWaitForCompletion() {
        long totalBytesOfFile;
        this.dbUtil.updateState(this.download.id, TransferState.IN_PROGRESS);
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.download.bucketName, this.download.key);
        File file = new File(this.download.file);
        TransferUtility.appendTransferServiceUserAgentString(getObjectRequest);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey());
        if (getObjectRequest.getSSECustomerKey() != null) {
            getObjectMetadataRequest.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
        }
        ObjectMetadata objectMetadata = null;
        try {
            TransferUtility.appendTransferServiceUserAgentString(getObjectMetadataRequest);
            objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
        }
        catch (AmazonClientException ase) {
            this.writeFailureInfo();
            return false;
        }
        long startingByte = 0L;
        long lastByte = objectMetadata.getContentLength() - 1L;
        long totalBytesToDownload = totalBytesOfFile = lastByte - startingByte + 1L;
        this.transferProgress.setTotalBytesToTransfer(totalBytesOfFile);
        this.dbUtil.updateBytesTotalForDownload(this.download.id, totalBytesOfFile);
        if (this.download.bytesCurrent > 0L && file.exists()) {
            long numberOfBytesRead = file.length();
            if (numberOfBytesRead != this.download.bytesCurrent) {
                this.dbUtil.updateBytesTransferred(this.download.id, numberOfBytesRead, true);
            }
            getObjectRequest.setRange(startingByte += numberOfBytesRead, lastByte);
            this.transferProgress.updateProgress(Math.min(numberOfBytesRead, totalBytesOfFile));
            totalBytesToDownload = lastByte - startingByte + 1L;
        }
        if (totalBytesToDownload < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation.");
        }
        getObjectRequest.setGeneralProgressListener(new TransferProgressUpdatingListener(this.transferProgress){

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                super.progressChanged(progressEvent);
                if (((DownloadTask)DownloadTask.this).download.bytesCurrent != DownloadTask.this.transferProgress.getBytesTransferred()) {
                    DownloadTask.this.dbUtil.updateBytesTransferred(((DownloadTask)DownloadTask.this).download.id, DownloadTask.this.transferProgress.getBytesTransferred(), false);
                }
            }
        });
        try {
            ObjectMetadata metadata = this.s3.getObject(getObjectRequest, file);
            if (metadata == null) {
                this.writeFailureInfo();
                return false;
            }
            this.writeSuccessInfo(totalBytesOfFile);
            return true;
        }
        catch (Exception e) {
            this.writeFailureInfo();
            return false;
        }
    }

    private void writeSuccessInfo(long totalBytesOfFile) {
        this.dbUtil.updateBytesTransferred(this.download.id, totalBytesOfFile, true);
        this.dbUtil.updateState(this.download.id, TransferState.COMPLETED);
    }

    private void writeFailureInfo() {
        this.dbUtil.updateState(this.download.id, TransferState.FAILED);
    }
}

