/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientWeakReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TransferUtility {
    static final String KEY_FOR_S3_WEAK_REFERENCE = "keyForS3WeakReference";
    private final AmazonS3 s3;
    private final Context appContext;
    private final String s3WeakReferenceMapKey;
    private final TransferDBUtil dbUtil;
    static final int MINIMUM_UPLOAD_PART_SIZE = 0x500000;

    public TransferUtility(AmazonS3 s3, Context context) {
        this.s3 = s3;
        this.s3WeakReferenceMapKey = UUID.randomUUID().toString();
        S3ClientWeakReference.put(this.s3WeakReferenceMapKey, s3);
        this.appContext = context.getApplicationContext();
        this.dbUtil = new TransferDBUtil(this.appContext);
    }

    public TransferObserver download(String bucket, String key, File file) {
        Intent intent = new Intent(this.appContext, TransferService.class);
        intent.putExtra(KEY_FOR_S3_WEAK_REFERENCE, this.s3WeakReferenceMapKey);
        this.appContext.startService(intent);
        boolean isUsingEncryption = this.s3 instanceof AmazonS3EncryptionClient;
        Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.DOWNLOAD, bucket, key, file, isUsingEncryption ? 1 : 0);
        int recordId = Integer.parseInt(uri.getLastPathSegment());
        return new TransferObserver(recordId, this.appContext, 0L);
    }

    public TransferObserver upload(String bucket, String key, File file) {
        Intent intent = new Intent(this.appContext, TransferService.class);
        intent.putExtra(KEY_FOR_S3_WEAK_REFERENCE, this.s3WeakReferenceMapKey);
        this.appContext.startService(intent);
        int recordId = 0;
        boolean isUsingEncryption = false;
        if (this.shouldUploadInMultipart(file)) {
            recordId = this.createMultipartUploadRecords(bucket, key, file, isUsingEncryption);
        } else {
            Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.UPLOAD, bucket, key, file, isUsingEncryption ? 1 : 0);
            recordId = Integer.parseInt(uri.getLastPathSegment());
        }
        return new TransferObserver(recordId, this.appContext, file.length());
    }

    public TransferObserver getTransferById(int id) {
        Cursor c = this.dbUtil.queryTransferById(id);
        if (c == null) {
            return null;
        }
        c.moveToFirst();
        long totalBytesOfFile = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        c.close();
        return new TransferObserver(id, this.appContext, totalBytesOfFile);
    }

    public List<TransferObserver> getTransfersWithType(TransferType type) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = this.dbUtil.queryAllTransfersWithType(type);
        if (c == null) {
            return transferObservers;
        }
        while (c.moveToNext()) {
            transferObservers.add(new TransferObserver((int)c.getLong(c.getColumnIndexOrThrow("_id")), this.appContext, c.getLong(c.getColumnIndexOrThrow("bytes_total"))));
        }
        c.close();
        return transferObservers;
    }

    public List<TransferObserver> getTransfersWithTypeAndState(TransferType type, TransferState state) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = this.dbUtil.queryTransfersWithTypeAndState(type, state);
        if (c == null) {
            return transferObservers;
        }
        while (c.moveToNext()) {
            transferObservers.add(new TransferObserver((int)c.getLong(c.getColumnIndexOrThrow("_id")), this.appContext, c.getLong(c.getColumnIndexOrThrow("bytes_total"))));
        }
        c.close();
        return transferObservers;
    }

    private int createMultipartUploadRecords(String bucket, String key, File file, boolean isUsingEncryption) {
        long remainingLenth = file.length();
        double partSize = (double)remainingLenth / 10000.0;
        partSize = Math.ceil(partSize);
        long optimalPartSize = (long)Math.max(partSize, 5242880.0);
        if (isUsingEncryption && optimalPartSize % 32L > 0L) {
            optimalPartSize = optimalPartSize - optimalPartSize % 32L + 32L;
        }
        long fileOffset = 0L;
        int partNumber = 1;
        int partCount = (int)Math.ceil((double)remainingLenth / (double)optimalPartSize);
        ContentValues[] valuesArray = new ContentValues[partCount + 1];
        valuesArray[0] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, 0, "", file.length(), 0, isUsingEncryption ? 1 : 0);
        for (int i = 1; i < partCount + 1; ++i) {
            long bytesForPart = Math.min(optimalPartSize, remainingLenth);
            valuesArray[i] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, partNumber, "", bytesForPart, remainingLenth - optimalPartSize <= 0L ? 1 : 0, isUsingEncryption ? 1 : 0);
            fileOffset += optimalPartSize;
            remainingLenth -= optimalPartSize;
            ++partNumber;
        }
        return this.dbUtil.bulkInsertTransferRecords(valuesArray);
    }

    public boolean pause(int id) {
        Cursor c = this.dbUtil.queryTransferById(id);
        if (c == null) {
            return false;
        }
        c.moveToFirst();
        TransferState state = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        c.close();
        if (TransferState.IN_PROGRESS.equals((Object)state) || TransferState.RESUMED_WAITING.equals((Object)state) || TransferState.WAITING.equals((Object)state)) {
            return this.dbUtil.updateStateAndNotifyUpdate(id, TransferState.PENDING_PAUSE) > 0;
        }
        return false;
    }

    public void pauseAllWithType(TransferType type) {
        this.dbUtil.pauseAllWithType(type);
    }

    public TransferObserver resume(int id) {
        Intent intent = new Intent(this.appContext, TransferService.class);
        intent.putExtra(KEY_FOR_S3_WEAK_REFERENCE, this.s3WeakReferenceMapKey);
        this.appContext.startService(intent);
        Cursor c = this.dbUtil.queryTransferById(id);
        if (c == null) {
            return null;
        }
        c.moveToFirst();
        TransferState state = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        c.close();
        if (TransferState.PAUSED.equals((Object)state) && this.dbUtil.updateStateAndNotifyUpdate(id, TransferState.RESUMED_WAITING) > 0) {
            return this.getTransferById(id);
        }
        return null;
    }

    public boolean cancel(int id) {
        Cursor c = this.dbUtil.queryTransferById(id);
        if (c == null) {
            return false;
        }
        c.moveToFirst();
        TransferState state = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        c.close();
        if (TransferState.IN_PROGRESS.equals((Object)state) || TransferState.RESUMED_WAITING.equals((Object)state) || TransferState.WAITING.equals((Object)state) || TransferState.PAUSED.equals((Object)state) || TransferState.WAITING_FOR_NETWORK.equals((Object)state)) {
            return this.dbUtil.updateStateAndNotifyUpdate(id, TransferState.PENDING_CANCEL) > 0;
        }
        return false;
    }

    public void cancelAllWithType(TransferType type) {
        this.dbUtil.cancelAllWithType(type);
    }

    public boolean deleteTransferRecord(int id) {
        return this.dbUtil.deleteTransferRecords(id) > 0;
    }

    private boolean shouldUploadInMultipart(File file) {
        return file != null && file.length() > 0x500000L;
    }

    static <X extends AmazonWebServiceRequest> X appendTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService/" + VersionInfoUtils.getVersion());
        return request;
    }

    static <X extends AmazonWebServiceRequest> X appendMultipartTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService_multipart/" + VersionInfoUtils.getVersion());
        return request;
    }
}

