/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RestUtils {
    private static final List<String> SIGNED_PARAMETERS = Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires");

    public static <T> String makeS3CanonicalString(String method, String resource, Request<T> request, String expires) {
        String value;
        String key;
        StringBuilder buf = new StringBuilder();
        buf.append(method + "\n");
        Map headersMap = request.getHeaders();
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry entry : headersMap.entrySet()) {
                String lk;
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                if (key == null || !(lk = StringUtils.lowerCase((String)key.toString())).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith("x-amz-")) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry parameter : request.getParameters().entrySet()) {
            if (!((String)parameter.getKey()).startsWith("x-amz-")) continue;
            interestingHeaders.put((String)parameter.getKey(), (String)parameter.getValue());
        }
        for (Map.Entry entry : interestingHeaders.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (key.startsWith("x-amz-")) {
                buf.append(key).append(':');
                if (value != null) {
                    buf.append(value);
                }
            } else if (value != null) {
                buf.append(value);
            }
            buf.append("\n");
        }
        buf.append(resource);
        Object[] parameterNames = request.getParameters().keySet().toArray(new String[request.getParameters().size()]);
        Arrays.sort(parameterNames);
        int separator = 63;
        for (Object parameterName : parameterNames) {
            if (!SIGNED_PARAMETERS.contains(parameterName)) continue;
            buf.append((char)separator);
            buf.append((String)parameterName);
            String parameterValue = (String)request.getParameters().get(parameterName);
            if (parameterValue != null) {
                buf.append("=").append(parameterValue);
            }
            separator = 38;
        }
        return buf.toString();
    }
}

