/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class TransferStatusUpdater {
    private static final String TAG = "TransferStatusUpdater";
    private static HashSet<TransferState> STATES_NOT_TO_NOTIFY = new HashSet<TransferState>(Arrays.asList(TransferState.PART_COMPLETED, TransferState.PENDING_CANCEL, TransferState.PENDING_PAUSE, TransferState.PENDING_NETWORK_DISCONNECT));
    private static final int UPDATE_THRESHOLD_MS = 1000;
    static final Map<Integer, List<WeakReference<TransferListener>>> listeners = new HashMap<Integer, List<WeakReference<TransferListener>>>();
    private final Map<Integer, TransferRecord> transfers;
    private final Map<Integer, Long> lastUpdateTime;
    private final TransferDBUtil dbUtil;
    private final Handler mainHandler;

    TransferStatusUpdater(TransferDBUtil dbUtil) {
        this.dbUtil = dbUtil;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.transfers = new HashMap<Integer, TransferRecord>();
        this.lastUpdateTime = new HashMap<Integer, Long>();
    }

    Map<Integer, TransferRecord> getTransfers() {
        return Collections.unmodifiableMap(this.transfers);
    }

    void addTransfer(TransferRecord transfer) {
        this.transfers.put(transfer.id, transfer);
    }

    TransferRecord getTransfer(int id) {
        return this.transfers.get(id);
    }

    void removeTransfer(int id) {
        this.transfers.remove(id);
        listeners.remove(id);
        this.lastUpdateTime.remove(id);
    }

    void updateState(final int id, final TransferState newState) {
        boolean shouldNotNotify = STATES_NOT_TO_NOTIFY.contains((Object)newState);
        TransferRecord transfer = this.transfers.get(id);
        if (transfer == null) {
            if (this.dbUtil.updateState(id, newState) == 0) {
                Log.w((String)TAG, (String)("Failed to update the status of transfer " + id));
            }
        } else {
            shouldNotNotify |= newState.equals((Object)transfer.state);
            transfer.state = newState;
            if (this.dbUtil.updateTransferRecord(transfer) == 0) {
                Log.w((String)TAG, (String)("Failed to update the status of transfer " + id));
            }
        }
        if (shouldNotNotify) {
            return;
        }
        final List<WeakReference<TransferListener>> list = listeners.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    TransferListener l = (TransferListener)((WeakReference)it.next()).get();
                    if (l == null) {
                        it.remove();
                        continue;
                    }
                    l.onStateChanged(id, newState);
                }
            }
        });
    }

    void updateProgress(final int id, final long bytesCurrent, final long bytesTotal) {
        List<WeakReference<TransferListener>> list;
        TransferRecord transfer = this.transfers.get(id);
        if (transfer != null) {
            transfer.bytesCurrent = bytesCurrent;
            transfer.bytesTotal = bytesTotal;
        }
        if ((list = listeners.get(id)) == null || list.isEmpty()) {
            return;
        }
        long timeInMillis = System.currentTimeMillis();
        if (!this.lastUpdateTime.containsKey(id) || timeInMillis - this.lastUpdateTime.get(id) > 1000L || bytesCurrent == bytesTotal) {
            this.lastUpdateTime.put(id, timeInMillis);
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        TransferListener l = (TransferListener)((WeakReference)it.next()).get();
                        if (l == null) {
                            it.remove();
                            continue;
                        }
                        l.onProgressChanged(id, bytesCurrent, bytesTotal);
                    }
                }
            });
        }
    }

    void throwError(final int id, final Exception e) {
        final List<WeakReference<TransferListener>> list = listeners.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    TransferListener l = (TransferListener)((WeakReference)it.next()).get();
                    if (l == null) {
                        it.remove();
                        continue;
                    }
                    l.onError(id, e);
                }
            }
        });
    }

    void clear() {
        listeners.clear();
        this.transfers.clear();
        this.lastUpdateTime.clear();
    }

    static void registerListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        List<WeakReference<TransferListener>> list = listeners.get(id);
        if (list == null) {
            list = new LinkedList<WeakReference<TransferListener>>();
            listeners.put(id, list);
        }
        Iterator<WeakReference<TransferListener>> it = list.iterator();
        while (it.hasNext()) {
            TransferListener l = (TransferListener)it.next().get();
            if (l == null) {
                it.remove();
                continue;
            }
            if (l != listener) continue;
            return;
        }
        list.add(new WeakReference<TransferListener>(listener));
    }

    static void unregisterListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        List<WeakReference<TransferListener>> list = listeners.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<WeakReference<TransferListener>> it = list.iterator();
        while (it.hasNext()) {
            TransferListener l = (TransferListener)it.next().get();
            if (l != null && l != listener) continue;
            it.remove();
        }
    }

    ProgressListener newProgressListener(int id, long bytesCurrent, long bytesTotal) {
        TransferRecord transfer = this.getTransfer(id);
        if (transfer == null) {
            throw new IllegalArgumentException("transfer " + id + " doesn't exist");
        }
        this.updateProgress(id, bytesCurrent, bytesTotal);
        return new TransferProgressListener(transfer);
    }

    private class TransferProgressListener
    implements ProgressListener {
        private final TransferRecord transfer;

        public TransferProgressListener(TransferRecord transfer) {
            this.transfer = transfer;
        }

        public void progressChanged(ProgressEvent progressEvent) {
            if (progressEvent.getBytesTransferred() > 0L) {
                this.transfer.bytesCurrent += progressEvent.getBytesTransferred();
                TransferStatusUpdater.this.updateProgress(this.transfer.id, this.transfer.bytesCurrent, this.transfer.bytesTotal);
            }
        }
    }
}

