/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.database.Cursor;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import java.io.File;

public class TransferObserver {
    private final int id;
    private final TransferDBUtil dbUtil;
    private long bytesTotal;
    private long bytesTransferred;
    private TransferState transferState;
    private String filePath;
    private TransferListener transferListener;
    private TransferStatusListener statusListener;

    TransferObserver(int id, TransferDBUtil dbUtil, File file) {
        this.id = id;
        this.dbUtil = dbUtil;
        this.filePath = file.getAbsolutePath();
        this.bytesTotal = file.length();
        this.transferState = TransferState.WAITING;
    }

    TransferObserver(int id, TransferDBUtil dbUtil, Cursor c) {
        this.id = id;
        this.dbUtil = dbUtil;
        this.updateFromDB(c);
    }

    public void refresh() {
        try (Cursor c = this.dbUtil.queryTransferById(this.id);){
            if (c.moveToFirst()) {
                this.updateFromDB(c);
            }
        }
    }

    private void updateFromDB(Cursor c) {
        this.bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        this.bytesTransferred = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
        this.transferState = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        this.filePath = c.getString(c.getColumnIndexOrThrow("file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferListener(TransferListener listener) {
        TransferObserver transferObserver = this;
        synchronized (transferObserver) {
            this.cleanTransferListener();
            this.statusListener = new TransferStatusListener();
            TransferStatusUpdater.registerListener(this.id, this.statusListener);
            this.transferListener = listener;
            TransferStatusUpdater.registerListener(this.id, this.transferListener);
        }
    }

    public int getId() {
        return this.id;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public String getAbsoluteFilePath() {
        return this.filePath;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public TransferState getState() {
        return this.transferState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTransferListener() {
        TransferObserver transferObserver = this;
        synchronized (transferObserver) {
            if (this.transferListener != null) {
                TransferStatusUpdater.unregisterListener(this.id, this.transferListener);
                this.transferListener = null;
            }
            if (this.statusListener != null) {
                TransferStatusUpdater.unregisterListener(this.id, this.statusListener);
                this.statusListener = null;
            }
        }
    }

    private class TransferStatusListener
    implements TransferListener {
        private TransferStatusListener() {
        }

        @Override
        public void onStateChanged(int id, TransferState state) {
            TransferObserver.this.transferState = state;
        }

        @Override
        public void onProgressChanged(int id, long bytesCurrent, long bytesTotal) {
            TransferObserver.this.bytesTransferred = bytesCurrent;
            TransferObserver.this.bytesTotal = bytesTotal;
        }

        @Override
        public void onError(int id, Exception ex) {
        }
    }
}

