/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import com.amazonaws.AbortedException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;

class UploadPartTask
implements Callable<Boolean> {
    private static final String TAG = "UploadPartTask";
    private final UploadPartRequest request;
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;

    public UploadPartTask(UploadPartRequest request, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.request = request;
        this.s3 = s3;
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            UploadPartResult putPartResult = this.s3.uploadPart(this.request);
            this.dbUtil.updateState(this.request.getId(), TransferState.PART_COMPLETED);
            this.dbUtil.updateETag(this.request.getId(), putPartResult.getETag());
            return true;
        }
        catch (Exception e) {
            this.dbUtil.updateState(this.request.getId(), TransferState.FAILED);
            if (e instanceof AbortedException || e.getCause() != null && (e.getCause() instanceof InterruptedIOException || e.getCause() instanceof InterruptedException)) {
                return false;
            }
            Log.e((String)TAG, (String)("Encountered error uploading part " + e.getMessage()));
            throw e;
        }
    }
}

