/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility.networkinfo;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazonaws.mobileconnectors.s3.transferutility.networkinfo.NetworkInfoChangeListener;
import java.util.ArrayList;
import java.util.List;

public class NetworkInfoReceiver
extends BroadcastReceiver {
    private final List<NetworkInfoChangeListener> listeners = new ArrayList<NetworkInfoChangeListener>();
    private boolean isNetworkConnected;

    public NetworkInfoReceiver(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connManager.getActiveNetworkInfo();
        this.isNetworkConnected = info != null && info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkInfoListener(NetworkInfoChangeListener listener) {
        List<NetworkInfoChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkInfoListener(NetworkInfoChangeListener listener) {
        List<NetworkInfoChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isNetworkConnected() {
        return this.isNetworkConnected;
    }

    public void onReceive(Context context, Intent intent) {
        block5: {
            if (this.listeners.size() == 0) {
                return;
            }
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE")) break block5;
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connManager.getActiveNetworkInfo();
            boolean bl = this.isNetworkConnected = info != null && info.isConnected();
            if (this.isNetworkConnected) {
                for (NetworkInfoChangeListener listener : this.listeners) {
                    listener.onConnect();
                }
            } else {
                for (NetworkInfoChangeListener listener : this.listeners) {
                    listener.onDisconnect();
                }
            }
        }
    }
}

