/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import java.util.Arrays;
import java.util.HashSet;

public class TransferObserver {
    private static HashSet<TransferState> STATES_NOT_TO_NOTIFY = new HashSet<TransferState>(Arrays.asList(TransferState.PART_COMPLETED, TransferState.PENDING_CANCEL, TransferState.PENDING_PAUSE, TransferState.PENDING_NETWORK_DISCONNECT));
    private final Context context;
    private final TransferContentObserver observer;
    private final int id;
    private long bytesTotal;
    private long bytesTransferred;
    private TransferState transferState;
    private String filePath;
    private TransferListener transferListener;
    private final TransferDBUtil dbUtil;

    public TransferObserver(int id, Context context, long bytesTotal) {
        this.id = id;
        this.context = context;
        this.bytesTotal = bytesTotal;
        this.transferState = TransferState.WAITING;
        this.dbUtil = new TransferDBUtil(this.context);
        this.refresh();
        this.observer = new TransferContentObserver(new Handler(context.getMainLooper()));
    }

    public void refresh() {
        Cursor c = this.dbUtil.queryTransferById(this.id);
        if (!c.moveToFirst()) {
            c.close();
            return;
        }
        this.bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        this.bytesTransferred = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
        this.transferState = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        this.filePath = c.getString(c.getColumnIndexOrThrow("file"));
        c.close();
    }

    public void setTransferListener(TransferListener listener) {
        if (listener == null) {
            this.cleanTransferListener();
            return;
        }
        this.transferListener = listener;
        this.context.getContentResolver().registerContentObserver(this.dbUtil.getRecordUri(this.id), true, (ContentObserver)this.observer);
    }

    public int getId() {
        return this.id;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public String getAbsoluteFilePath() {
        return this.filePath;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public TransferState getState() {
        return this.transferState;
    }

    public void cleanTransferListener() {
        this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.observer);
    }

    private class TransferContentObserver
    extends ContentObserver {
        public TransferContentObserver(Handler handler) {
            super(handler);
        }

        public void onChange(boolean selfChange) {
            if (TransferObserver.this.transferListener == null) {
                return;
            }
            Cursor c = TransferObserver.this.dbUtil.queryTransferById(TransferObserver.this.id);
            if (!c.moveToFirst()) {
                c.close();
                return;
            }
            String stateString = c.getString(c.getColumnIndexOrThrow("state"));
            TransferState state = null;
            if (stateString != null && !stateString.equalsIgnoreCase("")) {
                state = TransferState.getState(stateString);
            }
            if (state != null && !state.equals((Object)TransferObserver.this.transferState)) {
                TransferObserver.this.transferState = state;
                if (!STATES_NOT_TO_NOTIFY.contains((Object)state)) {
                    TransferObserver.this.transferListener.onStateChanged(TransferObserver.this.id, TransferObserver.this.transferState);
                }
                if (TransferState.FAILED.equals((Object)TransferObserver.this.transferState)) {
                    TransferObserver.this.transferListener.onError(TransferObserver.this.id, new IllegalStateException("Transfer failed."));
                }
            }
            if (TransferState.IN_PROGRESS.equals((Object)state) || TransferState.COMPLETED.equals((Object)state)) {
                long bytesCurrent = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
                long bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
                if (TransferObserver.this.bytesTotal != bytesTotal) {
                    TransferObserver.this.bytesTotal = bytesTotal;
                }
                if (TransferObserver.this.bytesTransferred != bytesCurrent) {
                    TransferObserver.this.bytesTransferred = bytesCurrent;
                    TransferObserver.this.transferListener.onProgressChanged(TransferObserver.this.id, TransferObserver.this.bytesTransferred, TransferObserver.this.bytesTotal);
                }
            }
            c.close();
        }
    }
}

