/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager;

import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableDownload;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableUpload;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.JsonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public abstract class PersistableTransfer {
    public abstract String serialize();

    public final void serialize(OutputStream out) throws IOException {
        out.write(this.serialize().getBytes(StringUtils.UTF8));
        out.flush();
    }

    public static <T extends PersistableTransfer> T deserializeFrom(InputStream in) {
        String type = null;
        String bucketName = null;
        String key = null;
        String file = null;
        String multipartUploadId = null;
        long partSize = -1L;
        long mutlipartUploadThreshold = -1L;
        String versionId = null;
        long[] range = new long[]{-1L, -1L};
        ResponseHeaderOverrides responseHeaders = null;
        boolean isRequesterPays = false;
        AwsJsonReader reader = JsonUtils.getJsonReader((Reader)new BufferedReader(new InputStreamReader(in)));
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("pauseType")) {
                    type = reader.nextString();
                    continue;
                }
                if (name.equals("bucketName")) {
                    bucketName = reader.nextString();
                    continue;
                }
                if (name.equals("key")) {
                    key = reader.nextString();
                    continue;
                }
                if (name.equals("file")) {
                    file = reader.nextString();
                    continue;
                }
                if (name.equals("multipartUploadId")) {
                    multipartUploadId = reader.nextString();
                    continue;
                }
                if (name.equals("partSize")) {
                    partSize = Long.parseLong(reader.nextString());
                    continue;
                }
                if (name.equals("mutlipartUploadThreshold")) {
                    mutlipartUploadThreshold = Long.parseLong(reader.nextString());
                    continue;
                }
                if (name.equals("versionId")) {
                    versionId = reader.nextString();
                    continue;
                }
                if (name.equals("range")) {
                    reader.beginArray();
                    range[0] = Long.parseLong(reader.nextString());
                    range[1] = Long.parseLong(reader.nextString());
                    reader.endArray();
                    continue;
                }
                if (name.equals("responseHeaders")) {
                    responseHeaders = new ResponseHeaderOverrides();
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String n = reader.nextName();
                        if (n.equals("contentType")) {
                            responseHeaders.setContentType(reader.nextString());
                            continue;
                        }
                        if (n.equals("contentLanguage")) {
                            responseHeaders.setContentLanguage(reader.nextString());
                            continue;
                        }
                        if (n.equals("expires")) {
                            responseHeaders.setExpires(reader.nextString());
                            continue;
                        }
                        if (n.equals("cacheControl")) {
                            responseHeaders.setCacheControl(reader.nextString());
                            continue;
                        }
                        if (n.equals("contentDisposition")) {
                            responseHeaders.setContentDisposition(reader.nextString());
                            continue;
                        }
                        if (n.equals("contentEncoding")) {
                            responseHeaders.setContentEncoding(reader.nextString());
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue;
                }
                if (name.equals("isRequesterPays")) {
                    isRequesterPays = Boolean.parseBoolean(reader.nextString());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if ("download".equals(type)) {
            return (T)new PersistableDownload(bucketName, key, versionId, range, responseHeaders, isRequesterPays, file);
        }
        if ("upload".equals(type)) {
            return (T)new PersistableUpload(bucketName, key, file, multipartUploadId, partSize, mutlipartUploadThreshold);
        }
        throw new UnsupportedOperationException("Unsupported paused transfer type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PersistableTransfer> T deserializeFrom(String serialized) {
        if (serialized == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serialized.getBytes(StringUtils.UTF8));
        T t = PersistableTransfer.deserializeFrom(byteStream);
        return t;
        finally {
            try {
                byteStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

