/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

public enum Permission {
    FullControl("FULL_CONTROL", "x-amz-grant-full-control"),
    Read("READ", "x-amz-grant-read"),
    Write("WRITE", "x-amz-grant-write"),
    ReadAcp("READ_ACP", "x-amz-grant-read-acp"),
    WriteAcp("WRITE_ACP", "x-amz-grant-write-acp");

    private String permissionString;
    private String headerName;

    private Permission(String string2, String string3) {
        this.permissionString = string2;
        this.headerName = string3;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String toString() {
        return this.permissionString;
    }

    public static Permission parsePermission(String string) {
        for (Permission permission : Permission.values()) {
            if (!permission.permissionString.equals(string)) continue;
            return permission;
        }
        return null;
    }
}

