/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.SSECustomerKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GetObjectRequest
extends AmazonWebServiceRequest {
    private String bucketName;
    private String key;
    private String versionId;
    private long[] range;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private ResponseHeaderOverrides responseHeaders;
    private com.amazonaws.event.ProgressListener generalProgressListener;
    private boolean isRequesterPays;
    private SSECustomerKey sseCustomerKey;

    public GetObjectRequest(String string, String string2) {
        this(string, string2, null);
    }

    public GetObjectRequest(String string, String string2, String string3) {
        this.setBucketName(string);
        this.setKey(string2);
        this.setVersionId(string3);
        this.setRequesterPays(false);
    }

    public GetObjectRequest(String string, String string2, boolean bl) {
        this.bucketName = string;
        this.key = string2;
        this.isRequesterPays = bl;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public GetObjectRequest withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public GetObjectRequest withKey(String string) {
        this.setKey(string);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String string) {
        this.versionId = string;
    }

    public GetObjectRequest withVersionId(String string) {
        this.setVersionId(string);
        return this;
    }

    public long[] getRange() {
        return this.range == null ? null : (long[])this.range.clone();
    }

    public void setRange(long l, long l2) {
        this.range = new long[]{l, l2};
    }

    public GetObjectRequest withRange(long l, long l2) {
        this.setRange(l, l2);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> list) {
        this.matchingETagConstraints = list;
    }

    public GetObjectRequest withMatchingETagConstraint(String string) {
        this.matchingETagConstraints.add(string);
        return this;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> list) {
        this.nonmatchingEtagConstraints = list;
    }

    public GetObjectRequest withNonmatchingETagConstraint(String string) {
        this.nonmatchingEtagConstraints.add(string);
        return this;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public GetObjectRequest withUnmodifiedSinceConstraint(Date date) {
        this.setUnmodifiedSinceConstraint(date);
        return this;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public GetObjectRequest withModifiedSinceConstraint(Date date) {
        this.setModifiedSinceConstraint(date);
        return this;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.responseHeaders = responseHeaderOverrides;
    }

    public GetObjectRequest withResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.setResponseHeaders(responseHeaderOverrides);
        return this;
    }

    @Deprecated
    public void setProgressListener(ProgressListener progressListener) {
        this.generalProgressListener = new LegacyS3ProgressListener(progressListener);
    }

    @Deprecated
    public ProgressListener getProgressListener() {
        if (this.generalProgressListener instanceof LegacyS3ProgressListener) {
            return ((LegacyS3ProgressListener)this.generalProgressListener).unwrap();
        }
        return null;
    }

    @Deprecated
    public GetObjectRequest withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public void setGeneralProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.generalProgressListener = progressListener;
    }

    public com.amazonaws.event.ProgressListener getGeneralProgressListener() {
        return this.generalProgressListener;
    }

    public GetObjectRequest withGeneralProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sseCustomerKey = sSECustomerKey;
    }

    public GetObjectRequest withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        return this;
    }
}

