/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private HashSet<Grant> grants = new HashSet();
    private Owner owner = null;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.grants.add(new Grant(grantee, permission));
    }

    public void grantAllPermissions(Grant ... grantArray) {
        for (Grant grant : grantArray) {
            this.grantPermission(grant.getGrantee(), grant.getPermission());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> arrayList = new ArrayList<Grant>();
        for (Grant grant : this.grants) {
            if (!grant.getGrantee().equals(grantee)) continue;
            arrayList.add(grant);
        }
        this.grants.removeAll(arrayList);
    }

    public Set<Grant> getGrants() {
        return this.grants;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrants() + "]";
    }
}

