/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteRangeCapturingInputStream
extends SdkFilterInputStream {
    private final long startingPosition;
    private final long endingPosition;
    private long streamPosition;
    private int blockPosition = 0;
    private final byte[] block;
    private long markedStreamPosition;
    private int markedBlockPosition;

    public ByteRangeCapturingInputStream(InputStream inputStream, long l, long l2) {
        super(inputStream);
        if (l >= l2) {
            throw new IllegalArgumentException("Invalid byte range specified: the starting position must be less than the ending position");
        }
        this.startingPosition = l;
        this.endingPosition = l2;
        int n = (int)(l2 - l);
        this.block = new byte[n];
    }

    public byte[] getBlock() {
        return this.block;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            return -1;
        }
        if (this.streamPosition >= this.startingPosition && this.streamPosition <= this.endingPosition) {
            this.block[this.blockPosition++] = (byte)n;
        }
        ++this.streamPosition;
        return n;
    }

    public synchronized void mark(int n) {
        super.mark(n);
        if (this.markSupported()) {
            this.markedStreamPosition = this.streamPosition;
            this.markedBlockPosition = this.blockPosition;
        }
    }

    public synchronized void reset() throws IOException {
        super.reset();
        if (this.markSupported()) {
            this.streamPosition = this.markedStreamPosition;
            this.blockPosition = this.markedBlockPosition;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        if (this.streamPosition + (long)n3 >= this.startingPosition && this.streamPosition <= this.endingPosition) {
            for (int i = 0; i < n3; ++i) {
                if (this.streamPosition + (long)i < this.startingPosition || this.streamPosition + (long)i >= this.endingPosition) continue;
                this.block[this.blockPosition++] = byArray[n + i];
            }
        }
        this.streamPosition += (long)n3;
        return n3;
    }
}

