/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class RestUtils {
    private static final List<String> SIGNED_PARAMETERS = Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires");

    public static <T> String makeS3CanonicalString(String string, String string2, Request<T> request, String string3) {
        String string4;
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "\n");
        Map map = request.getHeaders();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                String string5;
                objectArray = (Object[])entry.getKey();
                string4 = (String)entry.getValue();
                if (objectArray == null || !(string5 = objectArray.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !string5.equals("content-md5") && !string5.equals("date") && !string5.startsWith("x-amz-")) continue;
                treeMap.put(string5, string4);
            }
        }
        if (treeMap.containsKey("x-amz-date")) {
            treeMap.put("date", "");
        }
        if (string3 != null) {
            treeMap.put("date", string3);
        }
        if (!treeMap.containsKey("content-type")) {
            treeMap.put("content-type", "");
        }
        if (!treeMap.containsKey("content-md5")) {
            treeMap.put("content-md5", "");
        }
        for (Map.Entry entry : request.getParameters().entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-amz-")) continue;
            treeMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            objectArray = (String)entry.getKey();
            string4 = (String)entry.getValue();
            if (objectArray.startsWith("x-amz-")) {
                stringBuilder.append((String)objectArray).append(':');
                if (string4 != null) {
                    stringBuilder.append(string4);
                }
            } else if (string4 != null) {
                stringBuilder.append(string4);
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(string2);
        Object[] objectArray2 = request.getParameters().keySet().toArray(new String[request.getParameters().size()]);
        Arrays.sort(objectArray2);
        int n = 63;
        for (Object object : objectArray2) {
            if (!SIGNED_PARAMETERS.contains(object)) continue;
            stringBuilder.append((char)n);
            stringBuilder.append((String)object);
            String string6 = (String)request.getParameters().get(object);
            if (string6 != null) {
                stringBuilder.append("=").append(string6);
            }
            n = 38;
        }
        return stringBuilder.toString();
    }
}

