/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.util.Base64;
import javax.crypto.SecretKey;

public class SSECustomerKey {
    private final String base64EncodedKey;
    private String base64EncodedMd5;
    private String algorithm;

    public SSECustomerKey(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = string;
    }

    public SSECustomerKey(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = Base64.encodeAsString((byte[])byArray);
    }

    public SSECustomerKey(SecretKey secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = Base64.encodeAsString((byte[])secretKey.getEncoded());
    }

    public String getKey() {
        return this.base64EncodedKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public SSECustomerKey withAlgorithm(String string) {
        this.setAlgorithm(string);
        return this;
    }

    public String getMd5() {
        return this.base64EncodedMd5;
    }

    public void setMd5(String string) {
        this.base64EncodedMd5 = string;
    }

    public SSECustomerKey withMd5(String string) {
        this.setMd5(string);
        return this;
    }
}

