/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricFilterInputStream;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.client.methods.HttpRequestBase;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import java.io.IOException;
import java.io.InputStream;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream inputStream, HttpRequestBase httpRequestBase) {
        this(inputStream, httpRequestBase, S3ObjectInputStream.wrapWithByteCounting(inputStream));
    }

    public S3ObjectInputStream(InputStream inputStream, HttpRequestBase httpRequestBase, boolean bl) {
        super((InputStream)(bl ? new MetricFilterInputStream((ThroughputMetricType)S3ServiceMetric.S3DownloadThroughput, inputStream) : inputStream));
        this.httpRequest = httpRequestBase;
    }

    private static boolean wrapWithByteCounting(InputStream inputStream) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (inputStream instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)inputStream;
            return !metricAware.isMetricActivated();
        }
        return true;
    }

    public void abort() {
        this.getHttpRequest().abort();
        try {
            this.close();
        }
        catch (IOException iOException) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"FYI", (Throwable)iOException);
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }
}

