/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class EncryptionInstruction {
    private final Map<String, String> materialsDescription;
    private final byte[] encryptedSymmetricKey;
    private final Cipher symmetricCipher;
    private final CipherFactory symmetricCipherFactory;

    public EncryptionInstruction(Map<String, String> map, byte[] byArray, SecretKey secretKey, Cipher cipher) {
        this.materialsDescription = map;
        this.encryptedSymmetricKey = byArray;
        this.symmetricCipher = cipher;
        this.symmetricCipherFactory = null;
    }

    public EncryptionInstruction(Map<String, String> map, byte[] byArray, SecretKey secretKey, CipherFactory cipherFactory) {
        this.materialsDescription = map;
        this.encryptedSymmetricKey = byArray;
        this.symmetricCipherFactory = cipherFactory;
        this.symmetricCipher = cipherFactory.createCipher();
    }

    public CipherFactory getCipherFactory() {
        return this.symmetricCipherFactory;
    }

    public Map<String, String> getMaterialsDescription() {
        return this.materialsDescription;
    }

    public byte[] getEncryptedSymmetricKey() {
        return this.encryptedSymmetricKey;
    }

    public Cipher getSymmetricCipher() {
        return this.symmetricCipher;
    }
}

