/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.http.HttpResponse;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.internal.HeaderHandler;
import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectExpirationHeaderHandler<T extends ObjectExpirationResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern rulePattern = Pattern.compile("rule-id=\"(.*?)\"");
    private static final Log log = LogFactory.getLog(ObjectExpirationHeaderHandler.class);

    @Override
    public void handle(T t, HttpResponse httpResponse) {
        String string = (String)httpResponse.getHeaders().get("x-amz-expiration");
        if (string != null) {
            t.setExpirationTime(this.parseDate(string));
            t.setExpirationTimeRuleId(this.parseRuleId(string));
        }
    }

    private String parseRuleId(String string) {
        Matcher matcher = rulePattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Date parseDate(String string) {
        Matcher matcher = datePattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return ServiceUtils.parseRfc822Date(string2);
            }
            catch (Exception exception) {
                log.warn((Object)"Error parsing expiry-date from x-amz-expiration header.", (Throwable)exception);
            }
        }
        return null;
    }
}

