/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputSubstream
extends SdkFilterInputStream {
    private long currentPosition = 0L;
    private final long requestedOffset;
    private final long requestedLength;
    private final boolean closeSourceStream;
    private long markedPosition = 0L;

    public InputSubstream(InputStream inputStream, long l, long l2, boolean bl) {
        super(inputStream);
        this.requestedLength = l2;
        this.requestedOffset = l;
        this.closeSourceStream = bl;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return n;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l;
        while (this.currentPosition < this.requestedOffset) {
            l = super.skip(this.requestedOffset - this.currentPosition);
            this.currentPosition += l;
        }
        l = this.requestedLength + this.requestedOffset - this.currentPosition;
        if (l <= 0L) {
            return -1;
        }
        n2 = (int)Math.min((long)n2, l);
        int n3 = super.read(byArray, n, n2);
        this.currentPosition += (long)n3;
        return n3;
    }

    public synchronized void mark(int n) {
        this.markedPosition = this.currentPosition;
        super.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.currentPosition = this.markedPosition;
        super.reset();
    }

    public void close() throws IOException {
        if (this.closeSourceStream) {
            super.close();
        }
    }

    public int available() throws IOException {
        long l = this.currentPosition < this.requestedOffset ? this.requestedLength : this.requestedLength + this.requestedOffset - this.currentPosition;
        return (int)Math.min(l, (long)super.available());
    }
}

