/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressReportingInputStream;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.client.methods.HttpRequestBase;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.DeleteObjectsResponse;
import com.amazonaws.services.s3.internal.DigestValidationInputStream;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.MD5DigestCalculatingInputStream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.RepeatableInputStream;
import com.amazonaws.services.s3.internal.ResponseHeaderHandlerChain;
import com.amazonaws.services.s3.internal.S3ErrorResponseHandler;
import com.amazonaws.services.s3.internal.S3ExecutionContext;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3ObjectResponseHandler;
import com.amazonaws.services.s3.internal.S3QueryStringSigner;
import com.amazonaws.services.s3.internal.S3Signer;
import com.amazonaws.services.s3.internal.S3StringResponseHandler;
import com.amazonaws.services.s3.internal.S3VersionHeaderHandler;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.services.s3.internal.SSEResultBase;
import com.amazonaws.services.s3.internal.ServerSideEncryptionHeaderHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GenericBucketRequest;
import com.amazonaws.services.s3.model.GetBucketAclRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.GetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiFactorAuthentication;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.RequestPaymentConfiguration;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SetBucketAclRequest;
import com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.SetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.transform.AclXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.MultiObjectDeleteXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestPaymentConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestXmlFactory;
import com.amazonaws.services.s3.model.transform.Unmarshallers;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.ServiceClientHolderInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class AmazonS3Client
extends AmazonWebServiceClient
implements AmazonS3 {
    public static final String S3_SERVICE_NAME = "s3";
    private static final String S3_SIGNER = "S3SignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private S3ErrorResponseHandler errorResponseHandler = new S3ErrorResponseHandler();
    private S3XmlResponseHandler<Void> voidResponseHandler = new S3XmlResponseHandler(null);
    private static final BucketConfigurationXmlFactory bucketConfigurationXmlFactory;
    private static final RequestPaymentConfigurationXmlFactory requestPaymentConfigurationXmlFactory;
    private S3ClientOptions clientOptions = new S3ClientOptions();
    private AWSCredentialsProvider awsCredentialsProvider;
    private boolean hasExplicitRegion;

    public AmazonS3Client() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonS3Client(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new ClientConfiguration());
    }

    public AmazonS3Client(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(aWSCredentials);
        this.init();
    }

    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, new ClientConfiguration());
    }

    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, null);
    }

    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.init();
    }

    public AmazonS3Client(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    private void init() {
        this.client.disableStrictHostnameVerification();
        this.setEndpoint(Constants.S3_HOSTNAME);
        HandlerChainFactory handlerChainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3/request.handler2s"));
    }

    @Override
    public void setEndpoint(String string) {
        this.hasExplicitRegion = !Constants.S3_HOSTNAME.equals(string);
        super.setEndpoint(string);
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        this.hasExplicitRegion = true;
        super.setRegion(region);
    }

    @Override
    public void setS3ClientOptions(S3ClientOptions s3ClientOptions) {
        this.clientOptions = new S3ClientOptions(s3ClientOptions);
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing versionListing) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(versionListing, "The previous version listing parameter must be specified when listing the next batch of versions in a bucket");
        if (!versionListing.isTruncated()) {
            VersionListing versionListing2 = new VersionListing();
            versionListing2.setBucketName(versionListing.getBucketName());
            versionListing2.setDelimiter(versionListing.getDelimiter());
            versionListing2.setKeyMarker(versionListing.getNextKeyMarker());
            versionListing2.setVersionIdMarker(versionListing.getNextVersionIdMarker());
            versionListing2.setMaxKeys(versionListing.getMaxKeys());
            versionListing2.setPrefix(versionListing.getPrefix());
            versionListing2.setEncodingType(versionListing.getEncodingType());
            versionListing2.setTruncated(false);
            return versionListing2;
        }
        return this.listVersions(new ListVersionsRequest(versionListing.getBucketName(), versionListing.getPrefix(), versionListing.getNextKeyMarker(), versionListing.getNextVersionIdMarker(), versionListing.getDelimiter(), new Integer(versionListing.getMaxKeys())).withEncodingType(versionListing.getEncodingType()));
    }

    @Override
    public VersionListing listVersions(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.listVersions(new ListVersionsRequest(string, string2, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String string, String string2, String string3, String string4, String string5, Integer n) throws AmazonClientException, AmazonServiceException {
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest().withBucketName(string).withPrefix(string2).withDelimiter(string5).withKeyMarker(string3).withVersionIdMarker(string4).withMaxResults(n);
        return this.listVersions(listVersionsRequest);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        Request<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        if (listVersionsRequest.getPrefix() != null) {
            request.addParameter("prefix", listVersionsRequest.getPrefix());
        }
        if (listVersionsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listVersionsRequest.getKeyMarker());
        }
        if (listVersionsRequest.getVersionIdMarker() != null) {
            request.addParameter("version-id-marker", listVersionsRequest.getVersionIdMarker());
        }
        if (listVersionsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listVersionsRequest.getDelimiter());
        }
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        if (listVersionsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listVersionsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(), listVersionsRequest.getBucketName(), null);
    }

    @Override
    public ObjectListing listObjects(String string) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(string, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(string, string2, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        if (listObjectsRequest.getPrefix() != null) {
            request.addParameter("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            request.addParameter("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        if (listObjectsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listObjectsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(), listObjectsRequest.getBucketName(), null);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(objectListing, "The previous object listing parameter must be specified when listing the next batch of objects in a bucket");
        if (!objectListing.isTruncated()) {
            ObjectListing objectListing2 = new ObjectListing();
            objectListing2.setBucketName(objectListing.getBucketName());
            objectListing2.setDelimiter(objectListing.getDelimiter());
            objectListing2.setMarker(objectListing.getNextMarker());
            objectListing2.setMaxKeys(objectListing.getMaxKeys());
            objectListing2.setPrefix(objectListing.getPrefix());
            objectListing2.setEncodingType(objectListing.getEncodingType());
            objectListing2.setTruncated(false);
            return objectListing2;
        }
        return this.listObjects(new ListObjectsRequest(objectListing.getBucketName(), objectListing.getPrefix(), objectListing.getNextMarker(), objectListing.getDelimiter(), new Integer(objectListing.getMaxKeys())).withEncodingType(objectListing.getEncodingType()));
    }

    @Override
    public Owner getS3AccountOwner() throws AmazonClientException, AmazonServiceException {
        Request<ListBucketsRequest> request = this.createRequest(null, null, new ListBucketsRequest(), HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsOwnerUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws AmazonClientException, AmazonServiceException {
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws AmazonClientException, AmazonServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String string = getBucketLocationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting a bucket's location");
        Request<GetBucketLocationRequest> request = this.createRequest(string, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller(), string, null);
    }

    @Override
    public String getBucketLocation(String string) throws AmazonClientException, AmazonServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(string));
    }

    @Override
    public Bucket createBucket(String string) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string));
    }

    @Override
    public Bucket createBucket(String string, Region region) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string, region));
    }

    @Override
    public Bucket createBucket(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string, string2));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String string = createBucketRequest.getBucketName();
        String string2 = createBucketRequest.getRegion();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when creating a bucket");
        if (string != null) {
            string = string.trim();
        }
        BucketNameUtils.validateBucketName(string);
        Request<CreateBucketRequest> request = this.createRequest(string, null, createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", createBucketRequest.getCannedAcl().toString());
        }
        if (!this.endpoint.getHost().equals(Constants.S3_HOSTNAME) && (string2 == null || string2.isEmpty())) {
            try {
                string2 = RegionUtils.getRegionByEndpoint((String)this.endpoint.getHost()).getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (string2 != null && !string2.toUpperCase().equals(Region.US_Standard.toString())) {
            XmlWriter xmlWriter = new XmlWriter();
            xmlWriter.start("CreateBucketConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            xmlWriter.start("LocationConstraint").value(string2).end();
            xmlWriter.end();
            request.setContent((InputStream)new ByteArrayInputStream(xmlWriter.getBytes()));
        }
        this.invoke(request, this.voidResponseHandler, string, null);
        return new Bucket(string);
    }

    @Override
    public AccessControlList getObjectAcl(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.getObjectAcl(string, string2, null);
    }

    @Override
    public AccessControlList getObjectAcl(String string, String string2, String string3) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting an object's ACL");
        this.assertParameterNotNull(string2, "The key parameter must be specified when requesting an object's ACL");
        return this.getAcl(string, string2, string3, null);
    }

    @Override
    public void setObjectAcl(String string, String string2, AccessControlList accessControlList) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(string, string2, null, accessControlList);
    }

    @Override
    public void setObjectAcl(String string, String string2, CannedAccessControlList cannedAccessControlList) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(string, string2, null, cannedAccessControlList);
    }

    @Override
    public void setObjectAcl(String string, String string2, String string3, AccessControlList accessControlList) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl0(string, string2, string3, accessControlList, null);
    }

    public void setObjectAcl(String string, String string2, String string3, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl0(string, string2, string3, accessControlList, requestMetricCollector);
    }

    private void setObjectAcl0(String string, String string2, String string3, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(string2, "The key parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(accessControlList, "The ACL parameter must be specified when setting an object's ACL");
        this.setAcl(string, string2, string3, accessControlList, new GenericBucketRequest(string).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl0(string, string2, string3, cannedAccessControlList, null);
    }

    public void setObjectAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) {
        this.setObjectAcl0(string, string2, string3, cannedAccessControlList, requestMetricCollector);
    }

    private void setObjectAcl0(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(string2, "The key parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull((Object)cannedAccessControlList, "The ACL parameter must be specified when setting an object's ACL");
        this.setAcl(string, string2, string3, cannedAccessControlList, new GenericBucketRequest(string).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public AccessControlList getBucketAcl(String string) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(string, null, null, null);
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws AmazonClientException, AmazonServiceException {
        String string = getBucketAclRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(string, null, null, getBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String string, AccessControlList accessControlList) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(string, accessControlList, null);
    }

    public void setBucketAcl(String string, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) {
        this.setBucketAcl0(string, accessControlList, requestMetricCollector);
    }

    private void setBucketAcl0(String string, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull(accessControlList, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(string, null, null, accessControlList, new GenericBucketRequest(string).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws AmazonClientException, AmazonServiceException {
        String string = setBucketAclRequest.getBucketName();
        AccessControlList accessControlList = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAccessControlList = setBucketAclRequest.getCannedAcl();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting a bucket's ACL");
        if (accessControlList != null) {
            this.setAcl(string, null, null, accessControlList, (AmazonWebServiceRequest)setBucketAclRequest);
        } else if (cannedAccessControlList != null) {
            this.setAcl(string, null, null, cannedAccessControlList, (AmazonWebServiceRequest)setBucketAclRequest);
        } else {
            this.assertParameterNotNull(null, "The ACL parameter must be specified when setting a bucket's ACL");
        }
    }

    @Override
    public void setBucketAcl(String string, CannedAccessControlList cannedAccessControlList) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(string, cannedAccessControlList, null);
    }

    public void setBucketAcl(String string, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.setBucketAcl0(string, cannedAccessControlList, requestMetricCollector);
    }

    private void setBucketAcl0(String string, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull((Object)cannedAccessControlList, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(string, null, null, cannedAccessControlList, new GenericBucketRequest(string).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public ObjectMetadata getObjectMetadata(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(string, string2));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String string = getObjectMetadataRequest.getBucketName();
        String string2 = getObjectMetadataRequest.getKey();
        String string3 = getObjectMetadataRequest.getVersionId();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting an object's metadata");
        this.assertParameterNotNull(string2, "The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(string, string2, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateSseCpkRequestParameters(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new S3MetadataResponseHandler(), string, string2);
    }

    @Override
    public S3Object getObject(String string, String string2) throws AmazonClientException, AmazonServiceException {
        return this.getObject(new GetObjectRequest(string, string2));
    }

    @Override
    public boolean doesBucketExist(String string) throws AmazonClientException, AmazonServiceException {
        try {
            this.headBucket(new HeadBucketRequest(string));
            return true;
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getStatusCode() == 301 || amazonServiceException.getStatusCode() == 403) {
                return true;
            }
            if (amazonServiceException.getStatusCode() == 404) {
                return false;
            }
            throw amazonServiceException;
        }
    }

    private void headBucket(HeadBucketRequest headBucketRequest) throws AmazonClientException, AmazonServiceException {
        String string = headBucketRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucketName parameter must be specified.");
        Request<HeadBucketRequest> request = this.createRequest(string, null, headBucketRequest, HttpMethodName.HEAD);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void changeObjectStorageClass(String string, String string2, StorageClass storageClass) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucketName parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull(string2, "The key parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull((Object)storageClass, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(string, string2, string, string2).withStorageClass(storageClass.toString()));
    }

    @Override
    public void setObjectRedirectLocation(String string, String string2, String string3) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucketName parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull(string2, "The key parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull(string3, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(string, string2, string, string2).withRedirectLocation(string3));
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        long[] lArray;
        this.assertParameterNotNull((Object)getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        if ((lArray = getObjectRequest.getRange()) != null) {
            request.addHeader("Range", "bytes=" + Long.toString(lArray[0]) + "-" + Long.toString(lArray[1]));
        }
        if (getObjectRequest.isRequesterPays()) {
            request.addHeader("x-amz-request-payer", "requester");
        }
        AmazonS3Client.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        AmazonS3Client.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        AmazonS3Client.populateSseCpkRequestParameters(request, getObjectRequest.getSSECustomerKey());
        ProgressListener progressListener = getObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListener);
        try {
            Object object;
            S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            s3Object.setBucketName(getObjectRequest.getBucketName());
            s3Object.setKey(getObjectRequest.getKey());
            Object object2 = s3Object.getObjectContent();
            HttpRequestBase httpRequestBase = s3Object.getObjectContent().getHttpRequest();
            object2 = new ServiceClientHolderInputStream((InputStream)object2, (AmazonWebServiceClient)this);
            if (progressListenerCallbackExecutor != null) {
                object = new ProgressReportingInputStream((InputStream)object2, progressListenerCallbackExecutor);
                object.setFireCompletedEvent(true);
                object2 = object;
                this.fireProgressEvent(progressListenerCallbackExecutor, 2);
            }
            if (!AmazonS3Client.skipContentMd5IntegrityCheck(getObjectRequest)) {
                object = null;
                String string = s3Object.getObjectMetadata().getETag();
                if (string != null && !ServiceUtils.isMultipartUploadETag(string)) {
                    object = BinaryUtils.fromHex((String)s3Object.getObjectMetadata().getETag());
                    try {
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        object2 = new DigestValidationInputStream((InputStream)object2, messageDigest, (byte[])object);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)noSuchAlgorithmException);
                    }
                }
            } else {
                object2 = new LengthCheckInputStream((InputStream)object2, s3Object.getObjectMetadata().getContentLength(), true);
            }
            s3Object.setObjectContent(new S3ObjectInputStream((InputStream)object2, httpRequestBase, false));
            return s3Object;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412 || amazonS3Exception.getStatusCode() == 304) {
                this.fireProgressEvent(progressListenerCallbackExecutor, 16);
                return null;
            }
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw amazonS3Exception;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File file) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(file, new ServiceUtils.RetryableS3DownloadTask(){

            @Override
            public S3Object getS3ObjectStream() {
                return AmazonS3Client.this.getObject(getObjectRequest);
            }

            @Override
            public boolean needIntegrityCheck() {
                return !AmazonS3Client.skipContentMd5IntegrityCheck(getObjectRequest);
            }
        }, false);
        if (s3Object == null) {
            return null;
        }
        return s3Object.getObjectMetadata();
    }

    private static boolean skipContentMd5IntegrityCheck(AmazonWebServiceRequest amazonWebServiceRequest) {
        if (System.getProperty("com.amazonaws.services.s3.disableGetObjectMD5Validation") != null) {
            return true;
        }
        if (amazonWebServiceRequest instanceof GetObjectRequest) {
            GetObjectRequest getObjectRequest = (GetObjectRequest)amazonWebServiceRequest;
            if (getObjectRequest.getRange() != null) {
                return true;
            }
            if (getObjectRequest.getSSECustomerKey() != null) {
                return true;
            }
        } else {
            if (amazonWebServiceRequest instanceof PutObjectRequest) {
                PutObjectRequest putObjectRequest = (PutObjectRequest)amazonWebServiceRequest;
                return putObjectRequest.getSSECustomerKey() != null;
            }
            if (amazonWebServiceRequest instanceof UploadPartRequest) {
                UploadPartRequest uploadPartRequest = (UploadPartRequest)amazonWebServiceRequest;
                return uploadPartRequest.getSSECustomerKey() != null;
            }
        }
        return false;
    }

    @Override
    public void deleteBucket(String string) throws AmazonClientException, AmazonServiceException {
        this.deleteBucket(new DeleteBucketRequest(string));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String string = deleteBucketRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(string, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public PutObjectResult putObject(String string, String string2, File file) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(string, string2, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String string, String string2, InputStream inputStream, ObjectMetadata objectMetadata) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(string, string2, inputStream, objectMetadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        Request<PutObjectRequest> request;
        this.assertParameterNotNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        String string = putObjectRequest.getBucketName();
        String string2 = putObjectRequest.getKey();
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        Object object4 = putObjectRequest.getInputStream();
        ProgressListener progressListener = putObjectRequest.getGeneralProgressListener();
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)progressListener);
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when uploading an object");
        this.assertParameterNotNull(string2, "The key parameter must be specified when uploading an object");
        boolean bl = AmazonS3Client.skipContentMd5IntegrityCheck(putObjectRequest);
        if (putObjectRequest.getFile() != null) {
            boolean bl2;
            request = putObjectRequest.getFile();
            objectMetadata.setContentLength(request.length());
            boolean bl3 = bl2 = objectMetadata.getContentMD5() == null;
            if (objectMetadata.getContentType() == null) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype((File)request));
            }
            if (bl2 && !bl) {
                try {
                    String string3 = Md5Utils.md5AsBase64(request);
                    objectMetadata.setContentMD5(string3);
                }
                catch (Exception exception) {
                    throw new AmazonClientException("Unable to calculate MD5 hash: " + exception.getMessage(), (Throwable)exception);
                }
            }
            try {
                object4 = new RepeatableFileInputStream((File)request);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AmazonClientException("Unable to find file to upload", (Throwable)fileNotFoundException);
            }
        }
        request = this.createRequest(string, string2, putObjectRequest, HttpMethodName.PUT);
        if (putObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, putObjectRequest.getAccessControlList());
        } else if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (putObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", putObjectRequest.getStorageClass());
        }
        if (putObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", putObjectRequest.getRedirectLocation());
            if (object4 == null) {
                object4 = new ByteArrayInputStream(new byte[0]);
            }
        }
        AmazonS3Client.populateSseCpkRequestParameters(request, putObjectRequest.getSSECustomerKey());
        Long l = (Long)objectMetadata.getRawMetadataValue("Content-Length");
        if (l == null) {
            log.warn((Object)"No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
        } else {
            long l2 = l;
            if (l2 >= 0L) {
                object3 = new LengthCheckInputStream((InputStream)object4, l2, false);
                object4 = object3;
            }
        }
        if (progressListenerCallbackExecutor != null) {
            object4 = new ProgressReportingInputStream((InputStream)object4, progressListenerCallbackExecutor);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2);
        }
        if (!((InputStream)object4).markSupported()) {
            int n = 131072;
            object2 = System.getProperty("com.amazonaws.sdk.s3.defaultStreamBufferSize");
            if (object2 != null) {
                try {
                    n = Integer.parseInt((String)object2);
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to parse buffer size override from value: " + (String)object2));
                }
            }
            object4 = new RepeatableInputStream((InputStream)object4, n);
        }
        MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream = null;
        if (objectMetadata.getContentMD5() == null && !bl) {
            mD5DigestCalculatingInputStream = new MD5DigestCalculatingInputStream((InputStream)object4);
            object4 = mD5DigestCalculatingInputStream;
        }
        if (objectMetadata.getContentType() == null) {
            objectMetadata.setContentType("application/octet-stream");
        }
        AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        request.setContent((InputStream)object4);
        object2 = null;
        try {
            object2 = this.invoke(request, new S3MetadataResponseHandler(), string, string2);
        }
        catch (AmazonClientException amazonClientException) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw amazonClientException;
        }
        finally {
            try {
                ((InputStream)object4).close();
            }
            catch (AbortedException abortedException) {
            }
            catch (Exception exception) {
                log.debug((Object)("Unable to cleanly close input stream: " + exception.getMessage()), (Throwable)exception);
            }
        }
        object3 = objectMetadata.getContentMD5();
        if (mD5DigestCalculatingInputStream != null) {
            object3 = BinaryUtils.toBase64((byte[])mD5DigestCalculatingInputStream.getMd5Digest());
        }
        if (object2 != null && object3 != null && !bl && !Arrays.equals((byte[])(object = BinaryUtils.fromBase64((String)object3)), byArray = BinaryUtils.fromHex((String)((ObjectMetadata)object2).getETag()))) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 8);
            throw new AmazonClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by Amazon S3.  You may need to delete the data stored in Amazon S3.");
        }
        this.fireProgressEvent(progressListenerCallbackExecutor, 4);
        object = new PutObjectResult();
        ((PutObjectResult)object).setETag(((ObjectMetadata)object2).getETag());
        ((PutObjectResult)object).setVersionId(((ObjectMetadata)object2).getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(((ObjectMetadata)object2).getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(((ObjectMetadata)object2).getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(((ObjectMetadata)object2).getSSECustomerKeyMd5());
        ((PutObjectResult)object).setExpirationTime(((ObjectMetadata)object2).getExpirationTime());
        ((PutObjectResult)object).setExpirationTimeRuleId(((ObjectMetadata)object2).getExpirationTimeRuleId());
        ((PutObjectResult)object).setContentMd5((String)object3);
        return object;
    }

    private static void addAclHeaders(Request<? extends AmazonWebServiceRequest> request, AccessControlList accessControlList) {
        Set<Grant> set = accessControlList.getGrants();
        HashMap hashMap = new HashMap();
        for (Grant grant : set) {
            if (!hashMap.containsKey((Object)grant.getPermission())) {
                hashMap.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)hashMap.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!hashMap.containsKey((Object)permission)) continue;
            Collection collection = (Collection)hashMap.get((Object)permission);
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (Grantee grantee : collection) {
                if (!bl) {
                    bl = true;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), stringBuilder.toString());
        }
    }

    @Override
    public CopyObjectResult copyObject(String string, String string2, String string3, String string4) throws AmazonClientException, AmazonServiceException {
        return this.copyObject(new CopyObjectRequest(string, string2, string3, string4));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws AmazonClientException, AmazonServiceException {
        Object object;
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String string = copyObjectRequest.getDestinationKey();
        String string2 = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(string2, string, copyObjectRequest, HttpMethodName.PUT);
        AmazonS3Client.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler(), new ObjectExpirationHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((Request)request, (HttpResponseHandler)object, string2, string);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412) {
                return null;
            }
            throw amazonS3Exception;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            String string5 = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string3);
            amazonS3Exception.setErrorCode((String)object);
            amazonS3Exception.setErrorType(AmazonServiceException.ErrorType.Service);
            amazonS3Exception.setRequestId(string4);
            amazonS3Exception.setExtendedRequestId(string5);
            amazonS3Exception.setServiceName(request.getServiceName());
            amazonS3Exception.setStatusCode(200);
            throw amazonS3Exception;
        }
        object = new CopyObjectResult();
        ((CopyObjectResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyObjectResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyObjectResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        ((CopyObjectResult)object).setExpirationTime(copyObjectResultHandler.getExpirationTime());
        ((CopyObjectResult)object).setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        return object;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        Object object;
        this.assertParameterNotNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
        this.assertParameterNotNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
        this.assertParameterNotNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
        this.assertParameterNotNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
        this.assertParameterNotNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
        this.assertParameterNotNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
        String string = copyPartRequest.getDestinationKey();
        String string2 = copyPartRequest.getDestinationBucketName();
        Request<CopyPartRequest> request = this.createRequest(string2, string, copyPartRequest, HttpMethodName.PUT);
        AmazonS3Client.populateRequestWithCopyPartParameters(request, copyPartRequest);
        request.addParameter("uploadId", copyPartRequest.getUploadId());
        request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((Request)request, (HttpResponseHandler)object, string2, string);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412) {
                return null;
            }
            throw amazonS3Exception;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            String string5 = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string3);
            amazonS3Exception.setErrorCode((String)object);
            amazonS3Exception.setErrorType(AmazonServiceException.ErrorType.Service);
            amazonS3Exception.setRequestId(string4);
            amazonS3Exception.setExtendedRequestId(string5);
            amazonS3Exception.setServiceName(request.getServiceName());
            amazonS3Exception.setStatusCode(200);
            throw amazonS3Exception;
        }
        object = new CopyPartResult();
        ((CopyPartResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyPartResult)object).setPartNumber(copyPartRequest.getPartNumber());
        ((CopyPartResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyPartResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        return object;
    }

    @Override
    public void deleteObject(String string, String string2) throws AmazonClientException, AmazonServiceException {
        this.deleteObject(new DeleteObjectRequest(string, string2));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        Object object;
        Request<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        if (deleteObjectsRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteObjectsRequest.getMfa());
        }
        byte[] byArray = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        try {
            object = Md5Utils.computeMD5Hash((byte[])byArray);
            String string = BinaryUtils.toBase64((byte[])object);
            request.addHeader("Content-MD5", string);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)exception);
        }
        object = this.invoke(request, new Unmarshallers.DeleteObjectsResultUnmarshaller(), deleteObjectsRequest.getBucketName(), null);
        if (!((DeleteObjectsResponse)object).getErrors().isEmpty()) {
            throw new MultiObjectDeleteException(((DeleteObjectsResponse)object).getErrors(), ((DeleteObjectsResponse)object).getDeletedObjects());
        }
        return new DeleteObjectsResult(((DeleteObjectsResponse)object).getDeletedObjects());
    }

    @Override
    public void deleteVersion(String string, String string2, String string3) throws AmazonClientException, AmazonServiceException {
        this.deleteVersion(new DeleteVersionRequest(string, string2, string3));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)deleteVersionRequest, "The delete version request object must be specified when deleting a version");
        String string = deleteVersionRequest.getBucketName();
        String string2 = deleteVersionRequest.getKey();
        String string3 = deleteVersionRequest.getVersionId();
        this.assertParameterNotNull(string, "The bucket name must be specified when deleting a version");
        this.assertParameterNotNull(string2, "The key must be specified when deleting a version");
        this.assertParameterNotNull(string3, "The version ID must be specified when deleting a version");
        Request<DeleteVersionRequest> request = this.createRequest(string, string2, deleteVersionRequest, HttpMethodName.DELETE);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        if (deleteVersionRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteVersionRequest.getMfa());
        }
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String string = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration bucketVersioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting versioning configuration");
        this.assertParameterNotNull(bucketVersioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        if (bucketVersioningConfiguration.isMfaDeleteEnabled() != null) {
            this.assertParameterNotNull(setBucketVersioningConfigurationRequest.getMfa(), "The MFA parameter must be specified when changing MFA Delete status in the versioning configuration");
        }
        Request<SetBucketVersioningConfigurationRequest> request = this.createRequest(string, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        if (bucketVersioningConfiguration.isMfaDeleteEnabled() != null && setBucketVersioningConfigurationRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, setBucketVersioningConfigurationRequest.getMfa());
        }
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketVersioningConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String string) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when querying versioning configuration");
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller(), string, null);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String string) throws AmazonClientException, AmazonServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String string = getBucketWebsiteConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        Request<GetBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(request, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getStatusCode() == 404) {
                return null;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String string) {
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketLifecycleConfiguration(String string, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(string, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) {
        this.assertParameterNotNull((Object)setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String string = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.assertParameterNotNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        Request<SetBucketLifecycleConfigurationRequest> request = this.createRequest(string, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash((byte[])byArray);
            String string2 = BinaryUtils.toBase64((byte[])byArray2);
            request.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)exception);
        }
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String string) {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(string));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        this.assertParameterNotNull((Object)deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        String string = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        Request<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(string, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String string) {
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("cors", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String string, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(string, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) {
        this.assertParameterNotNull((Object)setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        String string = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.assertParameterNotNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        Request<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(string, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("cors", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash((byte[])byArray);
            String string2 = BinaryUtils.toBase64((byte[])byArray2);
            request.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)exception);
        }
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String string) {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(string));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) {
        this.assertParameterNotNull((Object)deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        String string = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        Request<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(string, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("cors", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String string) {
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("tagging", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketTaggingConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String string, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(string, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        this.assertParameterNotNull((Object)setBucketTaggingConfigurationRequest, "The set bucket tagging configuration request object must be specified.");
        String string = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting bucket tagging configuration.");
        this.assertParameterNotNull(bucketTaggingConfiguration, "The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        Request<SetBucketTaggingConfigurationRequest> request = this.createRequest(string, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash((byte[])byArray);
            String string2 = BinaryUtils.toBase64((byte[])byArray2);
            request.addHeader("Content-MD5", string2);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)exception);
        }
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String string) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(string));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        this.assertParameterNotNull((Object)deleteBucketTaggingConfigurationRequest, "The delete bucket tagging configuration request object must be specified.");
        String string = deleteBucketTaggingConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when deleting bucket tagging configuration.");
        Request<DeleteBucketTaggingConfigurationRequest> request = this.createRequest(string, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void setBucketWebsiteConfiguration(String string, BucketWebsiteConfiguration bucketWebsiteConfiguration) throws AmazonClientException, AmazonServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(string, bucketWebsiteConfiguration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String string = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration bucketWebsiteConfiguration = setBucketWebsiteConfigurationRequest.getConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.assertParameterNotNull(bucketWebsiteConfiguration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (bucketWebsiteConfiguration.getRedirectAllRequestsTo() == null) {
            this.assertParameterNotNull(bucketWebsiteConfiguration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        Request<SetBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketWebsiteConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String string) throws AmazonClientException, AmazonServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        String string = deleteBucketWebsiteConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        Request<DeleteBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void setBucketNotificationConfiguration(String string, BucketNotificationConfiguration bucketNotificationConfiguration) throws AmazonClientException, AmazonServiceException {
        this.setBucketNotificationConfiguration(new SetBucketNotificationConfigurationRequest(string, bucketNotificationConfiguration));
    }

    @Override
    public void setBucketNotificationConfiguration(SetBucketNotificationConfigurationRequest setBucketNotificationConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)setBucketNotificationConfigurationRequest, "The set bucket notification configuration request object must be specified.");
        String string = setBucketNotificationConfigurationRequest.getBucketName();
        BucketNotificationConfiguration bucketNotificationConfiguration = setBucketNotificationConfigurationRequest.getNotificationConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when setting bucket notification configuration.");
        this.assertParameterNotNull(bucketNotificationConfiguration, "The notification configuration parameter must be specified when setting bucket notification configuration.");
        Request<SetBucketNotificationConfigurationRequest> request = this.createRequest(string, null, setBucketNotificationConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("notification", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketNotificationConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(String string) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when querying notification configuration");
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("notification", null);
        return this.invoke(request, new Unmarshallers.BucketNotificationConfigurationUnmarshaller(), string, null);
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String string) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when requesting a bucket's logging status");
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.GET);
        request.addParameter("logging", null);
        return this.invoke(request, new Unmarshallers.BucketLoggingConfigurationnmarshaller(), string, null);
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)setBucketLoggingConfigurationRequest, "The set bucket logging configuration request object must be specified when enabling server access logging");
        String string = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration bucketLoggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when enabling server access logging");
        this.assertParameterNotNull(bucketLoggingConfiguration, "The logging configuration parameter must be specified when enabling server access logging");
        Request<SetBucketLoggingConfigurationRequest> request = this.createRequest(string, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("logging", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketLoggingConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketPolicy getBucketPolicy(String string) throws AmazonClientException, AmazonServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(string));
    }

    @Override
    public void setBucketPolicy(String string, String string2) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(string, "The bucket name must be specified when setting a bucket policy");
        this.assertParameterNotNull(string2, "The policy text must be specified when setting a bucket policy");
        Request<GenericBucketRequest> request = this.createRequest(string, null, new GenericBucketRequest(string), HttpMethodName.PUT);
        request.addParameter("policy", null);
        request.setContent((InputStream)new ByteArrayInputStream(ServiceUtils.toByteArray(string2)));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketPolicy(String string) throws AmazonClientException, AmazonServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(string));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)getBucketPolicyRequest, "The request object must be specified when getting a bucket policy");
        String string = getBucketPolicyRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name must be specified when getting a bucket policy");
        Request<GetBucketPolicyRequest> request = this.createRequest(string, null, getBucketPolicyRequest, HttpMethodName.GET);
        request.addParameter("policy", null);
        BucketPolicy bucketPolicy = new BucketPolicy();
        try {
            String string2 = this.invoke(request, new S3StringResponseHandler(), string, null);
            bucketPolicy.setPolicyText(string2);
            return bucketPolicy;
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getErrorCode().equals("NoSuchBucketPolicy")) {
                return bucketPolicy;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)setBucketPolicyRequest, "The request object must be specified when setting a bucket policy");
        String string = setBucketPolicyRequest.getBucketName();
        String string2 = setBucketPolicyRequest.getPolicyText();
        this.assertParameterNotNull(string, "The bucket name must be specified when setting a bucket policy");
        this.assertParameterNotNull(string2, "The policy text must be specified when setting a bucket policy");
        Request<SetBucketPolicyRequest> request = this.createRequest(string, null, setBucketPolicyRequest, HttpMethodName.PUT);
        request.addParameter("policy", null);
        request.setContent((InputStream)new ByteArrayInputStream(ServiceUtils.toByteArray(string2)));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)deleteBucketPolicyRequest, "The request object must be specified when deleting a bucket policy");
        String string = deleteBucketPolicyRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name must be specified when deleting a bucket policy");
        Request<DeleteBucketPolicyRequest> request = this.createRequest(string, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        request.addParameter("policy", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date) throws AmazonClientException {
        return this.generatePresignedUrl(string, string2, date, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date, HttpMethod httpMethod) throws AmazonClientException {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(string, string2, httpMethod);
        generatePresignedUrlRequest.setExpiration(date);
        return this.generatePresignedUrl(generatePresignedUrlRequest);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws AmazonClientException {
        this.assertParameterNotNull((Object)generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        String string = generatePresignedUrlRequest.getBucketName();
        String string2 = generatePresignedUrlRequest.getKey();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when generating a pre-signed URL");
        this.assertParameterNotNull(generatePresignedUrlRequest.getMethod(), "The HTTP method request parameter must be specified when generating a pre-signed URL");
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethodName = HttpMethodName.valueOf((String)generatePresignedUrlRequest.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(string, string2, generatePresignedUrlRequest, httpMethodName);
        for (Map.Entry<String, String> entry : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (generatePresignedUrlRequest.getContentType() != null) {
            request.addHeader("Content-Type", generatePresignedUrlRequest.getContentType());
        }
        if (generatePresignedUrlRequest.getContentMd5() != null) {
            request.addHeader("Content-MD5", generatePresignedUrlRequest.getContentMd5());
        }
        AmazonS3Client.populateSseCpkRequestParameters(request, generatePresignedUrlRequest.getSSECustomerKey());
        AmazonS3Client.addResponseHeaderParameters(request, generatePresignedUrlRequest.getResponseHeaders());
        Signer signer = this.createSigner(request, string, string2);
        if (signer instanceof Presigner) {
            ((Presigner)signer).presignRequest(request, this.awsCredentialsProvider.getCredentials(), generatePresignedUrlRequest.getExpiration());
        } else {
            this.presignRequest(request, generatePresignedUrlRequest.getMethod(), string, string2, generatePresignedUrlRequest.getExpiration(), null);
        }
        return ServiceUtils.convertRequestToUrl(request, true);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String string = abortMultipartUploadRequest.getBucketName();
        String string2 = abortMultipartUploadRequest.getKey();
        Request<AbortMultipartUploadRequest> request = this.createRequest(string, string2, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String string = completeMultipartUploadRequest.getBucketName();
        String string2 = completeMultipartUploadRequest.getKey();
        String string3 = completeMultipartUploadRequest.getUploadId();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(string2, "The key parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(string3, "The upload ID parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        Request<CompleteMultipartUploadRequest> request = this.createRequest(string, string2, completeMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploadId", string3);
        byte[] byArray = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler());
        XmlResponsesSaxParser.CompleteMultipartUploadHandler completeMultipartUploadHandler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHeaderHandlerChain, string, string2);
        if (completeMultipartUploadHandler.getCompleteMultipartUploadResult() != null) {
            String string4 = responseHeaderHandlerChain.getResponseHeaders().get("x-amz-version-id");
            completeMultipartUploadHandler.getCompleteMultipartUploadResult().setVersionId(string4);
            return completeMultipartUploadHandler.getCompleteMultipartUploadResult();
        }
        throw completeMultipartUploadHandler.getAmazonS3Exception();
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-amz-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        AmazonS3Client.populateSseCpkRequestParameters(request, initiateMultipartUploadRequest.getSSECustomerKey());
        this.setZeroContentLength(request);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHeaderHandlerChain, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.assertParameterNotNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        Request<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller(), listMultipartUploadsRequest.getBucketName(), null);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull((Object)listPartsRequest, "The request parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller(), listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        ProgressListener progressListener;
        ProgressListenerCallbackExecutor progressListenerCallbackExecutor;
        this.assertParameterNotNull((Object)uploadPartRequest, "The request parameter must be specified when uploading a part");
        String string = uploadPartRequest.getBucketName();
        String string2 = uploadPartRequest.getKey();
        String string3 = uploadPartRequest.getUploadId();
        int n = uploadPartRequest.getPartNumber();
        long l = uploadPartRequest.getPartSize();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when uploading a part");
        this.assertParameterNotNull(string2, "The key parameter must be specified when uploading a part");
        this.assertParameterNotNull(string3, "The upload ID parameter must be specified when uploading a part");
        this.assertParameterNotNull(n, "The part number parameter must be specified when uploading a part");
        this.assertParameterNotNull(l, "The part size parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(string, string2, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", string3);
        request.addParameter("partNumber", Integer.toString(n));
        AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", uploadPartRequest.getMd5Digest());
        request.addHeader("Content-Length", Long.toString(l));
        AmazonS3Client.populateSseCpkRequestParameters(request, uploadPartRequest.getSSECustomerKey());
        Object object = null;
        if (uploadPartRequest.getInputStream() != null) {
            object = uploadPartRequest.getInputStream();
        } else if (uploadPartRequest.getFile() != null) {
            try {
                object = new InputSubstream((InputStream)((Object)new RepeatableFileInputStream(uploadPartRequest.getFile())), uploadPartRequest.getFileOffset(), l, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException("The specified file doesn't exist", fileNotFoundException);
            }
        } else {
            throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
        }
        MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream = null;
        if (uploadPartRequest.getMd5Digest() == null && !AmazonS3Client.skipContentMd5IntegrityCheck(uploadPartRequest)) {
            mD5DigestCalculatingInputStream = new MD5DigestCalculatingInputStream((InputStream)object);
            object = mD5DigestCalculatingInputStream;
        }
        if ((progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener((ProgressListener)(progressListener = uploadPartRequest.getGeneralProgressListener()))) != null) {
            object = new ProgressReportingInputStream((InputStream)object, progressListenerCallbackExecutor);
            this.fireProgressEvent(progressListenerCallbackExecutor, 1024);
        }
        try {
            Object object2;
            Object object3;
            request.setContent((InputStream)object);
            ObjectMetadata objectMetadata = this.invoke(request, new S3MetadataResponseHandler(), string, string2);
            if (objectMetadata != null && mD5DigestCalculatingInputStream != null && !Arrays.equals((byte[])(object3 = mD5DigestCalculatingInputStream.getMd5Digest()), object2 = BinaryUtils.fromHex((String)objectMetadata.getETag()))) {
                throw new AmazonClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by Amazon S3.  You may need to delete the data stored in Amazon S3.");
            }
            this.fireProgressEvent(progressListenerCallbackExecutor, 2048);
            object3 = new UploadPartResult();
            ((UploadPartResult)object3).setETag(objectMetadata.getETag());
            ((UploadPartResult)object3).setPartNumber(n);
            ((SSEResultBase)object3).setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
            ((SSEResultBase)object3).setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            ((SSEResultBase)object3).setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            object2 = object3;
            return object2;
        }
        catch (AmazonClientException amazonClientException) {
            this.fireProgressEvent(progressListenerCallbackExecutor, 4096);
            this.fireProgressEvent(progressListenerCallbackExecutor, 2048);
            throw amazonClientException;
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return (S3ResponseMetadata)this.client.getResponseMetadataForRequest(amazonWebServiceRequest);
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws AmazonServiceException {
        String string = restoreObjectRequest.getBucketName();
        String string2 = restoreObjectRequest.getKey();
        String string3 = restoreObjectRequest.getVersionId();
        int n = restoreObjectRequest.getExpirationInDays();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified when copying a glacier object");
        this.assertParameterNotNull(string2, "The key parameter must be specified when copying a glacier object");
        if (n == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a glacier object");
        }
        Request<RestoreObjectRequest> request = this.createRequest(string, string2, restoreObjectRequest, HttpMethodName.POST);
        request.addParameter("restore", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        byte[] byArray = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash((byte[])byArray);
            String string4 = BinaryUtils.toBase64((byte[])byArray2);
            request.addHeader("Content-MD5", string4);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)exception);
        }
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    @Override
    public void restoreObject(String string, String string2, int n) throws AmazonServiceException {
        this.restoreObject(new RestoreObjectRequest(string, string2, n));
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private void fireProgressEvent(ProgressListenerCallbackExecutor progressListenerCallbackExecutor, int n) {
        if (progressListenerCallbackExecutor == null) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(0L);
        progressEvent.setEventCode(n);
        progressListenerCallbackExecutor.progressChanged(progressEvent);
    }

    private AccessControlList getAcl(String string, String string2, String string3, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        return this.invoke(request, new Unmarshallers.AccessControlListUnmarshaller(), string, string2);
    }

    private void setAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-amz-acl", cannedAccessControlList.toString());
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    private void setAcl(String string, String string2, String string3, AccessControlList accessControlList, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        byte[] byArray = new AclXmlFactory().convertToXmlByteArray(accessControlList);
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    protected Signer createSigner(Request<?> request, String string, String string2) {
        Signer signer = this.getSigner();
        if (this.upgradeToSigV4() && !(signer instanceof AWSS3V4Signer)) {
            AWSS3V4Signer aWSS3V4Signer = new AWSS3V4Signer();
            aWSS3V4Signer.setServiceName(this.getServiceNameIntern());
            String string3 = this.getSignerRegionOverride();
            if (string3 == null) {
                if (!this.hasExplicitRegion) {
                    throw new AmazonClientException("Signature Version 4 requires knowing the region of the bucket you're trying to access. You can configure a region by calling AmazonS3Client.setRegion(Region) or AmazonS3Client.setEndpoint(String) with a region-specific endpoint such as \"s3-us-west-2.amazonaws.com\".");
                }
            } else {
                aWSS3V4Signer.setRegionName(string3);
            }
            return aWSS3V4Signer;
        }
        if (signer instanceof S3Signer) {
            String string4 = "/" + (string != null ? string + "/" : "") + (string2 != null ? string2 : "");
            return new S3Signer(request.getHttpMethod().toString(), string4);
        }
        return signer;
    }

    private boolean upgradeToSigV4() {
        if (System.getProperty("com.amazonaws.services.s3.enforceV4") != null) {
            return true;
        }
        return System.getProperty("com.amazonaws.services.s3.enableV4") != null && !this.endpoint.getHost().endsWith(Constants.S3_HOSTNAME);
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod httpMethod, String string, String string2, Date date, String string3) {
        this.beforeRequest(request);
        String string4 = "/" + (string != null ? string + "/" : "") + (string2 != null ? HttpUtils.urlEncode((String)string2, (boolean)true) : "") + (string3 != null ? "?" + string3 : "");
        string4 = string4.replaceAll("(?<=/)/", "%2F");
        AWSCredentials aWSCredentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        if (amazonWebServiceRequest != null && amazonWebServiceRequest.getRequestCredentials() != null) {
            aWSCredentials = amazonWebServiceRequest.getRequestCredentials();
        }
        new S3QueryStringSigner(httpMethod.toString(), string4, date).sign(request, aWSCredentials);
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String string5 = (String)request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", string5);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private <T> void beforeRequest(Request<T> request) {
        if (this.requestHandler2s != null) {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.beforeRequest(request);
            }
        }
    }

    private URI convertToVirtualHostEndpoint(String string) {
        try {
            return new URI(this.endpoint.getScheme() + "://" + string + "." + this.endpoint.getAuthority());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid bucket name: " + string, uRISyntaxException);
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata objectMetadata) {
        Object object;
        Object object2;
        Map<String, Object> map = objectMetadata.getRawMetadata();
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                request.addHeader((String)object.getKey(), object.getValue().toString());
            }
        }
        if ((object2 = objectMetadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date((Date)object2));
        }
        if ((object = objectMetadata.getUserMetadata()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string != null) {
                    string = string.trim();
                }
                if (string2 != null) {
                    string2 = string2.trim();
                }
                request.addHeader("x-amz-meta-" + string, string2);
            }
        }
    }

    private void populateRequestWithMfaDetails(Request<?> request, MultiFactorAuthentication multiFactorAuthentication) {
        if (multiFactorAuthentication == null) {
            return;
        }
        String string = request.getEndpoint().toString();
        if (string.startsWith("http://")) {
            String string2 = string.replace("http://", "https://");
            request.setEndpoint(URI.create(string2));
            log.info((Object)"Overriding current endpoint to use HTTPS as required by S3 for requests containing an MFA header");
        }
        request.addHeader("x-amz-mfa", multiFactorAuthentication.getDeviceSerialNumber() + " " + multiFactorAuthentication.getToken());
    }

    private static void populateRequestWithCopyObjectParameters(Request<? extends AmazonWebServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        ObjectMetadata objectMetadata;
        String string = "/" + HttpUtils.urlEncode((String)copyObjectRequest.getSourceBucketName(), (boolean)true) + "/" + HttpUtils.urlEncode((String)copyObjectRequest.getSourceKey(), (boolean)true);
        if (copyObjectRequest.getSourceVersionId() != null) {
            string = string + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", string);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        if ((objectMetadata = copyObjectRequest.getNewObjectMetadata()) != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        AmazonS3Client.populateSourceSseCpkRequestParameters(request, copyObjectRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSseCpkRequestParameters(request, copyObjectRequest.getDestinationSSECustomerKey());
    }

    private static void populateRequestWithCopyPartParameters(Request<?> request, CopyPartRequest copyPartRequest) {
        String string = "/" + HttpUtils.urlEncode((String)copyPartRequest.getSourceBucketName(), (boolean)true) + "/" + HttpUtils.urlEncode((String)copyPartRequest.getSourceKey(), (boolean)true);
        if (copyPartRequest.getSourceVersionId() != null) {
            string = string + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", string);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String string2 = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-amz-copy-source-range", string2);
        }
        AmazonS3Client.populateSourceSseCpkRequestParameters(request, copyPartRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSseCpkRequestParameters(request, copyPartRequest.getDestinationSSECustomerKey());
    }

    private static void populateSseCpkRequestParameters(Request<?> request, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key", sSECustomerKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode((String)string);
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])byArray));
        }
    }

    private static void populateSourceSseCpkRequestParameters(Request<?> request, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key", sSECustomerKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode((String)string);
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])byArray));
        }
    }

    private static void addHeaderIfNotNull(Request<?> request, String string, String string2) {
        if (string2 != null) {
            request.addHeader(string, string2);
        }
    }

    private static void addDateHeader(Request<?> request, String string, Date date) {
        if (date != null) {
            request.addHeader(string, ServiceUtils.formatRfc822Date(date));
        }
    }

    private static void addStringListHeader(Request<?> request, String string, List<String> list) {
        if (list != null && !list.isEmpty()) {
            request.addHeader(string, ServiceUtils.join(list));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaderOverrides) {
        if (responseHeaderOverrides != null) {
            if (responseHeaderOverrides.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaderOverrides.getCacheControl());
            }
            if (responseHeaderOverrides.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaderOverrides.getContentDisposition());
            }
            if (responseHeaderOverrides.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaderOverrides.getContentEncoding());
            }
            if (responseHeaderOverrides.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaderOverrides.getContentLanguage());
            }
            if (responseHeaderOverrides.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaderOverrides.getContentType());
            }
            if (responseHeaderOverrides.getExpires() != null) {
                request.addParameter("response-expires", responseHeaderOverrides.getExpires());
            }
        }
    }

    public String getResourceUrl(String string, String string2) {
        try {
            return this.getUrl(string, string2).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URL getUrl(String string, String string2) {
        DefaultRequest defaultRequest = new DefaultRequest(Constants.S3_SERVICE_NAME);
        this.configRequest((Request<?>)defaultRequest, string, string2);
        return ServiceUtils.convertRequestToUrl(defaultRequest);
    }

    public Region getRegion() {
        String string = this.endpoint.getAuthority();
        if (Constants.S3_HOSTNAME.equals(string)) {
            return Region.US_Standard;
        }
        Matcher matcher = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            return Region.fromValue(matcher.group(1));
        }
        throw new IllegalStateException("S3 client with invalid S3 endpoint configured");
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String string, String string2, X x, HttpMethodName httpMethodName) {
        DefaultRequest defaultRequest = new DefaultRequest(x, Constants.S3_SERVICE_NAME);
        defaultRequest.setHttpMethod(httpMethodName);
        this.configRequest((Request<?>)defaultRequest, string, string2);
        return defaultRequest;
    }

    private void configRequest(Request<?> request, String string, String string2) {
        if (!this.clientOptions.isPathStyleAccess() && BucketNameUtils.isDNSBucketName(string) && !this.validIP(this.endpoint.getHost())) {
            request.setEndpoint(this.convertToVirtualHostEndpoint(string));
            if (string2 != null && string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            request.setResourcePath(string2);
        } else {
            request.setEndpoint(this.endpoint);
            if (string != null) {
                request.setResourcePath(string + "/" + (string2 != null ? string2 : ""));
            }
        }
    }

    private boolean validIP(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return false;
        }
        for (String string2 : stringArray) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n >= 0 && n <= 255) continue;
            return false;
        }
        return true;
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String string, String string2) {
        return this.invoke(request, new S3XmlResponseHandler<X>(unmarshaller), string, string2);
    }

    protected final ExecutionContext createExecutionContext(AmazonWebServiceRequest amazonWebServiceRequest) {
        boolean bl = this.isRequestMetricsEnabled(amazonWebServiceRequest) || AmazonS3Client.isProfilingEnabled();
        return new S3ExecutionContext(this.requestHandler2s, bl, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, String string, String string2) {
        Object object;
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        ExecutionContext executionContext = this.createExecutionContext(amazonWebServiceRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        request.setAWSRequestMetrics(aWSRequestMetrics);
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Response response = null;
        try {
            for (Map.Entry object2 : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
                request.addParameter((String)object2.getKey(), (String)object2.getValue());
            }
            request.setTimeOffset(this.timeOffset);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            }
            AWSCredentials aWSCredentials = this.awsCredentialsProvider.getCredentials();
            if (amazonWebServiceRequest.getRequestCredentials() != null) {
                aWSCredentials = amazonWebServiceRequest.getRequestCredentials();
            }
            executionContext.setSigner(this.createSigner(request, string, string2));
            executionContext.setCredentials(aWSCredentials);
            response = this.client.execute(request, httpResponseHandler, (HttpResponseHandler)this.errorResponseHandler, executionContext);
            object = response.getAwsResponse();
        }
        catch (Throwable throwable) {
            this.endClientExecution(aWSRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(aWSRequestMetrics, request, response);
        return (X)object;
    }

    @Override
    public void enableRequesterPays(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.Requester);
        this.setBucketRequestPayment(new SetRequestPaymentConfigurationRequest(string, requestPaymentConfiguration));
    }

    @Override
    public void disableRequesterPays(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.BucketOwner);
        this.setBucketRequestPayment(new SetRequestPaymentConfigurationRequest(string, requestPaymentConfiguration));
    }

    @Override
    public boolean isRequesterPaysEnabled(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = this.getBucketRequestPayment(new GetRequestPaymentConfigurationRequest(string));
        return requestPaymentConfiguration.getPayer() == RequestPaymentConfiguration.Payer.Requester;
    }

    private void setBucketRequestPayment(SetRequestPaymentConfigurationRequest setRequestPaymentConfigurationRequest) {
        String string = setRequestPaymentConfigurationRequest.getBucketName();
        RequestPaymentConfiguration requestPaymentConfiguration = setRequestPaymentConfigurationRequest.getConfiguration();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified while setting the Requester Pays.");
        this.assertParameterNotNull(requestPaymentConfiguration, "The request payment configuration parameter must be specified when setting the Requester Pays.");
        Request<SetRequestPaymentConfigurationRequest> request = this.createRequest(string, null, setRequestPaymentConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] byArray = requestPaymentConfigurationXmlFactory.convertToXmlByteArray(requestPaymentConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    private RequestPaymentConfiguration getBucketRequestPayment(GetRequestPaymentConfigurationRequest getRequestPaymentConfigurationRequest) {
        String string = getRequestPaymentConfigurationRequest.getBucketName();
        this.assertParameterNotNull(string, "The bucket name parameter must be specified while getting the Request Payment Configuration.");
        Request<GetRequestPaymentConfigurationRequest> request = this.createRequest(string, null, getRequestPaymentConfigurationRequest, HttpMethodName.GET);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        return this.invoke(request, new Unmarshallers.RequestPaymentConfigurationUnmarshaller(), string, null);
    }

    private void setZeroContentLength(Request<?> request) {
        request.addHeader("Content-Length", String.valueOf(0));
    }

    static {
        AwsSdkMetrics.addAll(Arrays.asList(S3ServiceMetric.values()));
        SignerFactory.registerSigner((String)S3_SIGNER, S3Signer.class);
        SignerFactory.registerSigner((String)S3_V4_SIGNER, AWSS3V4Signer.class);
        bucketConfigurationXmlFactory = new BucketConfigurationXmlFactory();
        requestPaymentConfigurationXmlFactory = new RequestPaymentConfigurationXmlFactory();
    }
}

