/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;

public class CopyPartRequestFactory {
    private final String uploadId;
    private final long optimalPartSize;
    private final CopyObjectRequest copyObjectRequest;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;

    public CopyPartRequestFactory(CopyObjectRequest copyObjectRequest, String string, long l, long l2) {
        this.copyObjectRequest = copyObjectRequest;
        this.uploadId = string;
        this.optimalPartSize = l;
        this.remainingBytes = l2;
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized CopyPartRequest getNextCopyPartRequest() {
        long l = Math.min(this.optimalPartSize, this.remainingBytes);
        CopyPartRequest copyPartRequest = new CopyPartRequest().withSourceBucketName(this.copyObjectRequest.getSourceBucketName()).withSourceKey(this.copyObjectRequest.getSourceKey()).withUploadId(this.uploadId).withPartNumber(this.partNumber++).withDestinationBucketName(this.copyObjectRequest.getDestinationBucketName()).withDestinationKey(this.copyObjectRequest.getDestinationKey()).withSourceVersionId(this.copyObjectRequest.getSourceVersionId()).withFirstByte(new Long(this.offset)).withLastByte(new Long(this.offset + l - 1L)).withSourceSSECustomerKey(this.copyObjectRequest.getSourceSSECustomerKey()).withDestinationSSECustomerKey(this.copyObjectRequest.getDestinationSSECustomerKey());
        this.setOtherMetadataInRequest(copyPartRequest);
        this.offset += l;
        this.remainingBytes -= l;
        return copyPartRequest;
    }

    private void setOtherMetadataInRequest(CopyPartRequest copyPartRequest) {
        if (this.copyObjectRequest.getMatchingETagConstraints() != null) {
            copyPartRequest.setMatchingETagConstraints(this.copyObjectRequest.getMatchingETagConstraints());
        }
        if (this.copyObjectRequest.getModifiedSinceConstraint() != null) {
            copyPartRequest.setModifiedSinceConstraint(this.copyObjectRequest.getModifiedSinceConstraint());
        }
        if (this.copyObjectRequest.getNonmatchingETagConstraints() != null) {
            copyPartRequest.setNonmatchingETagConstraints(this.copyObjectRequest.getNonmatchingETagConstraints());
        }
        if (this.copyObjectRequest.getSourceVersionId() != null) {
            copyPartRequest.setSourceVersionId(this.copyObjectRequest.getSourceVersionId());
        }
        if (this.copyObjectRequest.getUnmodifiedSinceConstraint() != null) {
            copyPartRequest.setUnmodifiedSinceConstraint(this.copyObjectRequest.getUnmodifiedSinceConstraint());
        }
    }
}

